/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.validation.constraints.NotNull;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class TicketGrantingTicketCheckAction {
    public static final String NOT_EXISTS = "notExists";
    public static final String INVALID = "invalid";
    public static final String VALID = "valid";
    @NotNull
    private final TicketRegistry ticketRegistry;

    public TicketGrantingTicketCheckAction(TicketRegistry registry) {
        this.ticketRegistry = registry;
    }

    public Event checkValidity(RequestContext requestContext) {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
        if (!StringUtils.hasText((String)tgtId)) {
            return new Event((Object)this, NOT_EXISTS);
        }
        Ticket ticket = this.ticketRegistry.getTicket(tgtId);
        return new Event((Object)this, ticket != null && !ticket.isExpired() ? VALID : INVALID);
    }
}

