/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.web;

import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public final class RegisteredServiceThemeBasedViewResolver
extends InternalResourceViewResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceThemeBasedViewResolver.class);
    private static final String DEFAULT_PATH_PREFIX = "/WEB-INF/view/jsp";
    private final ServicesManager servicesManager;
    private final String defaultThemeId;
    private String pathPrefix = "/WEB-INF/view/jsp";

    public RegisteredServiceThemeBasedViewResolver(String defaultThemeId, ServicesManager servicesManager) {
        super.setCache(false);
        this.defaultThemeId = defaultThemeId;
        this.servicesManager = servicesManager;
    }

    protected AbstractUrlBasedView buildView(String viewName) throws Exception {
        RequestContext requestContext = RequestContextHolder.getRequestContext();
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        String themeId = service != null && registeredService != null && registeredService.getAccessStrategy().isServiceAccessAllowed() && StringUtils.hasText((String)registeredService.getTheme()) ? registeredService.getTheme() : this.defaultThemeId;
        String themePrefix = String.format("%s/%s/ui/", this.pathPrefix, themeId);
        LOGGER.debug("Prefix {} set for service {} with theme {}", new Object[]{themePrefix, service, themeId});
        InternalResourceView view = (InternalResourceView)BeanUtils.instantiateClass((Class)this.getViewClass());
        view.setUrl(themePrefix + viewName + this.getSuffix());
        String contentType = this.getContentType();
        if (contentType != null) {
            view.setContentType(contentType);
        }
        view.setRequestContextAttribute(this.getRequestContextAttribute());
        view.setAttributesMap(this.getAttributesMap());
        view.setAlwaysInclude(false);
        view.setExposeContextBeansAsAttributes(false);
        view.setPreventDispatchLoop(true);
        LOGGER.debug("View resolved: {}", (Object)view.getUrl());
        return view;
    }

    public void setCache(boolean cache) {
        LOGGER.warn("The {} does not support caching. Turned off caching forcefully.", (Object)((Object)((Object)this)).getClass().getSimpleName());
        super.setCache(false);
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }
}

