/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.web.support.CookieRetrievingCookieGenerator;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class SendTicketGrantingTicketAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendTicketGrantingTicketAction.class);
    private boolean createSsoSessionCookieOnRenewAuthentications = true;
    @NotNull
    private CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    @NotNull
    private final CentralAuthenticationService centralAuthenticationService;
    @NotNull
    private final ServicesManager servicesManager;

    public SendTicketGrantingTicketAction(CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.centralAuthenticationService = centralAuthenticationService;
        this.servicesManager = servicesManager;
    }

    protected Event doExecute(RequestContext context) {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        String ticketGrantingTicketValueFromCookie = (String)context.getFlowScope().get("ticketGrantingTicketId");
        if (ticketGrantingTicketId == null) {
            return this.success();
        }
        if (this.isAuthenticatingAtPublicWorkstation(context)) {
            LOGGER.info("Authentication is at a public workstation. SSO cookie will not be generated. Subsequent requests will be challenged for authentication.");
        } else if (!this.createSsoSessionCookieOnRenewAuthentications && this.isAuthenticationRenewed(context)) {
            LOGGER.info("Authentication session is renewed but CAS is not configured to create the SSO session. SSO cookie will not be generated. Subsequent requests will be challenged for authentication.");
        } else {
            this.ticketGrantingTicketCookieGenerator.addCookie(WebUtils.getHttpServletRequest((RequestContext)context), WebUtils.getHttpServletResponse((RequestContext)context), ticketGrantingTicketId);
        }
        if (ticketGrantingTicketValueFromCookie != null && !ticketGrantingTicketId.equals(ticketGrantingTicketValueFromCookie)) {
            this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketValueFromCookie);
        }
        return this.success();
    }

    @Deprecated
    public void setTicketGrantingTicketCookieGenerator(CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator) {
        this.logger.warn((Object)"setTicketGrantingTicketCookieGenerator() is deprecated and has no effect. Use constructors instead.");
    }

    @Deprecated
    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.logger.warn((Object)"setCentralAuthenticationService() is deprecated and has no effect. Use constructors instead.");
    }

    public void setCreateSsoSessionCookieOnRenewAuthentications(boolean createSsoSessionCookieOnRenewAuthentications) {
        this.createSsoSessionCookieOnRenewAuthentications = createSsoSessionCookieOnRenewAuthentications;
    }

    @Deprecated
    public void setServicesManager(ServicesManager servicesManager) {
        this.logger.warn((Object)"setServicesManager() is deprecated and has no effect. Use constructors instead.");
    }

    private boolean isAuthenticationRenewed(RequestContext ctx) {
        RegisteredService registeredService;
        if (ctx.getRequestParameters().contains("renew")) {
            LOGGER.debug("[{}] is specified for the request. The authentication session will be considered renewed.", (Object)"renew");
            return true;
        }
        WebApplicationService service = WebUtils.getService((RequestContext)ctx);
        if (service != null && (registeredService = this.servicesManager.findServiceBy((Service)service)) != null) {
            boolean isAllowedForSso = registeredService.getAccessStrategy().isServiceAccessAllowedForSso();
            LOGGER.debug("Located [{}] in registry. Service access to participate in SSO is set to [{}]", (Object)registeredService.getServiceId(), (Object)isAllowedForSso);
            return !isAllowedForSso;
        }
        return false;
    }

    private boolean isAuthenticatingAtPublicWorkstation(RequestContext ctx) {
        if (ctx.getFlowScope().contains("publicWorkstation")) {
            LOGGER.debug("Public workstation flag detected. SSO session will be considered renewed.");
            return true;
        }
        return false;
    }
}

