/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.report;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jasig.cas.util.AbstractJacksonBackedJsonSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="internalConfigController")
@RequestMapping(value={"/status/config"})
public final class InternalConfigStateController {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalConfigStateController.class);
    private static final String VIEW_CONFIG = "monitoring/viewConfig";
    private static final String[] INCLUDE_PACKAGES = new String[]{"org.jasig"};
    @Autowired(required=true)
    private ApplicationContext applicationContext;
    @Autowired(required=true)
    @Qualifier(value="casProperties")
    private Properties casProperties;

    @RequestMapping(method={RequestMethod.GET})
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, Object> list = InternalConfigStateController.getBeans(this.applicationContext);
        LOGGER.debug("Found [{}] beans to report", (Object)list.size());
        BeanObjectJsonSerializer serializer = new BeanObjectJsonSerializer();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        Set<Map.Entry<String, Object>> entries = list.entrySet();
        Iterator<Map.Entry<String, Object>> it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            Object obj = entry.getValue();
            StringWriter writer = new StringWriter();
            writer.append('{');
            writer.append('\"' + entry.getKey() + "\":");
            serializer.toJson(writer, obj);
            writer.append('}');
            builder.append(writer);
            if (!it.hasNext()) continue;
            builder.append(',');
        }
        builder.append(']');
        ModelAndView mv = new ModelAndView(VIEW_CONFIG);
        String jsonData = StringEscapeUtils.escapeJson((String)builder.toString());
        mv.addObject("jsonData", (Object)jsonData);
        mv.addObject("properties", this.casProperties.entrySet());
        return mv;
    }

    private static Map<String, Object> getBeans(ApplicationContext ctx) {
        String[] all = BeanFactoryUtils.beanNamesIncludingAncestors((ListableBeanFactory)ctx);
        HashMap<String, Object> singletons = new HashMap<String, Object>(all.length);
        for (String name : all) {
            try {
                Object object = ctx.getBean(name);
                if (object == null) continue;
                boolean foundPackage = false;
                String packageName = object.getClass().getPackage().getName();
                for (int i = 0; !foundPackage && i < INCLUDE_PACKAGES.length; ++i) {
                    foundPackage = packageName.startsWith(INCLUDE_PACKAGES[i]);
                }
                if (!foundPackage) continue;
                singletons.put(name, object);
            }
            catch (BeanIsAbstractException e) {
                LOGGER.debug("Skipping abstract bean definition. {}", (Object)e.getMessage());
            }
            catch (Throwable e) {
                LOGGER.trace(e.getMessage(), e);
            }
        }
        return singletons;
    }

    private static final class BeanObjectJsonSerializer
    extends AbstractJacksonBackedJsonSerializer<Object> {
        private static final long serialVersionUID = 691461175315322624L;

        public BeanObjectJsonSerializer() {
            super((PrettyPrinter)new MinimalPrettyPrinter());
        }

        protected ObjectMapper initializeObjectMapper() {
            ObjectMapper mapper = super.initializeObjectMapper();
            SimpleFilterProvider filters = new SimpleFilterProvider().addFilter("beanObjectFilter", (SimpleBeanPropertyFilter)new CasSimpleBeanObjectFilter());
            mapper.setFilters((FilterProvider)filters);
            mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
            mapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
            mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            mapper.addMixIn(Object.class, CasSimpleBeanObjectFilter.class);
            mapper.disable(SerializationFeature.INDENT_OUTPUT);
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            return mapper;
        }

        protected Class<Object> getTypeToSerialize() {
            return Object.class;
        }

        @JsonFilter(value="beanObjectFilter")
        private static class CasSimpleBeanObjectFilter
        extends SimpleBeanPropertyFilter {
            private static final Logger LOGGER = LoggerFactory.getLogger(CasSimpleBeanObjectFilter.class);
            private static final String[] EXCLUDE_FIELDS = new String[]{"logger"};

            private CasSimpleBeanObjectFilter() {
            }

            public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
                try {
                    if (!this.canSerializeField(pojo, writer)) {
                        return;
                    }
                    super.serializeAsField(pojo, jgen, provider, writer);
                }
                catch (Exception e) {
                    LOGGER.debug(e.getMessage());
                }
            }

            private boolean canSerializeField(Object pojo, PropertyWriter writer) {
                boolean foundPackage = false;
                String packageName = pojo.getClass().getPackage().getName();
                for (int i = 0; !foundPackage && i < INCLUDE_PACKAGES.length; ++i) {
                    foundPackage = packageName.startsWith(INCLUDE_PACKAGES[i]);
                }
                if (!foundPackage) {
                    LOGGER.trace("Package [{}] is ignored", (Object)packageName);
                    return false;
                }
                boolean foundField = true;
                String fieldName = writer.getFullName().getSimpleName();
                for (int i = 0; foundField && i < EXCLUDE_FIELDS.length; ++i) {
                    foundField = !fieldName.equalsIgnoreCase(EXCLUDE_FIELDS[i]);
                }
                if (!foundField) {
                    LOGGER.trace("Field [{}] is excluded", (Object)fieldName);
                    return false;
                }
                return true;
            }
        }
    }
}

