/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import java.lang.reflect.Method;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.web.support.CookieValueManager;
import org.jasig.cas.web.support.NoOpCookieValueManager;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.CookieGenerator;
import org.springframework.web.util.WebUtils;

public class CookieRetrievingCookieGenerator
extends CookieGenerator {
    private static final int DEFAULT_REMEMBER_ME_MAX_AGE = 7889231;
    private int rememberMeMaxAge = 7889231;
    private final CookieValueManager casCookieValueManager;

    public CookieRetrievingCookieGenerator() {
        this(new NoOpCookieValueManager());
    }

    public CookieRetrievingCookieGenerator(CookieValueManager casCookieValueManager) {
        Method setHttpOnlyMethod = ReflectionUtils.findMethod(Cookie.class, (String)"setHttpOnly", (Class[])new Class[]{Boolean.TYPE});
        if (setHttpOnlyMethod != null) {
            super.setCookieHttpOnly(true);
        } else {
            this.logger.debug((Object)"Cookie cannot be marked as HttpOnly; container is not using servlet 3.0.");
        }
        this.casCookieValueManager = casCookieValueManager;
    }

    public void addCookie(HttpServletRequest request, HttpServletResponse response, String cookieValue) {
        String theCookieValue = this.casCookieValueManager.buildCookieValue(cookieValue, request);
        if (!StringUtils.hasText((String)request.getParameter("rememberMe"))) {
            super.addCookie(response, theCookieValue);
        } else {
            Cookie cookie = this.createCookie(theCookieValue);
            cookie.setMaxAge(this.rememberMeMaxAge);
            if (this.isCookieSecure()) {
                cookie.setSecure(true);
            }
            response.addCookie(cookie);
        }
    }

    public void removeCookie(HttpServletResponse response) {
        Cookie cookie = this.createCookie("");
        cookie.setMaxAge(0);
        super.addCookie(response, "");
    }

    public String retrieveCookieValue(HttpServletRequest request) {
        try {
            Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.getCookieName());
            return cookie == null ? null : this.casCookieValueManager.obtainCookieValue(cookie, request);
        }
        catch (Exception e) {
            this.logger.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setRememberMeMaxAge(int maxAge) {
        this.rememberMeMaxAge = maxAge;
    }
}

