/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jasig.cas.authentication.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageContext;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AcceptableUsagePolicyFormAction {
    protected static final String EVENT_ID_MUST_ACCEPT = "mustAccept";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Boolean> policyMap = new ConcurrentHashMap<String, Boolean>();

    public Event verify(RequestContext context, Credential credential, MessageContext messageContext) {
        String key = credential.getId();
        if (this.policyMap.containsKey(key)) {
            Boolean hasAcceptedPolicy = this.policyMap.get(key);
            return hasAcceptedPolicy != false ? this.success() : this.accept();
        }
        return this.accept();
    }

    public Event submit(RequestContext context, Credential credential, MessageContext messageContext) {
        this.policyMap.put(credential.getId(), Boolean.TRUE);
        return this.success();
    }

    protected final Event success() {
        return new EventFactorySupport().success((Object)this);
    }

    protected final Event accept() {
        return new EventFactorySupport().event((Object)this, EVENT_ID_MUST_ACCEPT);
    }
}

