/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceAccessStrategy;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.jasig.cas.web.support.CookieRetrievingCookieGenerator;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;

public final class InitialFlowSetupAction
extends AbstractAction {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private ServicesManager servicesManager;
    @NotNull
    private CookieRetrievingCookieGenerator warnCookieGenerator;
    @NotNull
    private CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    @NotNull
    @Size(min=1)
    private List<ArgumentExtractor> argumentExtractors;
    private boolean enableFlowOnAbsentServiceRequest = true;

    protected Event doExecute(RequestContext context) throws Exception {
        String cookiePath;
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        String contextPath = context.getExternalContext().getContextPath();
        String string = cookiePath = StringUtils.isNotBlank((CharSequence)contextPath) ? contextPath + '/' : "/";
        if (StringUtils.isBlank((CharSequence)this.warnCookieGenerator.getCookiePath())) {
            this.logger.info("Setting path for cookies for warn cookie generator to: {} ", (Object)cookiePath);
            this.warnCookieGenerator.setCookiePath(cookiePath);
        } else {
            this.logger.debug("Warning cookie path is set to {} and path {}", (Object)this.warnCookieGenerator.getCookieDomain(), (Object)this.warnCookieGenerator.getCookiePath());
        }
        if (StringUtils.isBlank((CharSequence)this.ticketGrantingTicketCookieGenerator.getCookiePath())) {
            this.logger.info("Setting path for cookies for TGC cookie generator to: {} ", (Object)cookiePath);
            this.ticketGrantingTicketCookieGenerator.setCookiePath(cookiePath);
        } else {
            this.logger.debug("TGC cookie path is set to {} and path {}", (Object)this.ticketGrantingTicketCookieGenerator.getCookieDomain(), (Object)this.ticketGrantingTicketCookieGenerator.getCookiePath());
        }
        WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (String)this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request));
        WebUtils.putWarningCookie((RequestContext)context, (Boolean)Boolean.valueOf(this.warnCookieGenerator.retrieveCookieValue(request)));
        WebApplicationService service = WebUtils.getService(this.argumentExtractors, (RequestContext)context);
        if (service != null) {
            this.logger.debug("Placing service in context scope: [{}]", (Object)service.getId());
            RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
            if (registeredService != null && registeredService.getAccessStrategy().isServiceAccessAllowed()) {
                this.logger.debug("Placing registered service [{}] with id [{}] in context scope", (Object)registeredService.getServiceId(), (Object)registeredService.getId());
                WebUtils.putRegisteredService((RequestContext)context, (RegisteredService)registeredService);
                RegisteredServiceAccessStrategy accessStrategy = registeredService.getAccessStrategy();
                if (accessStrategy.getUnauthorizedRedirectUrl() != null) {
                    this.logger.debug("Placing registered service's unauthorized redirect url [{}] with id [{}] in context scope", (Object)accessStrategy.getUnauthorizedRedirectUrl(), (Object)registeredService.getServiceId());
                    WebUtils.putUnauthorizedRedirectUrl((RequestContext)context, (URI)accessStrategy.getUnauthorizedRedirectUrl());
                }
            }
        } else if (!this.enableFlowOnAbsentServiceRequest) {
            this.logger.warn("No service authentication request is available at [{}]. CAS is configured to disable the flow.", (Object)WebUtils.getHttpServletRequest((RequestContext)context).getRequestURL());
            throw new NoSuchFlowExecutionException(context.getFlowExecutionContext().getKey(), (Exception)((Object)new UnauthorizedServiceException("screen.service.required.message", "Service is required")));
        }
        WebUtils.putService((RequestContext)context, (Service)service);
        return this.result("success");
    }

    public void setTicketGrantingTicketCookieGenerator(CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }

    public void setWarnCookieGenerator(CookieRetrievingCookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }

    public void setArgumentExtractors(List<ArgumentExtractor> argumentExtractors) {
        this.argumentExtractors = argumentExtractors;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setEnableFlowOnAbsentServiceRequest(boolean enableFlowOnAbsentServiceRequest) {
        this.enableFlowOnAbsentServiceRequest = enableFlowOnAbsentServiceRequest;
    }
}

