/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.report;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="singleSignOnSessionsReportController")
@RequestMapping(value={"/statistics/ssosessions"})
public final class SingleSignOnSessionsReportController {
    private static final String VIEW_SSO_SESSIONS = "monitoring/viewSsoSessions";
    private static final String ROOT_REPORT_ACTIVE_SESSIONS_KEY = "activeSsoSessions";
    private static final String ROOT_REPORT_NA_KEY = "notAvailable";
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleSignOnSessionsReportController.class);
    private final ObjectMapper jsonMapper = new ObjectMapper();
    @Autowired
    private CentralAuthenticationService centralAuthenticationService;
    @Value(value="${sso.sessions.include.tgt:false}")
    private boolean includeTicketGrantingTicketId;

    public SingleSignOnSessionsReportController() {
        this.jsonMapper.disable(SerializationFeature.INDENT_OUTPUT);
        this.jsonMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    private Collection<Map<String, Object>> getSsoSessions() {
        ArrayList activeSessions = new ArrayList();
        for (Ticket ticket : this.getNonExpiredTicketGrantingTickets()) {
            TicketGrantingTicket tgt = (TicketGrantingTicket)ticket;
            HashMap<String, Object> sso = new HashMap<String, Object>(SsoSessionAttributeKeys.values().length);
            sso.put(SsoSessionAttributeKeys.AUTHENTICATED_PRINCIPAL.toString(), tgt.getAuthentication().getPrincipal().getId());
            sso.put(SsoSessionAttributeKeys.AUTHENTICATION_DATE.toString(), tgt.getAuthentication().getAuthenticationDate());
            sso.put(SsoSessionAttributeKeys.NUMBER_OF_USES.toString(), tgt.getCountOfUses());
            if (this.includeTicketGrantingTicketId) {
                sso.put(SsoSessionAttributeKeys.TICKET_GRANTING_TICKET.toString(), tgt.getId());
            }
            activeSessions.add(Collections.unmodifiableMap(sso));
        }
        return Collections.unmodifiableCollection(activeSessions);
    }

    private Collection<Ticket> getNonExpiredTicketGrantingTickets() {
        return this.centralAuthenticationService.getTickets(new Predicate(){

            public boolean apply(Object ticket) {
                if (ticket instanceof TicketGrantingTicket) {
                    return !((TicketGrantingTicket)ticket).isExpired();
                }
                return false;
            }
        });
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showSsoSessions() throws Exception {
        HashMap<String, Collection<Map<String, Object>>> sessionsMap = new HashMap<String, Collection<Map<String, Object>>>(1);
        sessionsMap.put(ROOT_REPORT_ACTIVE_SESSIONS_KEY, this.getSsoSessions());
        String jsonRepresentation = this.jsonMapper.writeValueAsString(sessionsMap);
        ModelAndView modelAndView = new ModelAndView(VIEW_SSO_SESSIONS);
        modelAndView.addObject(ROOT_REPORT_ACTIVE_SESSIONS_KEY, (Object)jsonRepresentation);
        return modelAndView;
    }

    private static enum SsoSessionAttributeKeys {
        AUTHENTICATED_PRINCIPAL("authenticated_principal"),
        AUTHENTICATION_DATE("authentication_date"),
        TICKET_GRANTING_TICKET("ticket_granting_ticket"),
        NUMBER_OF_USES("number_of_uses");

        private String attributeKey;

        private SsoSessionAttributeKeys(String attributeKey) {
            this.attributeKey = attributeKey;
        }

        public String toString() {
            return this.attributeKey;
        }
    }
}

