/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.codehaus.plexus.configuration.MergePolicy;
import org.codehaus.plexus.configuration.MutablePlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public final class PlexusConfigurationUtils {
    public static final String REMOVE_DUPLICATE_POLICY = "merge:removeDuplicates";
    public static Comparator<PlexusConfiguration> PLEXUS_CONFIG_COMPARATOR = new PlexusConfigurationComparator();

    private PlexusConfigurationUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static PlexusConfiguration merge(PlexusConfiguration primary, PlexusConfiguration secondary) {
        String value;
        String existingName;
        if (secondary == null) {
            return primary;
        }
        if (primary == null) {
            return secondary;
        }
        String newName = secondary.getName();
        if (!newName.equals(existingName = primary.getName())) {
            throw new IllegalArgumentException("Cannot merge two PlexusConfiguration elements with different names " + newName + "!=" + existingName);
        }
        PlexusConfigurationUtils.mergeAttributes(primary, secondary);
        if (secondary.getChildCount() == 0 && primary.getChildCount() == 0) {
            String newValue = secondary.getValue();
            primary.setValue(newValue);
            return primary;
        }
        if (primary.getChildCount() == 0 && primary.getValue() != null) {
            value = primary.getValue();
            primary.setValue(null);
            primary.addChild(primary.getName(), value);
        }
        if (secondary.getChildCount() == 0 && secondary.getValue() != null) {
            value = secondary.getValue();
            secondary.setValue(null);
            secondary.addChild(secondary.getName(), value);
        }
        MutablePlexusConfiguration mergedConfiguration = new MutablePlexusConfiguration(primary);
        PlexusConfiguration[] arr$ = secondary.getChildren();
        int len$ = arr$.length;
        int i$ = 0;
        while (i$ < len$) {
            PlexusConfiguration newChildConfiguration = arr$[i$];
            MergePolicy selfMergePolicy = MergePolicyType.SELF_MERGE_POLICY.getMergePolicy(newChildConfiguration, MergePolicy.MERGE);
            block0 : switch (selfMergePolicy) {
                case FIRST: {
                    String childName = newChildConfiguration.getName();
                    PlexusConfiguration existingChildConfiguration = mergedConfiguration.getChild(childName, false);
                    if (existingChildConfiguration != null) break;
                    mergedConfiguration.addChild(newChildConfiguration);
                    break;
                }
                case LAST: {
                    mergedConfiguration.replaceLastChild(newChildConfiguration);
                    break;
                }
                case MERGE: {
                    MergePolicy childrenMergePolicy = MergePolicyType.CHILDREN_MERGE_POLICY.getMergePolicy(newChildConfiguration, selfMergePolicy);
                    switch (childrenMergePolicy) {
                        case BOTH: {
                            Set existingChildren;
                            String childName = newChildConfiguration.getName();
                            PlexusConfiguration existingChildConfiguration = mergedConfiguration.getChild(childName, false);
                            if (existingChildConfiguration == null) {
                                mergedConfiguration.addChild(newChildConfiguration);
                                break block0;
                            }
                            PlexusConfigurationUtils.mergeAttributes(existingChildConfiguration, newChildConfiguration);
                            boolean removeDuplicates = Boolean.parseBoolean(newChildConfiguration.getAttribute(REMOVE_DUPLICATE_POLICY));
                            if (removeDuplicates) {
                                existingChildren = new TreeSet<PlexusConfiguration>(PLEXUS_CONFIG_COMPARATOR);
                                Collections.addAll(existingChildren, existingChildConfiguration.getChildren());
                            } else {
                                existingChildren = Collections.emptySet();
                            }
                            for (PlexusConfiguration child : newChildConfiguration.getChildren()) {
                                if (existingChildren.contains(child)) continue;
                                existingChildConfiguration.addChild(child);
                            }
                            break block0;
                        }
                        case FIRST: {
                            String childName = newChildConfiguration.getName();
                            PlexusConfiguration existingChildConfiguration = mergedConfiguration.getChild(childName, false);
                            if (existingChildConfiguration != null) break;
                            mergedConfiguration.addChild(newChildConfiguration);
                            break block0;
                        }
                        case LAST: 
                        case MERGE: {
                            String childName = newChildConfiguration.getName();
                            PlexusConfiguration existingChildConfiguration = mergedConfiguration.getChild(childName);
                            PlexusConfiguration mergedChildConfiguration = PlexusConfigurationUtils.merge(existingChildConfiguration, newChildConfiguration);
                            mergedConfiguration.replaceLastChild(mergedChildConfiguration);
                            break block0;
                        }
                    }
                    break;
                }
                case BOTH: {
                    mergedConfiguration.addChild(newChildConfiguration);
                    break;
                }
            }
            ++i$;
        }
        return mergedConfiguration;
    }

    private static void mergeAttributes(PlexusConfiguration primary, PlexusConfiguration secondary) {
        for (String attributeName : secondary.getAttributeNames()) {
            String value = secondary.getAttribute(attributeName);
            primary.setAttribute(attributeName, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PlexusConfigurationComparator
    implements Comparator<PlexusConfiguration> {
        private PlexusConfigurationComparator() {
        }

        @Override
        public int compare(PlexusConfiguration o1, PlexusConfiguration o2) {
            LinkedHashSet<String> attrNames2;
            int name = this.nullSafeCompare(o1.getName(), o2.getName());
            if (name != 0) {
                return name;
            }
            int value = this.nullSafeCompare(o1.getValue(), o2.getValue());
            if (value != 0) {
                return value;
            }
            LinkedHashSet<String> attrNames1 = new LinkedHashSet<String>(Arrays.asList(o1.getAttributeNames()));
            if (!((Object)attrNames1).equals(attrNames2 = new LinkedHashSet<String>(Arrays.asList(o2.getAttributeNames())))) {
                return -1;
            }
            for (String attrName : attrNames1) {
                int attrComp = this.nullSafeCompare(o1.getAttribute(attrName), o2.getAttribute(attrName));
                if (attrComp == 0) continue;
                return attrComp;
            }
            if (o1.getChildCount() < o2.getChildCount()) {
                return -1;
            }
            if (o1.getChildCount() > o2.getChildCount()) {
                return 1;
            }
            if (o1.getChildCount() > 0) {
                PlexusConfiguration[] children1 = o1.getChildren();
                PlexusConfiguration[] children2 = o2.getChildren();
                for (int index = 0; index < children1.length; ++index) {
                    int child = this.compare(children1[index], children2[index]);
                    if (child == 0) continue;
                    return child;
                }
            }
            return 0;
        }

        private <T extends Comparable<T>> int nullSafeCompare(T o1, T o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MergePolicyType {
        SELF_MERGE_POLICY("merge:self"),
        CHILDREN_MERGE_POLICY("merge:children");

        private final String attributeName;

        private MergePolicyType(String attributeName) {
            this.attributeName = attributeName;
        }

        public MergePolicy getMergePolicy(PlexusConfiguration configuration) {
            return this.getMergePolicy(configuration, null);
        }

        public MergePolicy getMergePolicy(PlexusConfiguration configuration, MergePolicy defaultMergePolicy) {
            if (configuration == null) {
                return defaultMergePolicy;
            }
            String duplicatePolicy = configuration.getAttribute(this.attributeName);
            if (duplicatePolicy == null) {
                return defaultMergePolicy;
            }
            try {
                return MergePolicy.valueOf(duplicatePolicy);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot assign value " + duplicatePolicy + " to property " + this.attributeName + " of " + configuration.getName() + ". No enum const class " + MergePolicy.class.getName() + "." + duplicatePolicy);
            }
        }
    }
}

