/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter;

import java.io.Serializable;
import java.net.SocketException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.portlet.PortletRequest;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.util.UidGenerator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.calendar.CalendarConfiguration;
import org.jasig.portlet.calendar.adapter.AbstractCalendarAdapter;
import org.jasig.portlet.calendar.adapter.CalendarEventSet;
import org.jasig.portlet.calendar.adapter.CalendarException;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.caching.ICacheKeyGenerator;
import org.jasig.portlet.calendar.caching.RequestAttributeCacheKeyGeneratorImpl;
import org.jasig.portlet.calendar.processor.ICalendarContentProcessorImpl;
import org.jasig.portlet.calendar.processor.IContentProcessor;
import org.jasig.portlet.courses.dao.ICoursesDao;
import org.jasig.portlet.courses.model.xml.CourseMeeting;
import org.jasig.portlet.courses.model.xml.Term;
import org.jasig.portlet.courses.model.xml.TermList;
import org.jasig.portlet.courses.model.xml.personal.Course;
import org.jasig.portlet.courses.model.xml.personal.CoursesByTerm;
import org.joda.time.Interval;

public class CoursesCalendarAdapter
extends AbstractCalendarAdapter
implements ICalendarAdapter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Cache cache;
    private ICoursesDao courseDao;
    private ICacheKeyGenerator cacheKeyGenerator = new RequestAttributeCacheKeyGeneratorImpl();
    private IContentProcessor contentProcessor = new ICalendarContentProcessorImpl();
    private String cacheKeyPrefix = "courseDao";
    private final UidGenerator uidGenerator;

    public CoursesCalendarAdapter() {
        try {
            this.uidGenerator = new UidGenerator("uidGen");
        }
        catch (SocketException e) {
            throw new RuntimeException("Failed to create UidGenerator", e);
        }
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setCourseDao(ICoursesDao courseDao) {
        this.courseDao = courseDao;
    }

    public void setCacheKeyGenerator(ICacheKeyGenerator cacheKeyGenerator) {
        this.cacheKeyGenerator = cacheKeyGenerator;
    }

    public void setCacheKeyPrefix(String cacheKeyPrefix) {
        this.cacheKeyPrefix = cacheKeyPrefix;
    }

    public void setContentProcessor(IContentProcessor contentProcessor) {
        this.contentProcessor = contentProcessor;
    }

    @Override
    public CalendarEventSet getEvents(CalendarConfiguration calendarConfiguration, Interval interval, PortletRequest request) throws CalendarException {
        String intervalCacheKey = this.cacheKeyGenerator.getKey(calendarConfiguration, interval, request, this.cacheKeyPrefix.concat(".") + interval.toString());
        Element cachedElement = this.cache.get((Serializable)((Object)intervalCacheKey));
        if (cachedElement != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Retrieving calendar event set from cache, termCacheKey:" + intervalCacheKey));
            }
            return (CalendarEventSet)cachedElement.getValue();
        }
        TermList allTerms = this.courseDao.getTermList(request);
        HashSet<VEvent> calendarEventSet = new HashSet<VEvent>();
        for (Term term : allTerms.getTerms()) {
            if (!interval.getStart().isBefore(term.getEnd().getTimeInMillis()) || !interval.getEnd().isAfter(term.getStart().getTimeInMillis())) continue;
            net.fortuna.ical4j.model.Calendar calendar = this.retrieveCourseCalendar(request, interval, calendarConfiguration, term);
            Set<VEvent> events = this.contentProcessor.getEvents(interval, calendar);
            this.log.debug((Object)("contentProcessor found " + events.size() + " events"));
            calendarEventSet.addAll(events);
        }
        CalendarEventSet eventSet = new CalendarEventSet(intervalCacheKey, calendarEventSet);
        cachedElement = new Element((Serializable)((Object)intervalCacheKey), (Serializable)eventSet);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Storing calendar event set to cache, key:" + intervalCacheKey));
        }
        this.cache.put(cachedElement);
        return eventSet;
    }

    protected final net.fortuna.ical4j.model.Calendar retrieveCourseCalendar(PortletRequest request, Interval interval, CalendarConfiguration calendarConfiguration, Term term) {
        String termCacheKey = this.cacheKeyGenerator.getKey(calendarConfiguration, interval, request, this.cacheKeyPrefix.concat(".").concat(term.getCode()));
        Element cachedCalendar = this.cache.get((Serializable)((Object)termCacheKey));
        if (cachedCalendar != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Retrieving calendar from cache, key:" + termCacheKey));
            }
            return (net.fortuna.ical4j.model.Calendar)cachedCalendar.getValue();
        }
        net.fortuna.ical4j.model.Calendar calendar = new net.fortuna.ical4j.model.Calendar();
        calendar.getProperties().add((Property)new ProdId("-//Ben Fortuna//iCal4j 1.0//EN"));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        Calendar termStartDate = term.getStart();
        Calendar termEndDate = term.getEnd();
        CoursesByTerm coursesByTerm = this.courseDao.getCoursesByTerm(request, term.getCode());
        if (coursesByTerm == null) {
            this.log.info((Object)("User " + request.getRemoteUser() + " does not have any courses" + " for term " + term + " or invalid term code " + term));
            return calendar;
        }
        List courses = coursesByTerm.getCourses();
        for (Course course : courses) {
            for (CourseMeeting meeting : course.getCourseMeetings()) {
                VEvent meetingEvent = this.createEvent(course, meeting, termStartDate, termEndDate);
                if (meetingEvent == null) continue;
                calendar.getComponents().add((Component)meetingEvent);
            }
        }
        cachedCalendar = new Element((Serializable)((Object)termCacheKey), (Serializable)calendar);
        this.cache.put(cachedCalendar);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Storing calendar cache, key:" + termCacheKey));
        }
        return calendar;
    }

    private VEvent createEvent(Course course, CourseMeeting courseMeeting, Calendar termStartDate, Calendar termEndDate) {
        List courseDays;
        if (termStartDate == null && courseMeeting.getStartDate() == null) {
            this.log.error((Object)("Course " + course.getCode() + " must have a term start date" + " or class meeting end date"));
            return null;
        }
        if (termEndDate == null && courseMeeting.getEndTime() == null) {
            this.log.error((Object)("Course " + course.getCode() + " must have a term end date" + " or class meeting end date"));
            return null;
        }
        if (courseMeeting.getStartTime() == null || courseMeeting.getEndTime() == null) {
            this.log.error((Object)("Course " + course.getCode() + " must have start time and end time specified"));
            return null;
        }
        net.fortuna.ical4j.model.TimeZone tz = this.selectTimeZone(courseMeeting, termStartDate);
        Calendar firstMeetingStartTime = this.calculateFirstMeetingStartTime(courseMeeting, termStartDate);
        Calendar firstMeetingEndTime = this.calculateFirstMeetingEndTime(firstMeetingStartTime, courseMeeting);
        Calendar recurrenceEndDate = this.calculateRecurrenceEndDate(courseMeeting, termEndDate);
        if (firstMeetingStartTime.after(firstMeetingEndTime)) {
            this.log.error((Object)("Course " + course.getCode() + " start time is after end time"));
            return null;
        }
        if (firstMeetingStartTime.after(recurrenceEndDate)) {
            this.log.error((Object)("Course " + course.getCode() + " start date is after end date"));
            return null;
        }
        DateTime eventStart = new DateTime();
        eventStart.setTime(firstMeetingStartTime.getTimeInMillis());
        eventStart.setTimeZone(tz);
        DateTime eventEnd = new DateTime();
        eventEnd.setTime(firstMeetingEndTime.getTimeInMillis());
        eventStart.setTimeZone(tz);
        DateTime recurUntil = new DateTime();
        recurUntil.setTime(recurrenceEndDate.getTimeInMillis());
        eventStart.setTimeZone(tz);
        PropertyList props = new PropertyList();
        props.add((Property)this.uidGenerator.generateUid());
        props.add((Property)new DtStamp());
        props.add((Property)new DtStart((Date)eventStart));
        props.add((Property)new DtEnd((Date)eventEnd));
        props.add((Property)new Summary(StringUtils.isNotBlank((String)course.getCode()) ? course.getCode() : "course"));
        if (StringUtils.isNotBlank((String)course.getTitle())) {
            props.add((Property)new Description(course.getTitle()));
        }
        if (StringUtils.isNotBlank((String)courseMeeting.getLocation().getDisplayName())) {
            props.add((Property)new Location(courseMeeting.getLocation().getDisplayName()));
        }
        if ((courseDays = courseMeeting.getDayIds()) != null && courseDays.size() > 0) {
            Recur recur = new Recur("WEEKLY", (Date)recurUntil);
            for (String dayOfWeek : courseDays) {
                WeekDay day = DAYS.valueOf(dayOfWeek).getIcalWeekDay();
                if (day != null) {
                    recur.getDayList().add(day);
                    continue;
                }
                this.log.warn((Object)("Invalid course day of week string " + dayOfWeek));
            }
            RRule rrule = new RRule(recur);
            props.add((Property)rrule);
        }
        VEvent event = new VEvent(props);
        return event;
    }

    private net.fortuna.ical4j.model.TimeZone selectTimeZone(CourseMeeting courseMeeting, Calendar termStartDate) {
        TimeZone jdkTz = null;
        if (courseMeeting.getStartDate() != null) {
            jdkTz = courseMeeting.getStartDate().getTimeZone();
        } else if (termStartDate != null) {
            jdkTz = termStartDate.getTimeZone();
        } else {
            throw new IllegalArgumentException("Arguments courseMeeting and termStartDate cannot both be null");
        }
        TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
        net.fortuna.ical4j.model.TimeZone rslt = registry.getTimeZone(jdkTz.getID());
        return rslt;
    }

    private Calendar combineDateAndTime(Calendar datePart, Calendar timePart) {
        Calendar rslt = (Calendar)datePart.clone();
        rslt.set(11, timePart.get(11));
        rslt.set(12, timePart.get(12));
        rslt.set(13, timePart.get(13));
        rslt.set(14, timePart.get(14));
        return rslt;
    }

    private Calendar calculateFirstMeetingStartTime(CourseMeeting courseMeeting, Calendar termStartDate) {
        Calendar cmStartDate = courseMeeting.getStartDate();
        Calendar candidateStartDate = cmStartDate != null && !cmStartDate.getTime().before(termStartDate.getTime()) ? courseMeeting.getStartDate() : termStartDate;
        List courseDays = courseMeeting.getDayIds();
        Calendar actualStartDate = null;
        while (true) {
            int calendarDayOfWeek = candidateStartDate.get(7);
            for (String dayCode : courseDays) {
                WeekDay weekDay = DAYS.valueOf(dayCode).getIcalWeekDay();
                if (calendarDayOfWeek != WeekDay.getCalendarDay((WeekDay)weekDay)) continue;
                actualStartDate = (Calendar)candidateStartDate.clone();
            }
            if (actualStartDate != null) break;
            candidateStartDate.add(6, 1);
        }
        GregorianCalendar meetingStartTime = courseMeeting.getStartTime().toGregorianCalendar();
        Calendar rslt = this.combineDateAndTime(actualStartDate, meetingStartTime);
        return rslt;
    }

    private Calendar calculateFirstMeetingEndTime(Calendar firstMeetingStartTime, CourseMeeting courseMeeting) {
        GregorianCalendar meetingEndTime = courseMeeting.getEndTime().toGregorianCalendar();
        return this.combineDateAndTime(firstMeetingStartTime, meetingEndTime);
    }

    private Calendar calculateRecurrenceEndDate(CourseMeeting courseMeeting, Calendar termDate) {
        Calendar meetingDate = courseMeeting.getEndDate();
        GregorianCalendar meetingTime = courseMeeting.getEndTime().toGregorianCalendar();
        Calendar endDate = meetingDate != null ? meetingDate : termDate;
        return this.combineDateAndTime(endDate, meetingTime);
    }

    private static enum DAYS {
        Su(WeekDay.SU),
        M(WeekDay.MO),
        T(WeekDay.TU),
        W(WeekDay.WE),
        Th(WeekDay.TH),
        F(WeekDay.FR),
        Sa(WeekDay.SA);

        private final WeekDay icalWeekDay;

        private DAYS(WeekDay icalWeekDay) {
            this.icalWeekDay = icalWeekDay;
        }

        public WeekDay getIcalWeekDay() {
            return this.icalWeekDay;
        }
    }
}

