/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.adapter.exchange;

import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.jasig.portlet.calendar.service.IInitializationService;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.portlet.context.PortletRequestAttributes;

public class ExchangeCredentialsInitializationService
implements IInitializationService {
    public static final String PREFS_NTDOMAIN = "exchangeNtlmDomain";
    private String usernameAttribute = "user.login.id";
    private String passwordAttribute = "password";
    private String mailAttribute = "mail";
    private String ntlmDomain = null;

    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    public void setMailAttribute(String mailAttribute) {
        this.mailAttribute = mailAttribute;
    }

    public void setNtlmDomain(String ntlmDomain) {
        this.ntlmDomain = ntlmDomain;
    }

    @Override
    public void initialize(PortletRequest request) {
        Credentials credentials;
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String username = (String)userInfo.get(this.usernameAttribute);
        String password = (String)userInfo.get(this.passwordAttribute);
        PortletPreferences prefs = request.getPreferences();
        String ntlmDomain = prefs.getValue(PREFS_NTDOMAIN, "");
        String string = ntlmDomain = StringUtils.isBlank((String)ntlmDomain) ? this.ntlmDomain : ntlmDomain;
        if (StringUtils.isNotBlank((String)ntlmDomain)) {
            credentials = this.createNTCredentials(ntlmDomain, username, password);
        } else {
            String emailAddress = (String)userInfo.get(this.mailAttribute);
            credentials = new UsernamePasswordCredentials(emailAddress, password);
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            requestAttributes = new PortletRequestAttributes(request);
            RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
        }
        requestAttributes.setAttribute("exchangeCredentials", (Object)credentials, 1);
    }

    protected Credentials createNTCredentials(String ntlmDomain, String username, String password) {
        int index = username.indexOf("@");
        username = index > 0 ? username.substring(0, index) : username;
        return new NTCredentials(username, password, "paramDoesNotSeemToMatter", ntlmDomain);
    }
}

