/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import org.jasig.portlet.calendar.mvc.IViewSelector;

public class ViewSelectorDefaultImpl
implements IViewSelector {
    private final String CALENDAR_WIDE_VIEW = "calendarWideView";
    private final String CALENDAR_NARROW_VIEW = "calendarNarrowView";
    private final String CALENDAR_MOBILE_VIEW = "calendarMobileView";
    private List<Pattern> mobileDeviceRegexes = null;

    @Resource(name="mobileDeviceRegexes")
    public void setMobileDeviceRegexes(List<String> patterns) {
        this.mobileDeviceRegexes = new ArrayList<Pattern>();
        for (String pattern : patterns) {
            this.mobileDeviceRegexes.add(Pattern.compile(pattern));
        }
    }

    @Override
    public String getCalendarViewName(PortletRequest request) {
        if (this.isMobile(request)) {
            return "calendarMobileView";
        }
        WindowState state = request.getWindowState();
        if (WindowState.MAXIMIZED.equals((Object)state) || "DETACHED".equalsIgnoreCase(state.toString())) {
            return "calendarWideView";
        }
        return "calendarNarrowView";
    }

    @Override
    public String getEditViewName(PortletRequest request) {
        if (this.isMobile(request)) {
            return "editCalendars-jQM";
        }
        return "editCalendars";
    }

    @Override
    public String getEventListViewName(PortletRequest request) {
        return "ajaxEventList";
    }

    protected boolean isMobile(PortletRequest request) {
        String userAgent = request.getProperty("user-agent");
        if (this.mobileDeviceRegexes != null && userAgent != null) {
            for (Pattern regex : this.mobileDeviceRegexes) {
                if (!regex.matcher(userAgent).matches()) continue;
                return true;
            }
        }
        return false;
    }
}

