/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.calendar.mvc.controller;

import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.jasig.portlet.calendar.PredefinedCalendarDefinition;
import org.jasig.portlet.calendar.adapter.ICalendarAdapter;
import org.jasig.portlet.calendar.dao.CalendarStore;
import org.jasig.portlet.calendar.mvc.CalendarDefinitionForm;
import org.jasig.portlet.form.parameter.Parameter;
import org.jasig.portlet.form.parameter.SingleValuedParameterInput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.portlet.bind.annotation.ActionMapping;

@Controller
@RequestMapping(value={"EDIT"})
public class EditCalendarDefinitionController {
    private static final String FORM_NAME = "calendarDefinitionForm";
    private CalendarStore calendarStore;
    private ApplicationContext context;
    @Autowired
    private Map<String, ICalendarAdapter> adapters;

    @Required
    @Resource(name="calendarStore")
    public void setCalendarStore(CalendarStore calendarStore) {
        this.calendarStore = calendarStore;
    }

    @Autowired(required=true)
    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @RequestMapping(params={"action=createCalendarDefinition"})
    public String showNewCalendarDefinitionForm(PortletRequest request, Model model) {
        if (!model.containsAttribute(FORM_NAME)) {
            CalendarDefinitionForm form = new CalendarDefinitionForm();
            model.addAttribute(FORM_NAME, (Object)form);
        }
        model.addAttribute("adapters", this.adapters);
        return "/createCalendarDefinition";
    }

    @RequestMapping(params={"action=createCalendarDefinition2"})
    public String showEditCalendarDefinitionForm2(PortletRequest request, Model model, @ModelAttribute(value="calendarDefinitionForm") CalendarDefinitionForm form) {
        ICalendarAdapter adapter = (ICalendarAdapter)this.context.getBean(form.getClassName(), ICalendarAdapter.class);
        for (Parameter pref : adapter.getParameters()) {
            SingleValuedParameterInput input = (SingleValuedParameterInput)pref.getInput();
            form.addParameter(pref.getName(), input.getDefaultValue());
        }
        model.addAttribute("adapter", this.context.getBean(form.getClassName()));
        return "/editCalendarDefinition";
    }

    @RequestMapping(params={"action=editCalendarDefinition"})
    public String showEditCalendarDefinitionForm(PortletRequest request, Model model) {
        CalendarDefinitionForm form = (CalendarDefinitionForm)model.asMap().get(FORM_NAME);
        if (form == null) {
            form = this.getCalendarDefinitionForm(request);
            model.addAttribute(FORM_NAME, (Object)form);
        }
        model.addAttribute("adapter", this.context.getBean(form.getClassName(), ICalendarAdapter.class));
        return "/editCalendarDefinition";
    }

    @ActionMapping(params={"action=editCalendarDefinition"})
    public void updateCalendarDefinition(ActionRequest request, ActionResponse response, @ModelAttribute(value="calendarDefinitionForm") CalendarDefinitionForm form, BindingResult result, SessionStatus status) {
        PredefinedCalendarDefinition definition = null;
        definition = form.getId() > -1L ? this.calendarStore.getPredefinedCalendarDefinition(form.getId()) : new PredefinedCalendarDefinition();
        definition.setClassName(form.getClassName());
        definition.setDefaultRoles(form.getRole());
        definition.setName(form.getName());
        definition.setFname(form.getFname());
        ICalendarAdapter adapter = (ICalendarAdapter)this.context.getBean(definition.getClassName(), ICalendarAdapter.class);
        for (Parameter pref : adapter.getParameters()) {
            definition.getParameters().put(pref.getName(), form.getParameters().get(pref.getName()).getValue());
        }
        this.calendarStore.storeCalendarDefinition(definition);
        response.setRenderParameter("action", "administration");
    }

    protected CalendarDefinitionForm getCalendarDefinitionForm(PortletRequest request) {
        String id = request.getParameter("id");
        if (id != null && !id.equals("")) {
            Long definitionId = Long.parseLong(id);
            if (definitionId > -1L) {
                PredefinedCalendarDefinition definition = this.calendarStore.getPredefinedCalendarDefinition(definitionId);
                CalendarDefinitionForm command = new CalendarDefinitionForm();
                command.setId(definition.getId());
                command.setName(definition.getName());
                command.setFname(definition.getFname());
                command.setClassName(definition.getClassName());
                command.setRole(definition.getDefaultRoles());
                command.addParameters(definition.getParameters());
                ICalendarAdapter adapter = (ICalendarAdapter)this.context.getBean(definition.getClassName(), ICalendarAdapter.class);
                for (Parameter pref : adapter.getParameters()) {
                    SingleValuedParameterInput input = (SingleValuedParameterInput)pref.getInput();
                    String value = definition.getParameters().containsKey(pref.getName()) ? definition.getParameters().get(pref.getName()) : input.getDefaultValue();
                    command.addParameter(pref.getName(), value);
                }
                return command;
            }
            CalendarDefinitionForm form = new CalendarDefinitionForm();
            ICalendarAdapter adapter = this.adapters.get(0);
            for (Parameter pref : adapter.getParameters()) {
                SingleValuedParameterInput input = (SingleValuedParameterInput)pref.getInput();
                form.addParameter(pref.getName(), input.getDefaultValue());
            }
            return form;
        }
        CalendarDefinitionForm form = new CalendarDefinitionForm();
        ICalendarAdapter adapter = this.adapters.get(0);
        for (Parameter pref : adapter.getParameters()) {
            SingleValuedParameterInput input = (SingleValuedParameterInput)pref.getInput();
            form.addParameter(pref.getName(), input.getDefaultValue());
        }
        return form;
    }
}

