/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.Task;
import org.jbehave.core.InjectableEmbedder;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.embedder.EmbedderClassLoader;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.UnmodifiableEmbedderControls;
import org.jbehave.core.io.StoryFinder;
import org.jbehave.core.junit.AnnotatedEmbedderRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEmbedderTask
extends Task {
    private static final String TEST_SCOPE = "test";
    private String sourceDirectory = "src/main/java";
    private String testSourceDirectory = "src/test/java";
    private String scope = "compile";
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();
    private boolean skip = false;
    private boolean ignoreFailureInStories = false;
    private boolean ignoreFailureInView = false;
    private boolean generateViewAfterStories = true;
    private boolean batch = false;
    private String embedderClass = Embedder.class.getName();
    private String injectableEmbedderClass;
    protected String annotatedEmbedderRunnerClass = AnnotatedEmbedderRunner.class.getName();
    private StoryFinder finder = new StoryFinder();

    private boolean isSourceTestScope() {
        return TEST_SCOPE.equals(this.scope);
    }

    private String rootSourceDirectory() {
        if (this.isSourceTestScope()) {
            return this.testSourceDirectory;
        }
        return this.sourceDirectory;
    }

    protected EmbedderClassLoader createClassLoader() {
        try {
            return new EmbedderClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to create " + EmbedderClassLoader.class, e);
        }
    }

    protected EmbedderMonitor embedderMonitor() {
        return new AntEmbedderMonitor();
    }

    protected EmbedderControls embedderControls() {
        return new UnmodifiableEmbedderControls(new EmbedderControls().doBatch(this.batch).doSkip(this.skip).doGenerateViewAfterStories(this.generateViewAfterStories).doIgnoreFailureInStories(this.ignoreFailureInStories).doIgnoreFailureInView(this.ignoreFailureInView));
    }

    protected List<String> storyPaths() {
        this.log("Searching for story paths including " + this.includes + " and excluding " + this.excludes, 4);
        List storyPaths = this.finder.findPaths(this.rootSourceDirectory(), this.includes, this.excludes);
        this.log("Found story paths: " + storyPaths, 2);
        return storyPaths;
    }

    protected List<String> classNames() {
        this.log("Searching for class names including " + this.includes + " and excluding " + this.excludes, 4);
        List classNames = this.finder.findClassNames(this.rootSourceDirectory(), this.includes, this.excludes);
        this.log("Found class names : " + classNames, 2);
        return classNames;
    }

    protected Embedder newEmbedder() {
        Embedder embedder = null;
        EmbedderClassLoader classLoader = this.createClassLoader();
        embedder = this.injectableEmbedderClass != null ? ((InjectableEmbedder)classLoader.newInstance(InjectableEmbedder.class, this.injectableEmbedderClass)).injectedEmbedder() : (Embedder)classLoader.newInstance(Embedder.class, this.embedderClass);
        embedder.useEmbedderMonitor(this.embedderMonitor());
        embedder.useEmbedderControls(this.embedderControls());
        return embedder;
    }

    public void setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void setTestSourceDirectory(String testSourceDirectory) {
        this.testSourceDirectory = testSourceDirectory;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setIncludes(String includesCSV) {
        this.includes = Arrays.asList(includesCSV.split(","));
    }

    public void setExcludes(String excludesCSV) {
        this.excludes = Arrays.asList(excludesCSV.split(","));
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setIgnoreFailureInStories(boolean ignoreFailureInStories) {
        this.ignoreFailureInStories = ignoreFailureInStories;
    }

    public void setIgnoreFailureInView(boolean ignoreFailureInView) {
        this.ignoreFailureInView = ignoreFailureInView;
    }

    public void setGenerateViewAfterStories(boolean generateViewAfterStories) {
        this.generateViewAfterStories = generateViewAfterStories;
    }

    public void setEmbedderClass(String embedderClass) {
        this.embedderClass = embedderClass;
    }

    public void setInjectableEmbedderClass(String injectableEmbedderClass) {
        this.injectableEmbedderClass = injectableEmbedderClass;
    }

    public void setAnnotatedEmbedderRunnerClass(String annotatedEmbedderRunnerClass) {
        this.annotatedEmbedderRunnerClass = annotatedEmbedderRunnerClass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AntEmbedderMonitor
    implements EmbedderMonitor {
        protected AntEmbedderMonitor() {
        }

        public void storiesBatchFailed(String failedStories) {
            AbstractEmbedderTask.this.log("Failed to run stories batch: " + failedStories, 1);
        }

        public void storyFailed(String storyName, Throwable e) {
            AbstractEmbedderTask.this.log("Failed to run story " + storyName, e, 1);
        }

        public void runningStory(String storyName) {
            AbstractEmbedderTask.this.log("Running story " + storyName, 2);
        }

        public void storiesNotRun() {
            AbstractEmbedderTask.this.log("Stories not run", 2);
        }

        public void annotatedInstanceNotOfType(Object annotatedInstance, Class<?> type) {
            AbstractEmbedderTask.this.log("Annotated instance " + annotatedInstance + " not of type " + type, 1);
        }

        public void generatingStoriesView(File outputDirectory, List<String> formats, Properties viewProperties) {
            AbstractEmbedderTask.this.log("Generating stories view in '" + outputDirectory + "' using formats '" + formats + "'" + " and view properties '" + viewProperties + "'", 2);
        }

        public void storiesViewGenerationFailed(File outputDirectory, List<String> formats, Properties viewProperties, Throwable cause) {
            AbstractEmbedderTask.this.log("Failed to generate stories view in outputDirectory " + outputDirectory + " using formats " + formats + " and view properties '" + viewProperties + "'", 1);
        }

        public void storiesViewGenerated(int stories, int scenarios, int failedScenarios) {
            AbstractEmbedderTask.this.log("Stories view generated with " + stories + " stories containing " + scenarios + " scenarios (of which  " + failedScenarios + " failed)", 2);
        }

        public void storiesViewNotGenerated() {
            AbstractEmbedderTask.this.log("Stories view not generated ", 2);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

