/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration;

import com.thoughtworks.paranamer.Paranamer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jbehave.core.ConfigurableEmbedder;
import org.jbehave.core.Embeddable;
import org.jbehave.core.annotations.Configure;
import org.jbehave.core.annotations.UsingEmbedder;
import org.jbehave.core.annotations.UsingPaths;
import org.jbehave.core.annotations.UsingSteps;
import org.jbehave.core.configuration.AnnotationFinder;
import org.jbehave.core.configuration.AnnotationMonitor;
import org.jbehave.core.configuration.AnnotationRequired;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.configuration.PrintStreamAnnotationMonitor;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.embedder.StoryControls;
import org.jbehave.core.failures.FailureStrategy;
import org.jbehave.core.failures.PendingStepStrategy;
import org.jbehave.core.io.PathCalculator;
import org.jbehave.core.io.StoryFinder;
import org.jbehave.core.io.StoryLoader;
import org.jbehave.core.io.StoryPathResolver;
import org.jbehave.core.parsers.StepPatternParser;
import org.jbehave.core.parsers.StoryParser;
import org.jbehave.core.reporters.StepdocReporter;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.reporters.ViewGenerator;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.InstanceStepsFactory;
import org.jbehave.core.steps.ParameterControls;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepFinder;
import org.jbehave.core.steps.StepMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationBuilder {
    private final AnnotationMonitor annotationMonitor;
    private final Class<?> annotatedClass;
    private final AnnotationFinder finder;

    public AnnotationBuilder(Class<?> annotatedClass) {
        this(annotatedClass, new PrintStreamAnnotationMonitor());
    }

    public AnnotationBuilder(Class<?> annotatedClass, AnnotationMonitor annotationMonitor) {
        this.annotationMonitor = annotationMonitor;
        this.annotatedClass = annotatedClass;
        this.finder = new AnnotationFinder(annotatedClass);
    }

    public Class<?> annotatedClass() {
        return this.annotatedClass;
    }

    public Configuration buildConfiguration() throws AnnotationRequired {
        if (!this.finder.isAnnotationPresent(Configure.class)) {
            return new MostUsefulConfiguration();
        }
        Configuration configuration = this.configurationElement(this.finder, "using", Configuration.class);
        configuration.useKeywords(this.configurationElement(this.finder, "keywords", Keywords.class));
        configuration.useFailureStrategy(this.configurationElement(this.finder, "failureStrategy", FailureStrategy.class));
        configuration.usePendingStepStrategy(this.configurationElement(this.finder, "pendingStepStrategy", PendingStepStrategy.class));
        configuration.useParanamer(this.configurationElement(this.finder, "paranamer", Paranamer.class));
        configuration.useStoryControls(this.configurationElement(this.finder, "storyControls", StoryControls.class));
        configuration.useStepCollector(this.configurationElement(this.finder, "stepCollector", StepCollector.class));
        configuration.useStepdocReporter(this.configurationElement(this.finder, "stepdocReporter", StepdocReporter.class));
        configuration.useStepFinder(this.configurationElement(this.finder, "stepFinder", StepFinder.class));
        configuration.useStepMonitor(this.configurationElement(this.finder, "stepMonitor", StepMonitor.class));
        configuration.useStepPatternParser(this.configurationElement(this.finder, "stepPatternParser", StepPatternParser.class));
        configuration.useStoryLoader(this.configurationElement(this.finder, "storyLoader", StoryLoader.class));
        configuration.useStoryParser(this.configurationElement(this.finder, "storyParser", StoryParser.class));
        configuration.useStoryPathResolver(this.configurationElement(this.finder, "storyPathResolver", StoryPathResolver.class));
        configuration.useDefaultStoryReporter(this.configurationElement(this.finder, "defaultStoryReporter", StoryReporter.class));
        configuration.useStoryReporterBuilder(this.configurationElement(this.finder, "storyReporterBuilder", StoryReporterBuilder.class));
        configuration.useViewGenerator(this.configurationElement(this.finder, "viewGenerator", ViewGenerator.class));
        configuration.useParameterConverters(this.parameterConverters(this.finder));
        configuration.useParameterControls(this.configurationElement(this.finder, "parameterControls", ParameterControls.class));
        configuration.usePathCalculator(this.configurationElement(this.finder, "pathCalculator", PathCalculator.class));
        return configuration;
    }

    public List<CandidateSteps> buildCandidateSteps() {
        return this.buildCandidateSteps(this.buildConfiguration());
    }

    public List<CandidateSteps> buildCandidateSteps(Configuration configuration) {
        return this.buildStepsFactory(configuration).createCandidateSteps();
    }

    public InjectableStepsFactory buildStepsFactory(Configuration configuration) {
        ArrayList<Object> stepsInstances = new ArrayList<Object>();
        InstanceStepsFactory factory = null;
        if (this.finder.isAnnotationPresent(UsingSteps.class)) {
            List<Class<Object>> stepsClasses = this.finder.getAnnotatedClasses(UsingSteps.class, Object.class, "instances");
            for (Class<Object> stepsClass : stepsClasses) {
                stepsInstances.add(this.instanceOf(Object.class, stepsClass));
            }
            factory = new InstanceStepsFactory(configuration, stepsInstances);
        } else {
            this.annotationMonitor.annotationNotFound(UsingSteps.class, this.annotatedClass);
        }
        if (factory == null) {
            factory = new InstanceStepsFactory(configuration, new Object[0]);
        }
        return factory;
    }

    public Embedder buildEmbedder() {
        Properties systemProperties;
        if (!this.finder.isAnnotationPresent(UsingEmbedder.class)) {
            return new Embedder();
        }
        boolean batch = this.control(this.finder, "batch");
        boolean skip = this.control(this.finder, "skip");
        boolean generateViewAfterStories = this.control(this.finder, "generateViewAfterStories");
        boolean ignoreFailureInStories = this.control(this.finder, "ignoreFailureInStories");
        boolean ignoreFailureInView = this.control(this.finder, "ignoreFailureInView");
        boolean verboseFailures = this.control(this.finder, "verboseFailures");
        boolean verboseFiltering = this.control(this.finder, "verboseFiltering");
        long storyTimeoutInSecs = this.finder.getAnnotatedValue(UsingEmbedder.class, Long.class, "storyTimeoutInSecs");
        boolean failOnStoryTimeout = this.control(this.finder, "failOnStoryTimeout");
        int threads = this.finder.getAnnotatedValue(UsingEmbedder.class, Integer.class, "threads");
        Embedder embedder = this.embedder();
        embedder.embedderControls().doBatch(batch).doSkip(skip).doGenerateViewAfterStories(generateViewAfterStories).doIgnoreFailureInStories(ignoreFailureInStories).doIgnoreFailureInView(ignoreFailureInView).doVerboseFailures(verboseFailures).doVerboseFiltering(verboseFiltering).useStoryTimeoutInSecs(storyTimeoutInSecs).doFailOnStoryTimeout(failOnStoryTimeout).useThreads(threads);
        Configuration configuration = this.buildConfiguration();
        embedder.useConfiguration(configuration);
        boolean useStepsFactory = this.finder.getAnnotatedValue(UsingEmbedder.class, Boolean.class, "stepsFactory");
        if (useStepsFactory) {
            embedder.useStepsFactory(this.buildStepsFactory(configuration));
        } else {
            embedder.useCandidateSteps(this.buildCandidateSteps(configuration));
        }
        List<String> metaFilters = this.finder.getAnnotatedValues(UsingEmbedder.class, String.class, "metaFilters");
        if (!metaFilters.isEmpty()) {
            embedder.useMetaFilters(metaFilters);
        }
        if (!(systemProperties = this.loadProperties(this.finder.getAnnotatedValue(UsingEmbedder.class, String.class, "systemProperties"))).isEmpty()) {
            embedder.useSystemProperties(systemProperties);
        }
        return embedder;
    }

    private Embedder embedder() {
        return this.instanceOf(Embedder.class, this.finder.getAnnotatedValue(UsingEmbedder.class, Class.class, "embedder"));
    }

    public List<String> findPaths() {
        if (!this.finder.isAnnotationPresent(UsingPaths.class)) {
            return new ArrayList<String>();
        }
        String searchIn = this.finder.getAnnotatedValue(UsingPaths.class, String.class, "searchIn");
        List<String> includes = this.finder.getAnnotatedValues(UsingPaths.class, String.class, "includes");
        List<String> excludes = this.finder.getAnnotatedValues(UsingPaths.class, String.class, "excludes");
        return this.storyFinder().findPaths(searchIn, includes, excludes);
    }

    private StoryFinder storyFinder() {
        return this.instanceOf(StoryFinder.class, this.finder.getAnnotatedValue(UsingPaths.class, Class.class, "storyFinder"));
    }

    private boolean control(AnnotationFinder finder, String name) {
        return finder.getAnnotatedValue(UsingEmbedder.class, Boolean.class, name);
    }

    private <T> T configurationElement(AnnotationFinder finder, String name, Class<T> type) {
        Class<T> implementation = this.elementImplementation(finder, name);
        return this.instanceOf(type, implementation);
    }

    private <T> Class<T> elementImplementation(AnnotationFinder finder, String name) {
        return finder.getAnnotatedValue(Configure.class, Class.class, name);
    }

    private Properties loadProperties(String systemPropertiesCSV) {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(systemPropertiesCSV.replace(",", "\n").getBytes()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    protected ParameterConverters parameterConverters(AnnotationFinder annotationFinder) {
        ArrayList<ParameterConverters.ParameterConverter> converters = new ArrayList<ParameterConverters.ParameterConverter>();
        for (Class<ParameterConverters.ParameterConverter> converterClass : annotationFinder.getAnnotatedClasses(Configure.class, ParameterConverters.ParameterConverter.class, "parameterConverters")) {
            converters.add(this.instanceOf(ParameterConverters.ParameterConverter.class, converterClass));
        }
        return new ParameterConverters().addConverters(converters);
    }

    protected <T, V extends T> T instanceOf(Class<T> type, Class<V> ofClass) {
        try {
            try {
                Constructor<V> constructor = ofClass.getConstructor(ClassLoader.class);
                return (T)constructor.newInstance(this.annotatedClass.getClassLoader());
            }
            catch (NoSuchMethodException ns) {
                try {
                    Constructor<V> constructor = ofClass.getConstructor(Class.class);
                    return (T)constructor.newInstance(this.annotatedClass);
                }
                catch (NoSuchMethodException ns2) {
                    return (T)ofClass.newInstance();
                }
            }
        }
        catch (Exception e) {
            this.annotationMonitor.elementCreationFailed(ofClass, e);
            throw new InstantiationFailed(ofClass, type, e);
        }
    }

    protected AnnotationMonitor annotationMonitor() {
        return this.annotationMonitor;
    }

    protected AnnotationFinder annotationFinder() {
        return this.finder;
    }

    public Object embeddableInstance() {
        return this.injectEmbedder(this.buildEmbedder(), this.annotatedClass);
    }

    protected Object injectEmbedder(Embedder embedder, Class<?> annotatedClass) {
        try {
            Object instance = annotatedClass.newInstance();
            if (instance instanceof Embeddable) {
                Embeddable embeddable = (Embeddable)instance;
                embeddable.useEmbedder(embedder);
            }
            if (instance instanceof ConfigurableEmbedder) {
                ConfigurableEmbedder configurableEmbedder = (ConfigurableEmbedder)instance;
                configurableEmbedder.useConfiguration(embedder.configuration());
                configurableEmbedder.addSteps(embedder.candidateSteps());
                configurableEmbedder.useStepsFactory(embedder.stepsFactory());
            }
            return instance;
        }
        catch (Exception e) {
            this.annotationMonitor.elementCreationFailed(annotatedClass, e);
            throw new InstantiationFailed(annotatedClass, (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstantiationFailed
    extends RuntimeException {
        public InstantiationFailed(Class<?> ofClass, Class<?> type, Throwable cause) {
            super("Failed to instantiate " + ofClass + " of type " + type, cause);
        }

        public InstantiationFailed(Class<?> ofClass, Throwable cause) {
            super("Failed to instantiate " + ofClass, cause);
        }
    }
}

