/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jbehave.core.configuration.AnnotationRequired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationFinder {
    private final Class<?> annotatedClass;

    public AnnotationFinder(Class<?> annotatedClass) {
        this.annotatedClass = annotatedClass;
    }

    public <A extends Annotation> boolean isAnnotationPresent(Class<A> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public <A extends Annotation> boolean isAnnotationValuePresent(Class<A> annotationClass, String memberName) {
        Annotation annotation = this.getAnnotation(annotationClass);
        return annotation != null && this.getAnnotationValue(annotation, memberName) != null;
    }

    public <T, A extends Annotation> T getAnnotatedValue(Class<A> annotationClass, Class<T> memberType, String memberName) {
        Annotation annotation = this.getAnnotation(annotationClass);
        if (annotation != null) {
            return (T)this.getAnnotationValue(annotation, memberName);
        }
        throw new AnnotationRequired(this.annotatedClass, annotationClass);
    }

    public <T, A extends Annotation> List<T> getAnnotatedValues(Class<A> annotationClass, Class<T> type, String memberName) {
        Class<?> superClass;
        Object[] values;
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        if (!this.isAnnotationPresent(annotationClass)) {
            return new ArrayList(set);
        }
        for (Object value : values = this.getAnnotatedValue(annotationClass, Object[].class, memberName)) {
            set.add(value);
        }
        boolean inheritValues = true;
        String inheritMemberName = this.createInheritMemberName(memberName);
        if (this.isAnnotationValuePresent(annotationClass, inheritMemberName)) {
            inheritValues = this.getAnnotatedValue(annotationClass, Boolean.TYPE, inheritMemberName);
        }
        if (inheritValues && (superClass = this.annotatedClass.getSuperclass()) != null && superClass != Object.class) {
            set.addAll(new AnnotationFinder(superClass).getAnnotatedValues(annotationClass, type, memberName));
        }
        return new ArrayList(set);
    }

    protected String createInheritMemberName(String memberName) {
        return "inherit" + StringUtils.capitalize((String)memberName);
    }

    public <T, A extends Annotation> List<Class<T>> getAnnotatedClasses(Class<A> annotationClass, Class<T> type, String memberName) {
        return this.getAnnotatedValues(annotationClass, type.getClass(), memberName);
    }

    protected <A extends Annotation> Annotation getAnnotation(Class<A> annotationClass) {
        return this.annotatedClass.getAnnotation(annotationClass);
    }

    protected Object getAnnotationValue(Annotation annotation, String attributeName) {
        try {
            Method method = annotation.annotationType().getDeclaredMethod(attributeName, new Class[0]);
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

