/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.embedder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jbehave.core.ConfigurableEmbedder;
import org.jbehave.core.Embeddable;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.embedder.EmbedderClassLoader;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.embedder.PerformableTree;
import org.jbehave.core.embedder.PrintStreamEmbedderMonitor;
import org.jbehave.core.embedder.StoryManager;
import org.jbehave.core.embedder.StoryMapper;
import org.jbehave.core.embedder.StoryRunner;
import org.jbehave.core.embedder.StoryTimeouts;
import org.jbehave.core.embedder.executors.FixedThreadExecutors;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.failures.FailingUponPendingStep;
import org.jbehave.core.junit.AnnotatedEmbedderRunner;
import org.jbehave.core.junit.AnnotatedEmbedderUtils;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryMaps;
import org.jbehave.core.reporters.ReportsCount;
import org.jbehave.core.reporters.StepdocReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.reporters.ViewGenerator;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ProvidedStepsFactory;
import org.jbehave.core.steps.StepFinder;
import org.jbehave.core.steps.Stepdoc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Embedder {
    protected StoryMapper storyMapper;
    protected StoryRunner storyRunner;
    protected EmbedderMonitor embedderMonitor;
    protected EmbedderClassLoader classLoader;
    protected EmbedderControls embedderControls;
    protected EmbedderFailureStrategy embedderFailureStrategy;
    protected Configuration configuration;
    protected List<CandidateSteps> candidateSteps;
    protected InjectableStepsFactory stepsFactory;
    protected List<String> metaFilters;
    protected Properties systemProperties;
    protected ExecutorService executorService;
    protected boolean executorServiceCreated;
    protected PerformableTree performableTree;
    protected StoryManager storyManager;
    protected StoryTimeouts.TimeoutParser[] timeoutParsers;

    public Embedder() {
        this(new PrintStreamEmbedderMonitor());
    }

    public Embedder(EmbedderMonitor embedderMonitor) {
        this(new StoryMapper(), new PerformableTree(), embedderMonitor);
    }

    public Embedder(StoryMapper storyMapper, PerformableTree performableTree, EmbedderMonitor embedderMonitor) {
        this.storyMapper = storyMapper;
        this.performableTree = performableTree;
        this.embedderMonitor = embedderMonitor;
    }

    public void mapStoriesAsPaths(List<String> storyPaths) {
        EmbedderControls embedderControls = this.embedderControls();
        this.embedderMonitor.usingControls(embedderControls);
        if (embedderControls.skip()) {
            this.embedderMonitor.storiesSkipped(storyPaths);
            return;
        }
        this.processSystemProperties();
        StoryManager storyManager = this.storyManager();
        for (String storyPath : storyPaths) {
            Story story = storyManager.storyOfPath(storyPath);
            this.embedderMonitor.mappingStory(storyPath, this.metaFilters());
            this.storyMapper.map(story, new MetaFilter(""));
            for (String filter : this.metaFilters) {
                this.storyMapper.map(story, new MetaFilter(filter));
            }
        }
        this.generateMapsView(this.storyMapper.getStoryMaps());
    }

    private void generateMapsView(StoryMaps storyMaps) {
        Configuration configuration = this.configuration();
        StoryReporterBuilder builder = configuration.storyReporterBuilder();
        File outputDirectory = builder.outputDirectory();
        Properties viewResources = builder.viewResources();
        ViewGenerator viewGenerator = configuration.viewGenerator();
        try {
            this.embedderMonitor.generatingMapsView(outputDirectory, storyMaps, viewResources);
            viewGenerator.generateMapsView(outputDirectory, storyMaps, viewResources);
        }
        catch (RuntimeException e) {
            this.embedderMonitor.mapsViewGenerationFailed(outputDirectory, storyMaps, viewResources, e);
            throw new ViewGenerationFailed(outputDirectory, storyMaps, viewResources, e);
        }
    }

    public void runAsEmbeddables(List<String> classNames) {
        EmbedderControls embedderControls = this.embedderControls();
        this.embedderMonitor.usingControls(embedderControls);
        if (embedderControls.skip()) {
            this.embedderMonitor.embeddablesSkipped(classNames);
            return;
        }
        BatchFailures failures = new BatchFailures(embedderControls.verboseFailures());
        for (Embeddable embeddable : this.embeddables(classNames, this.classLoader())) {
            String name = embeddable.getClass().getName();
            try {
                this.embedderMonitor.runningEmbeddable(name);
                embeddable.useEmbedder(this);
                embeddable.run();
            }
            catch (Throwable e) {
                if (embedderControls.batch()) {
                    failures.put(name, e);
                    continue;
                }
                if (this.ignoreFailure(embedderControls)) {
                    this.embedderMonitor.embeddableFailed(name, e);
                    continue;
                }
                throw new RunningEmbeddablesFailed(name, e);
            }
        }
        if (embedderControls.batch() && failures.size() > 0) {
            if (this.ignoreFailure(embedderControls)) {
                this.embedderMonitor.batchFailed(failures);
            } else {
                throw new RunningEmbeddablesFailed(failures);
            }
        }
    }

    private boolean ignoreFailure(EmbedderControls embedderControls) {
        boolean ignore = embedderControls.ignoreFailureInStories();
        if (embedderControls.generateViewAfterStories()) {
            ignore = ignore && embedderControls.ignoreFailureInView();
        }
        return ignore;
    }

    private List<Embeddable> embeddables(List<String> classNames, EmbedderClassLoader classLoader) {
        ArrayList<Embeddable> embeddables = new ArrayList<Embeddable>();
        for (String className : classNames) {
            if (classLoader.isAbstract(className)) continue;
            embeddables.add(classLoader.newInstance(Embeddable.class, className));
        }
        return embeddables;
    }

    public void runStoriesWithAnnotatedEmbedderRunner(List<String> classNames) {
        EmbedderClassLoader classLoader = this.classLoader();
        for (String className : classNames) {
            this.embedderMonitor.runningWithAnnotatedEmbedderRunner(className);
            AnnotatedEmbedderRunner runner = AnnotatedEmbedderUtils.annotatedEmbedderRunner(className, classLoader);
            try {
                Object annotatedInstance = runner.createTest();
                if (annotatedInstance instanceof Embeddable) {
                    ((Embeddable)annotatedInstance).run();
                    continue;
                }
                this.embedderMonitor.annotatedInstanceNotOfType(annotatedInstance, Embeddable.class);
            }
            catch (Throwable e) {
                throw new AnnotatedEmbedderRunFailed(runner, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runStoriesAsPaths(List<String> storyPaths) {
        this.processSystemProperties();
        EmbedderControls embedderControls = this.embedderControls();
        this.embedderMonitor.usingControls(embedderControls);
        if (embedderControls.skip()) {
            this.embedderMonitor.storiesSkipped(storyPaths);
            return;
        }
        try {
            StoryManager storyManager = this.storyManager();
            MetaFilter filter = this.metaFilter();
            BatchFailures failures = new BatchFailures(embedderControls.verboseFailures());
            storyManager.runStoriesAsPaths(storyPaths, filter, failures);
            this.handleFailures(failures);
        }
        finally {
            try {
                if (embedderControls.generateViewAfterStories()) {
                    this.generateReportsView();
                }
            }
            finally {
                this.shutdownExecutorService();
            }
        }
    }

    private void handleFailures(BatchFailures failures) {
        if (failures.size() > 0) {
            if (this.embedderControls().ignoreFailureInStories()) {
                this.embedderMonitor.batchFailed(failures);
            } else {
                this.embedderFailureStrategy().handleFailures(failures);
            }
        }
    }

    public void generateReportsView() {
        StoryReporterBuilder builder = this.configuration().storyReporterBuilder();
        File outputDirectory = builder.outputDirectory();
        List<String> formatNames = builder.formatNames(true);
        this.generateReportsView(outputDirectory, formatNames, builder.viewResources());
    }

    public void generateReportsView(File outputDirectory, List<String> formats, Properties viewResources) {
        if (this.embedderControls().skip()) {
            this.embedderMonitor.reportsViewNotGenerated();
            return;
        }
        ViewGenerator viewGenerator = this.configuration().viewGenerator();
        try {
            this.embedderMonitor.generatingReportsView(outputDirectory, formats, viewResources);
            viewGenerator.generateReportsView(outputDirectory, formats, viewResources);
        }
        catch (RuntimeException e) {
            this.embedderMonitor.reportsViewGenerationFailed(outputDirectory, formats, viewResources, e);
            throw new ViewGenerationFailed(outputDirectory, formats, viewResources, e);
        }
        ReportsCount count = viewGenerator.getReportsCount();
        this.embedderMonitor.reportsViewGenerated(count);
        this.handleFailures(count);
    }

    private void handleFailures(ReportsCount count) {
        boolean failed = count.failed();
        if (this.configuration().pendingStepStrategy() instanceof FailingUponPendingStep) {
            boolean bl = failed = failed || count.pending();
        }
        if (failed) {
            if (this.embedderControls().ignoreFailureInView()) {
                this.embedderMonitor.reportsViewFailures(count);
            } else {
                this.embedderFailureStrategy().handleFailures(count);
            }
        }
    }

    public void generateCrossReference() {
        StoryReporterBuilder builder = this.configuration().storyReporterBuilder();
        if (builder.hasCrossReference()) {
            builder.crossReference().serialise(this.storyManager().performableRoot(), builder.outputDirectory());
        }
    }

    public void reportStepdocs() {
        this.reportStepdocs(this.configuration(), this.candidateSteps());
    }

    public void reportStepdocsAsEmbeddables(List<String> classNames) {
        EmbedderControls embedderControls = this.embedderControls();
        if (embedderControls.skip()) {
            this.embedderMonitor.embeddablesSkipped(classNames);
            return;
        }
        for (Embeddable embeddable : this.embeddables(classNames, this.classLoader())) {
            if (embeddable instanceof ConfigurableEmbedder) {
                ConfigurableEmbedder configurableEmbedder = (ConfigurableEmbedder)embeddable;
                Embedder configuredEmbedder = configurableEmbedder.configuredEmbedder();
                List<CandidateSteps> steps = configuredEmbedder.candidateSteps();
                if (steps.isEmpty()) {
                    steps = configuredEmbedder.stepsFactory().createCandidateSteps();
                }
                this.reportStepdocs(configuredEmbedder.configuration(), steps);
                continue;
            }
            this.embedderMonitor.embeddableNotConfigurable(embeddable.getClass().getName());
        }
    }

    public void reportStepdocs(Configuration configuration, List<CandidateSteps> candidateSteps) {
        StepFinder finder = configuration.stepFinder();
        StepdocReporter reporter = configuration.stepdocReporter();
        List<Object> stepsInstances = finder.stepsInstances(candidateSteps);
        reporter.stepdocs(finder.stepdocs(candidateSteps), stepsInstances);
    }

    public void reportMatchingStepdocs(String stepAsString) {
        Configuration configuration = this.configuration();
        List<CandidateSteps> candidateSteps = this.candidateSteps();
        StepFinder finder = configuration.stepFinder();
        StepdocReporter reporter = configuration.stepdocReporter();
        List<Stepdoc> matching = finder.findMatching(stepAsString, candidateSteps);
        List<Object> stepsInstances = finder.stepsInstances(candidateSteps);
        reporter.stepdocsMatching(stepAsString, matching, stepsInstances);
    }

    public void processSystemProperties() {
        Properties properties = this.systemProperties();
        this.embedderMonitor.processingSystemProperties(properties);
        if (!properties.isEmpty()) {
            for (Object key : properties.keySet()) {
                String name = (String)key;
                String value = properties.getProperty(name);
                System.setProperty(name, value);
                this.embedderMonitor.systemPropertySet(name, value);
            }
        }
    }

    public EmbedderClassLoader classLoader() {
        if (this.classLoader == null) {
            this.classLoader = new EmbedderClassLoader(this.getClass().getClassLoader());
        }
        return this.classLoader;
    }

    public Configuration configuration() {
        if (this.configuration == null) {
            this.configuration = new MostUsefulConfiguration();
        }
        this.configureThreads(this.configuration, this.embedderControls().threads());
        return this.configuration;
    }

    public List<CandidateSteps> candidateSteps() {
        if (this.candidateSteps == null) {
            this.candidateSteps = new ArrayList<CandidateSteps>();
        }
        return this.candidateSteps;
    }

    public InjectableStepsFactory stepsFactory() {
        if (this.stepsFactory == null) {
            this.stepsFactory = new ProvidedStepsFactory(this.candidateSteps());
        }
        return this.stepsFactory;
    }

    public EmbedderControls embedderControls() {
        if (this.embedderControls == null) {
            this.embedderControls = new EmbedderControls();
        }
        return this.embedderControls;
    }

    public EmbedderMonitor embedderMonitor() {
        return this.embedderMonitor;
    }

    public EmbedderFailureStrategy embedderFailureStrategy() {
        if (this.embedderFailureStrategy == null) {
            this.embedderFailureStrategy = new ThrowingRunningStoriesFailed();
        }
        return this.embedderFailureStrategy;
    }

    public boolean hasExecutorService() {
        return this.executorService != null;
    }

    public ExecutorService executorService() {
        if (this.executorService == null) {
            this.executorService = this.createExecutorService();
            this.executorServiceCreated = true;
        }
        return this.executorService;
    }

    private ExecutorService createExecutorService() {
        return new FixedThreadExecutors().create(this.embedderControls());
    }

    protected void shutdownExecutorService() {
        if (this.executorServiceCreated) {
            this.executorService.shutdownNow();
            this.executorService = null;
            this.executorServiceCreated = false;
        }
    }

    public StoryManager storyManager() {
        if (this.storyManager == null) {
            this.storyManager = this.createStoryManager();
        }
        return this.storyManager;
    }

    private StoryManager createStoryManager() {
        return new StoryManager(this.configuration(), this.stepsFactory(), this.embedderControls(), this.embedderMonitor(), this.executorService(), this.performableTree(), this.timeoutParsers());
    }

    protected void configureThreads(Configuration configuration, int threads) {
        StoryReporterBuilder reporterBuilder = configuration.storyReporterBuilder();
        reporterBuilder.withMultiThreading(threads > 1);
        configuration.useStoryReporterBuilder(reporterBuilder);
    }

    public List<String> metaFilters() {
        if (this.metaFilters == null) {
            this.metaFilters = new ArrayList<String>();
        }
        return this.metaFilters;
    }

    public MetaFilter metaFilter() {
        return new MetaFilter(StringUtils.join(this.metaFilters(), (String)" "), this.embedderMonitor);
    }

    public StoryRunner storyRunner() {
        return this.storyRunner;
    }

    public PerformableTree performableTree() {
        return this.performableTree;
    }

    public Properties systemProperties() {
        if (this.systemProperties == null) {
            this.systemProperties = new Properties();
        }
        return this.systemProperties;
    }

    public StoryTimeouts.TimeoutParser[] timeoutParsers() {
        if (this.timeoutParsers == null) {
            this.timeoutParsers = new StoryTimeouts.TimeoutParser[0];
        }
        return this.timeoutParsers;
    }

    public void useClassLoader(EmbedderClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void useConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void useCandidateSteps(List<CandidateSteps> candidateSteps) {
        this.candidateSteps = candidateSteps;
    }

    public void useStepsFactory(InjectableStepsFactory stepsFactory) {
        this.stepsFactory = stepsFactory;
    }

    public void useEmbedderControls(EmbedderControls embedderControls) {
        this.embedderControls = embedderControls;
    }

    public void useEmbedderFailureStrategy(EmbedderFailureStrategy failureStategy) {
        this.embedderFailureStrategy = failureStategy;
    }

    public void useEmbedderMonitor(EmbedderMonitor embedderMonitor) {
        this.embedderMonitor = embedderMonitor;
    }

    public void useExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        this.embedderMonitor.usingExecutorService(executorService);
    }

    public void useMetaFilters(List<String> metaFilters) {
        this.metaFilters = metaFilters;
    }

    public void usePerformableTree(PerformableTree performableTree) {
        this.performableTree = performableTree;
    }

    public void useStoryRunner(StoryRunner storyRunner) {
        this.storyRunner = storyRunner;
    }

    public void useSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public void useTimeoutParsers(StoryTimeouts.TimeoutParser ... timeoutParsers) {
        this.timeoutParsers = timeoutParsers;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewGenerationFailed
    extends RuntimeException {
        public ViewGenerationFailed(File outputDirectory, List<String> formats, Properties viewResources, RuntimeException cause) {
            super("View generation failed to " + outputDirectory + " for formats " + formats + " and resources " + viewResources, cause);
        }

        public ViewGenerationFailed(File outputDirectory, StoryMaps storyMaps, Properties viewResources, RuntimeException cause) {
            super("View generation failed to " + outputDirectory + " for story maps " + storyMaps + " for resources " + viewResources, cause);
        }
    }

    public static class RunningStoriesFailed
    extends RuntimeException {
        public RunningStoriesFailed(ReportsCount reportsCount) {
            super("Failures in running stories: " + reportsCount);
        }

        public RunningStoriesFailed(BatchFailures failures) {
            super("Failures in running stories: " + failures);
        }
    }

    public static class RunningEmbeddablesFailed
    extends RuntimeException {
        public RunningEmbeddablesFailed(String name, Throwable failure) {
            super("Failure in running embeddable: " + name, failure);
        }

        public RunningEmbeddablesFailed(BatchFailures failures) {
            super("Failures in running embeddables: " + failures);
        }
    }

    public static class AnnotatedEmbedderRunFailed
    extends RuntimeException {
        public AnnotatedEmbedderRunFailed(AnnotatedEmbedderRunner runner, Throwable cause) {
            super("Annotated embedder run failed with runner " + ((Object)((Object)runner)).toString(), cause);
        }
    }

    public static class ThrowingRunningStoriesFailed
    implements EmbedderFailureStrategy {
        public void handleFailures(BatchFailures failures) {
            throw new RunningStoriesFailed(failures);
        }

        public void handleFailures(ReportsCount count) {
            throw new RunningStoriesFailed(count);
        }
    }

    public static interface EmbedderFailureStrategy {
        public void handleFailures(BatchFailures var1);

        public void handleFailures(ReportsCount var1);
    }
}

