/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.junit;

import java.util.List;
import org.jbehave.core.configuration.AnnotationBuilder;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.EmbedderMonitorDecorator;
import org.jbehave.core.io.StoryNameResolver;
import org.jbehave.core.io.UnderscoredToCapitalized;
import org.jbehave.core.junit.AnnotatedEmbedderRunner;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedPathRunner
extends AnnotatedEmbedderRunner {
    private final AnnotationBuilder annotationBuilder = this.annotationBuilder();
    private final StoryNameResolver nameResolver = this.storyNameResolver();
    private final List<String> paths = this.annotationBuilder.findPaths();

    public AnnotatedPathRunner(Class<?> annotatedClass) throws InitializationError {
        super(annotatedClass);
    }

    protected StoryNameResolver storyNameResolver() {
        return new UnderscoredToCapitalized();
    }

    public Description getDescription() {
        Description description = Description.createSuiteDescription(this.testClass());
        for (String path : this.paths) {
            description.addChild(this.createDescriptionForPath(path));
        }
        return description;
    }

    private Description createDescriptionForPath(String path) {
        String name = this.nameResolver.resolveName(path);
        return Description.createTestDescription(this.testClass(), (String)name);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
    }

    protected void validateInstanceMethods(List<Throwable> errors) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        Embedder embedder = this.annotationBuilder.buildEmbedder();
        NotifierEmbedderMonitor notifierEmbedderMonitor = new NotifierEmbedderMonitor(embedder.embedderMonitor(), notifier);
        embedder.useEmbedderMonitor(notifierEmbedderMonitor);
        try {
            embedder.runStoriesAsPaths(this.paths);
        }
        finally {
            notifierEmbedderMonitor.storyFinished();
        }
    }

    private final class NotifierEmbedderMonitor
    extends EmbedderMonitorDecorator {
        private final RunNotifier notifier;
        private Description currentStory;

        private NotifierEmbedderMonitor(EmbedderMonitor delegate, RunNotifier notifier) {
            super(delegate);
            this.notifier = notifier;
        }

        public void runningStory(String path) {
            super.runningStory(path);
            this.storyFinished();
            this.currentStory = AnnotatedPathRunner.this.createDescriptionForPath(path);
            this.notifier.fireTestStarted(this.currentStory);
        }

        public void storyFailed(String path, Throwable cause) {
            super.storyFailed(path, cause);
            this.notifier.fireTestFailure(new Failure(this.currentStory, cause));
            this.notifier.fireTestFinished(this.currentStory);
            this.currentStory = null;
        }

        private void storyFinished() {
            if (this.currentStory == null) {
                return;
            }
            this.notifier.fireTestFinished(this.currentStory);
        }
    }
}

