/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.reporters;

import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import java.io.Writer;
import java.util.Map;
import org.jbehave.core.reporters.TemplateProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerProcessor
implements TemplateProcessor {
    private Class<?> templateLoadingFrom;

    public FreemarkerProcessor() {
        this(FreemarkerProcessor.class);
    }

    public FreemarkerProcessor(Class<?> templateLoadingFrom) {
        this.templateLoadingFrom = templateLoadingFrom;
    }

    @Override
    public void process(String resource, Map<String, Object> dataModel, Writer writer) {
        Configuration configuration = this.configuration();
        try {
            configuration.getTemplate(resource).process(dataModel, writer);
        }
        catch (Exception e) {
            throw new FreemarkerProcessingFailed(configuration, resource, dataModel, e);
        }
    }

    public Configuration configuration() {
        Configuration configuration = new Configuration();
        configuration.setClassForTemplateLoading(this.templateLoadingFrom, "/");
        configuration.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
        return configuration;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FreemarkerProcessingFailed
    extends RuntimeException {
        public FreemarkerProcessingFailed(Configuration configuration, String resource, Map<String, Object> dataModel, Exception cause) {
            super("Freemarker failed to process template " + resource + " using configuration " + configuration + " and data model " + dataModel, cause);
        }
    }
}

