/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.model;

import org.apache.commons.lang3.StringUtils;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.i18n.LocalizedKeywords;
import org.jbehave.core.io.LoadFromClasspath;
import org.jbehave.core.io.ResourceLoader;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.TableTransformers;
import org.jbehave.core.steps.ParameterConverters;

public class ExamplesTableFactory {
    private Keywords keywords;
    private final ResourceLoader resourceLoader;
    private final ParameterConverters parameterConverters;
    private final TableTransformers tableTransformers;

    public ExamplesTableFactory(TableTransformers tableTransformers) {
        this(new LocalizedKeywords(), tableTransformers);
    }

    public ExamplesTableFactory(Keywords keywords, TableTransformers tableTransformers) {
        this(keywords, new LoadFromClasspath(), new ParameterConverters(tableTransformers), tableTransformers);
    }

    public ExamplesTableFactory(ResourceLoader resourceLoader, TableTransformers tableTransformers) {
        this(new LocalizedKeywords(), resourceLoader, new ParameterConverters(tableTransformers), tableTransformers);
    }

    public ExamplesTableFactory(ParameterConverters parameterConverters, TableTransformers tableTransformers) {
        this(new LocalizedKeywords(), new LoadFromClasspath(), parameterConverters, tableTransformers);
    }

    public ExamplesTableFactory(Keywords keywords, ResourceLoader resourceLoader, ParameterConverters parameterConverters, TableTransformers tableTranformers) {
        this.keywords = keywords;
        this.resourceLoader = resourceLoader;
        this.parameterConverters = parameterConverters;
        this.tableTransformers = tableTranformers;
    }

    public ExamplesTableFactory(Configuration configuration) {
        this.keywords = configuration.keywords();
        this.resourceLoader = configuration.storyLoader();
        this.parameterConverters = configuration.parameterConverters();
        this.tableTransformers = configuration.tableTransformers();
    }

    public ExamplesTable createExamplesTable(String input) {
        String tableAsString = StringUtils.isBlank((CharSequence)input) || this.isTable(input) ? input : this.resourceLoader.loadResourceAsText(input);
        return new ExamplesTable(tableAsString, this.keywords.examplesTableHeaderSeparator(), this.keywords.examplesTableValueSeparator(), this.keywords.examplesTableIgnorableSeparator(), this.parameterConverters, this.tableTransformers);
    }

    protected boolean isTable(String input) {
        return input.trim().startsWith(this.keywords.examplesTableHeaderSeparator()) || ExamplesTable.INLINED_PROPERTIES_PATTERN.matcher(input).matches();
    }

    public void useKeywords(Keywords keywords) {
        this.keywords = keywords;
    }

    public Keywords keywords() {
        return this.keywords;
    }
}

