/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.se;

import java.util.Properties;
import org.jberet.repository.InMemoryRepository;
import org.jberet.repository.InfinispanRepository;
import org.jberet.repository.JdbcRepository;
import org.jberet.repository.JobRepository;
import org.jberet.repository.MongoRepository;
import org.jberet.se._private.SEBatchMessages;

class JobRepositoryFactory {
    private static final JobRepositoryFactory INSTANCE = new JobRepositoryFactory();
    private JobRepository jobRepository;

    private JobRepositoryFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobRepository getJobRepository(Properties configProperties) {
        JobRepository jobRepository;
        String repositoryType = null;
        if (configProperties != null && (repositoryType = configProperties.getProperty("job-repository-type")) != null) {
            repositoryType = repositoryType.trim();
        }
        JobRepositoryFactory jobRepositoryFactory = INSTANCE;
        synchronized (jobRepositoryFactory) {
            jobRepository = JobRepositoryFactory.INSTANCE.jobRepository;
            if (repositoryType == null || repositoryType.equalsIgnoreCase("in-memory")) {
                if (!(jobRepository instanceof InMemoryRepository)) {
                    jobRepository = JobRepositoryFactory.INSTANCE.jobRepository = InMemoryRepository.getInstance();
                }
            } else if (repositoryType.isEmpty() || repositoryType.equalsIgnoreCase("jdbc")) {
                if (!(jobRepository instanceof JdbcRepository)) {
                    jobRepository = JobRepositoryFactory.INSTANCE.jobRepository = JdbcRepository.create((Properties)configProperties);
                }
            } else if (repositoryType.equalsIgnoreCase("mongodb")) {
                if (!(jobRepository instanceof MongoRepository)) {
                    jobRepository = JobRepositoryFactory.INSTANCE.jobRepository = MongoRepository.create((Properties)configProperties);
                }
            } else if (repositoryType.equalsIgnoreCase("infinispan")) {
                if (!(jobRepository instanceof InfinispanRepository)) {
                    jobRepository = JobRepositoryFactory.INSTANCE.jobRepository = InfinispanRepository.create((Properties)configProperties);
                }
            } else {
                throw SEBatchMessages.MESSAGES.unrecognizedJobRepositoryType(repositoryType);
            }
        }
        return jobRepository;
    }
}

