/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.strategy;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.persistence.api.TransactionManager;
import org.drools.persistence.api.TransactionManagerFactory;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.jbpm.process.audit.strategy.PersistenceStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneJtaStrategy
implements PersistenceStrategy {
    private static final Logger logger = LoggerFactory.getLogger(JPAWorkingMemoryDbLogger.class);
    private static final String[] KNOWN_UT_JNDI_KEYS = new String[]{"UserTransaction", "java:jboss/UserTransaction", System.getProperty("jbpm.ut.jndi.lookup")};
    protected EntityManagerFactory emf;
    private static final Object USER_MANAGED_TRANSACTION = new Object();

    public StandaloneJtaStrategy(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.emf.createEntityManager();
    }

    @Override
    public Object joinTransaction(EntityManager em) {
        boolean newTx = false;
        TransactionManager txm = TransactionManagerFactory.get().newTransactionManager();
        if (txm == null) {
            throw new IllegalStateException("Unable to find JTA transaction.");
        }
        try {
            if (txm.getStatus() == 3) {
                txm.begin();
                newTx = true;
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to find or open a transaction: " + ex.getMessage(), ex);
        }
        try {
            em.joinTransaction();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to join EntityManager to transaction: " + e.getMessage(), e);
        }
        if (newTx) {
            return txm;
        }
        return USER_MANAGED_TRANSACTION;
    }

    @Override
    public void leaveTransaction(EntityManager em, Object transaction) {
        this.commitTransaction(transaction);
        em.clear();
        em.close();
    }

    protected void commitTransaction(Object transaction) {
        if (transaction == USER_MANAGED_TRANSACTION) {
            return;
        }
        TransactionManager txm = (TransactionManager)transaction;
        try {
            if (txm != null) {
                txm.commit(true);
            }
        }
        catch (Exception e) {
            logger.error("Unable to commit transaction: ", (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        this.emf = null;
    }
}

