/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.service;

import java.util.Date;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.query.AbstractAuditQueryBuilderImpl;
import org.jbpm.services.task.audit.impl.model.AuditTaskImpl;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.task.model.Status;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.task.api.AuditTask;
import org.kie.internal.task.query.AuditTaskQueryBuilder;

public class AuditTaskQueryBuilderImpl
extends AbstractAuditQueryBuilderImpl<AuditTaskQueryBuilder, AuditTask>
implements AuditTaskQueryBuilder {
    public AuditTaskQueryBuilderImpl(CommandExecutor cmdService) {
        super(cmdService);
    }

    public AuditTaskQueryBuilderImpl(JPAAuditLogService jpaAuditService) {
        super(jpaAuditService);
    }

    public AuditTaskQueryBuilder taskId(long ... taskId) {
        this.addLongParameter(QueryParameterIdentifiers.TASK_ID_LIST, "task id", taskId);
        return this;
    }

    public AuditTaskQueryBuilder taskIdRange(Long taskIdMin, Long taskIdMax) {
        long[] params = new long[]{taskIdMin, taskIdMax};
        this.addRangeParameters(QueryParameterIdentifiers.TASK_ID_LIST, "task id", taskIdMin, taskIdMax);
        return this;
    }

    public AuditTaskQueryBuilder taskStatus(Status ... status) {
        Object[] stringStatuses = null;
        if (status != null) {
            stringStatuses = new String[status.length];
            for (int i = 0; i < status.length; ++i) {
                stringStatuses[i] = status[i].toString();
            }
        }
        this.addObjectParameter(QueryParameterIdentifiers.TASK_STATUS_LIST, "task status", stringStatuses);
        return this;
    }

    public AuditTaskQueryBuilder actualOwner(String ... actualOwnerUserId) {
        this.addObjectParameter(QueryParameterIdentifiers.ACTUAL_OWNER_ID_LIST, "actual owner", actualOwnerUserId);
        return this;
    }

    public AuditTaskQueryBuilder deploymentId(String ... deploymentId) {
        this.addObjectParameter(QueryParameterIdentifiers.DEPLOYMENT_ID_LIST, "deployment id", deploymentId);
        return this;
    }

    public AuditTaskQueryBuilder id(long ... id) {
        this.addLongParameter(QueryParameterIdentifiers.ID_LIST, "id", id);
        return this;
    }

    public AuditTaskQueryBuilder createdOn(Date ... createdOn) {
        this.addObjectParameter(QueryParameterIdentifiers.CREATED_ON_LIST, "created on", createdOn);
        return this;
    }

    public AuditTaskQueryBuilder createdOnRange(Date createdOnMin, Date createdOnMax) {
        this.addRangeParameters(QueryParameterIdentifiers.CREATED_ON_LIST, "created on", createdOnMin, createdOnMax);
        return this;
    }

    public AuditTaskQueryBuilder taskParentId(long ... parentId) {
        this.addLongParameter(QueryParameterIdentifiers.TASK_PARENT_ID_LIST, "parent id", parentId);
        return this;
    }

    public AuditTaskQueryBuilder createdBy(String ... createdByUserId) {
        this.addObjectParameter(QueryParameterIdentifiers.CREATED_BY_LIST, "created by", createdByUserId);
        return this;
    }

    public AuditTaskQueryBuilder activationTime(Date ... activationTime) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_ACTIVATION_TIME_LIST, "activation time", activationTime);
        return this;
    }

    public AuditTaskQueryBuilder activationTimeRange(Date activationTimeMin, Date activationTimeMax) {
        this.addRangeParameters(QueryParameterIdentifiers.TASK_ACTIVATION_TIME_LIST, "activation time", activationTimeMin, activationTimeMax);
        return this;
    }

    public AuditTaskQueryBuilder taskName(String ... name) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_NAME_LIST, "task name", name);
        return this;
    }

    public AuditTaskQueryBuilder description(String ... description) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_DESCRIPTION_LIST, "task description", description);
        return this;
    }

    public AuditTaskQueryBuilder workItemId(long ... workItemId) {
        this.addLongParameter(QueryParameterIdentifiers.WORK_ITEM_ID_LIST, "work item id", workItemId);
        return this;
    }

    public AuditTaskQueryBuilder priority(int ... priority) {
        this.addIntParameter(QueryParameterIdentifiers.TASK_PRIORITY_LIST, "priority", priority);
        return this;
    }

    public AuditTaskQueryBuilder processSessionId(long ... processSessionId) {
        this.addLongParameter(QueryParameterIdentifiers.TASK_PROCESS_SESSION_ID_LIST, "priority session id", processSessionId);
        return this;
    }

    public AuditTaskQueryBuilder dueDate(Date ... dueDate) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_DUE_DATE_LIST, "due date", dueDate);
        return this;
    }

    public AuditTaskQueryBuilder dueDateRange(Date dueDateMin, Date dueDateMax) {
        this.addRangeParameters(QueryParameterIdentifiers.TASK_DUE_DATE_LIST, "due date", dueDateMin, dueDateMax);
        return this;
    }

    public AuditTaskQueryBuilder ascending(AuditTaskQueryBuilder.OrderBy field) {
        String listId = this.convertOrderByToListId(field);
        this.queryWhere.setAscending(listId);
        return this;
    }

    public AuditTaskQueryBuilder descending(AuditTaskQueryBuilder.OrderBy field) {
        String listId = this.convertOrderByToListId(field);
        this.queryWhere.setDescending(listId);
        return this;
    }

    private String convertOrderByToListId(AuditTaskQueryBuilder.OrderBy field) {
        String listId;
        switch (field) {
            case activationTime: {
                listId = QueryParameterIdentifiers.TASK_ACTIVATION_TIME_LIST;
                break;
            }
            case taskId: {
                listId = QueryParameterIdentifiers.TASK_ID_LIST;
                break;
            }
            case createdOn: {
                listId = QueryParameterIdentifiers.CREATED_ON_LIST;
                break;
            }
            case processId: {
                listId = QueryParameterIdentifiers.PROCESS_ID_LIST;
                break;
            }
            case processInstanceId: {
                listId = QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown 'order-by' field: " + field.toString());
            }
        }
        return listId;
    }

    protected Class<AuditTask> getResultType() {
        return AuditTask.class;
    }

    protected Class<AuditTaskImpl> getQueryType() {
        return AuditTaskImpl.class;
    }
}

