/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.ant.AntHelper;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.util.ArrayUtil;

public class DeployProcessTask
extends MatchingTask {
    private String jbpmCfg;
    private File process;
    private List fileSets;
    private boolean failOnError = true;

    public void execute() throws BuildException {
        JbpmConfiguration jbpmConfiguration = AntHelper.getJbpmConfiguration(this.jbpmCfg);
        if (this.process != null) {
            this.handleProcessFile(jbpmConfiguration, this.process);
        }
        for (FileSet fileSet : this.fileSets) {
            DirectoryScanner dirScanner = fileSet.getDirectoryScanner(this.getProject());
            File baseDir = dirScanner.getBasedir();
            String[] includedFiles = dirScanner.getIncludedFiles();
            Object[] excludedFiles = dirScanner.getExcludedFiles();
            for (int i = 0; i < includedFiles.length; ++i) {
                String fileName = includedFiles[i];
                if (ArrayUtil.contains(excludedFiles, fileName)) continue;
                this.handleProcessFile(jbpmConfiguration, new File(baseDir, fileName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProcessFile(JbpmConfiguration jbpmConfiguration, File processFile) {
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        try {
            ProcessDefinition processDefinition = this.parseProcessArchive(processFile);
            this.deployProcessDefinition(processDefinition, jbpmContext);
        }
        catch (IOException e) {
            if (this.failOnError) {
                throw new BuildException("failed to read file " + processFile, (Throwable)e, this.getLocation());
            }
            this.log("failed to read file " + processFile, e, 0);
        }
        finally {
            jbpmContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessDefinition parseProcessArchive(File processFile) throws IOException {
        this.log("parsing process archive " + processFile);
        ZipInputStream processStream = new ZipInputStream(new FileInputStream(processFile));
        try {
            ProcessDefinition processDefinition = ProcessDefinition.parseParZipInputStream(processStream);
            return processDefinition;
        }
        finally {
            processStream.close();
        }
    }

    private void deployProcessDefinition(ProcessDefinition processDefinition, JbpmContext jbpmContext) {
        this.log("deploying " + processDefinition);
        try {
            jbpmContext.deployProcessDefinition(processDefinition);
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            if (this.failOnError) {
                throw new BuildException("failed to deploy " + processDefinition, (Throwable)e, this.getLocation());
            }
            this.log("failed to deploy " + processDefinition, e, 0);
        }
    }

    public void addFileset(FileSet fileSet) {
        if (this.fileSets == null) {
            this.fileSets = new ArrayList();
        }
        this.fileSets.add(fileSet);
    }

    public void setJbpmCfg(String jbpmCfg) {
        this.jbpmCfg = jbpmCfg;
    }

    public void setProcess(File process) {
        this.process = process;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

