/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.xml;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.jbpm.JbpmConfiguration;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.jpdl.xml.ProblemListener;
import org.jbpm.util.ClassLoaderUtil;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class JpdlParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final SAXParserFactory saxParserFactory = JpdlParser.createSaxParserFactory();
    private static final Set schemaResources = (Set)JbpmConfiguration.Configs.getObject("jbpm.schema.resources");
    private static String[] schemaSource;
    private static final Log log;

    private JpdlParser() {
    }

    public static Document parse(InputSource inputSource, ProblemListener problemListener) throws DocumentException {
        try {
            SAXReader saxReader = JpdlParser.createSaxReader(problemListener);
            return saxReader.read(inputSource);
        }
        catch (SAXException e) {
            throw new DocumentException("failed to create sax reader", (Throwable)e);
        }
    }

    public static SAXReader createSaxReader(ProblemListener problemListener) throws SAXException {
        XMLReader xmlReader = JpdlParser.createXmlReader();
        SAXReader saxReader = new SAXReader(xmlReader);
        saxReader.setErrorHandler((ErrorHandler)new JpdlErrorHandler(problemListener));
        return saxReader;
    }

    public static XMLReader createXmlReader() throws SAXException {
        SAXParser saxParser;
        try {
            saxParser = saxParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        try {
            saxParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        }
        catch (SAXException e) {
            log.warn((Object)"failed to set schema language to xml schema", (Throwable)e);
        }
        Object schemaSource = JpdlParser.getSchemaSource();
        try {
            saxParser.setProperty(JAXP_SCHEMA_SOURCE, schemaSource);
        }
        catch (SAXException e) {
            log.warn((Object)("failed to set schema source to " + schemaSource), (Throwable)e);
        }
        XMLReader xmlReader = saxParser.getXMLReader();
        try {
            xmlReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
        }
        catch (SAXException e) {
            log.warn((Object)"failed to enable dynamic validation", (Throwable)e);
        }
        return xmlReader;
    }

    private static synchronized Object getSchemaSource() {
        if (schemaSource == null) {
            ClassLoader classLoader = ClassLoaderUtil.getClassLoader();
            ArrayList<String> schemaLocations = new ArrayList<String>(schemaResources.size());
            for (String schemaResource : schemaResources) {
                URL schemaURL = classLoader.getResource(schemaResource);
                if (schemaURL == null) continue;
                String schemaLocation = schemaURL.toString();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("located schema resource " + schemaResource));
                }
                schemaLocations.add(schemaLocation);
            }
            schemaSource = new String[schemaLocations.size()];
            schemaLocations.toArray(schemaSource);
        }
        return schemaSource;
    }

    public static synchronized void addSchemaResource(String resourceName) {
        schemaResources.add(resourceName);
        schemaSource = null;
    }

    private static SAXParserFactory createSaxParserFactory() {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setValidating(true);
        saxParserFactory.setNamespaceAware(true);
        return saxParserFactory;
    }

    static {
        log = LogFactory.getLog(JpdlParser.class);
    }

    private static class JpdlErrorHandler
    implements ErrorHandler,
    Serializable {
        private ProblemListener problemListener;
        private static final long serialVersionUID = 1L;

        JpdlErrorHandler(ProblemListener problemListener) {
            this.problemListener = problemListener;
        }

        public void warning(SAXParseException pe) {
            this.addProblem(3, pe);
        }

        public void error(SAXParseException pe) {
            this.addProblem(2, pe);
        }

        public void fatalError(SAXParseException pe) {
            this.addProblem(1, pe);
        }

        private void addProblem(int level, SAXParseException pe) {
            Problem problem = new Problem(level, pe.getMessage(), pe);
            problem.setResource(pe.getSystemId());
            int line = pe.getLineNumber();
            if (line != -1) {
                problem.setLine(new Integer(line));
            }
            this.problemListener.addProblem(problem);
        }
    }
}

