/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.jta;

import javax.transaction.UserTransaction;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.persistence.jta.JtaDbPersistenceService;
import org.jbpm.svc.Service;
import org.jbpm.util.JndiUtil;

public class JtaDbPersistenceServiceFactory
extends DbPersistenceServiceFactory {
    private static final long serialVersionUID = 1L;
    private UserTransaction userTransaction;

    public JtaDbPersistenceServiceFactory() {
        this.setCurrentSessionEnabled(true);
        this.setTransactionEnabled(false);
    }

    public Service openService() {
        return new JtaDbPersistenceService(this);
    }

    public synchronized UserTransaction getUserTransaction() {
        if (this.userTransaction == null) {
            String jndiName = this.getConfiguration().getProperty("jta.UserTransaction");
            if (jndiName == null) {
                jndiName = "java:comp/UserTransaction";
            }
            this.userTransaction = (UserTransaction)JndiUtil.lookup(jndiName, UserTransaction.class);
        }
        return this.userTransaction;
    }
}

