/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console;

import java.util.ArrayList;
import java.util.List;
import org.jboss.bpm.console.client.model.DeploymentRef;
import org.jboss.bpm.console.client.model.JobRef;
import org.jboss.bpm.console.server.plugin.ProcessEnginePlugin;
import org.jbpm.api.Deployment;
import org.jbpm.api.ManagementService;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessDefinitionQuery;
import org.jbpm.api.RepositoryService;
import org.jbpm.api.job.Job;
import org.jbpm.integration.console.JBPMIntegration;
import org.jbpm.integration.console.ModelAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessEnginePluginImpl
extends JBPMIntegration
implements ProcessEnginePlugin {
    public List<DeploymentRef> getDeployments() {
        ArrayList<DeploymentRef> results = new ArrayList<DeploymentRef>();
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        List dpls = repositoryService.createDeploymentQuery().list();
        for (Deployment dpl : dpls) {
            DeploymentRef deploymentRef = ModelAdaptor.adoptDeployment(dpl);
            ProcessDefinitionQuery pdQuery = repositoryService.createProcessDefinitionQuery();
            pdQuery.deploymentId(dpl.getId());
            List activePds = pdQuery.list();
            for (ProcessDefinition procDef : activePds) {
                deploymentRef.getDefinitions().add(procDef.getId());
            }
            List suspendedPds = repositoryService.createProcessDefinitionQuery().deploymentId(dpl.getId()).suspended().list();
            for (ProcessDefinition procDef : suspendedPds) {
                deploymentRef.getDefinitions().add(procDef.getId());
            }
            results.add(deploymentRef);
        }
        return results;
    }

    public void deleteDeployment(String id) {
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        repositoryService.deleteDeploymentCascade(id);
    }

    public void suspendDeployment(String id, boolean isSuspended) {
        RepositoryService repositoryService = this.processEngine.getRepositoryService();
        if (isSuspended) {
            repositoryService.suspendDeployment(id);
        } else {
            repositoryService.resumeDeployment(id);
        }
    }

    public List<JobRef> getJobs() {
        ManagementService mgmtService = this.processEngine.getManagementService();
        ArrayList<JobRef> results = new ArrayList<JobRef>();
        List timers = mgmtService.createJobQuery().timers().list();
        for (Job t : timers) {
            JobRef ref = ModelAdaptor.adoptJob(t);
            ref.setType("timer");
            results.add(ref);
        }
        List msgs = mgmtService.createJobQuery().messages().list();
        for (Job t : msgs) {
            JobRef ref = ModelAdaptor.adoptJob(t);
            ref.setType("message");
            results.add(ref);
        }
        return results;
    }

    public void executeJob(String jobId) {
        ManagementService mgmtService = this.processEngine.getManagementService();
        mgmtService.executeJob(jobId);
    }
}

