/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.collect.FindResourceInSet;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Location;

@Singleton
public class TemplateToImage
implements Function<Template, Image> {
    private final FindLocationForTemplate findLocationForTemplate;
    private final Function<Template, OperatingSystem> templateToOperatingSystem;

    @Inject
    public TemplateToImage(FindLocationForTemplate findLocationForTemplate, Function<Template, OperatingSystem> templateToOperatingSystem) {
        this.findLocationForTemplate = (FindLocationForTemplate)((Object)Preconditions.checkNotNull((Object)((Object)findLocationForTemplate), (Object)"findLocationForTemplate"));
        this.templateToOperatingSystem = (Function)Preconditions.checkNotNull(templateToOperatingSystem, (Object)"templateToOperatingSystem");
    }

    public Image apply(Template template) {
        Preconditions.checkNotNull((Object)template, (Object)"template");
        OperatingSystem os = (OperatingSystem)this.templateToOperatingSystem.apply((Object)template);
        ImageBuilder builder = new ImageBuilder().ids(template.getId() + "").name(template.getName()).description(template.getDisplayText()).operatingSystem(os);
        if (!template.isCrossZones()) {
            builder.location((Location)this.findLocationForTemplate.apply(template));
        }
        return builder.build();
    }

    @Singleton
    public static class FindLocationForTemplate
    extends FindResourceInSet<Template, Location> {
        @Inject
        public FindLocationForTemplate(@Memoized Supplier<Set<? extends Location>> location) {
            super(location);
        }

        public boolean matches(Template from, Location input) {
            return input.getId().equals(Long.toString(from.getZoneId()));
        }
    }
}

