/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.io.Payload;

public class CloudStackTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected Set<Long> securityGroupIds = Sets.newLinkedHashSet();
    protected Set<Long> networkIds = Sets.newLinkedHashSet();
    protected Map<String, Long> ipsToNetworks = Maps.newLinkedHashMap();
    protected String ipOnDefaultNetwork;
    protected String keyPair;
    protected boolean setupStaticNat = true;
    public static final CloudStackTemplateOptions NONE = new CloudStackTemplateOptions();

    public CloudStackTemplateOptions clone() {
        CloudStackTemplateOptions options = new CloudStackTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof CloudStackTemplateOptions) {
            CloudStackTemplateOptions eTo = (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(to);
            eTo.securityGroupIds(this.securityGroupIds);
            eTo.networkIds(this.networkIds);
            eTo.ipsToNetworks(this.ipsToNetworks);
            eTo.ipOnDefaultNetwork(this.ipOnDefaultNetwork);
            eTo.keyPair(this.keyPair);
            eTo.setupStaticNat(this.setupStaticNat);
        }
    }

    public CloudStackTemplateOptions securityGroupId(long securityGroupId) {
        this.securityGroupIds.add(securityGroupId);
        return this;
    }

    public CloudStackTemplateOptions securityGroupIds(Iterable<Long> securityGroupIds) {
        Iterables.addAll(this.securityGroupIds, (Iterable)((Iterable)Preconditions.checkNotNull(securityGroupIds, (Object)"securityGroupIds was null")));
        return this;
    }

    public Set<Long> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public CloudStackTemplateOptions networkId(long networkId) {
        this.networkIds.add(networkId);
        return this;
    }

    public CloudStackTemplateOptions networkIds(Iterable<Long> networkIds) {
        Iterables.addAll(this.networkIds, (Iterable)((Iterable)Preconditions.checkNotNull(networkIds, (Object)"networkIds was null")));
        return this;
    }

    public Set<Long> getNetworkIds() {
        return this.networkIds;
    }

    public CloudStackTemplateOptions setupStaticNat(boolean setupStaticNat) {
        this.setupStaticNat = setupStaticNat;
        return this;
    }

    public boolean shouldSetupStaticNat() {
        return this.setupStaticNat;
    }

    public CloudStackTemplateOptions ipOnDefaultNetwork(String ipOnDefaultNetwork) {
        this.ipOnDefaultNetwork = ipOnDefaultNetwork;
        return this;
    }

    public String getIpOnDefaultNetwork() {
        return this.ipOnDefaultNetwork;
    }

    public CloudStackTemplateOptions ipsToNetworks(Map<String, Long> ipsToNetworks) {
        this.ipsToNetworks.putAll(ipsToNetworks);
        return this;
    }

    public Map<String, Long> getIpsToNetworks() {
        return this.ipsToNetworks;
    }

    public CloudStackTemplateOptions keyPair(String keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    public String getKeyPair() {
        return this.keyPair;
    }

    public CloudStackTemplateOptions blockOnPort(int port, int seconds) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public CloudStackTemplateOptions inboundPorts(int ... ports) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public CloudStackTemplateOptions authorizePublicKey(String publicKey) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public CloudStackTemplateOptions installPrivateKey(String privateKey) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    @Deprecated
    public CloudStackTemplateOptions runScript(Payload script) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.runScript(script));
    }

    public CloudStackTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public CloudStackTemplateOptions userMetadata(String key, String value) {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public static class Builder {
        public static CloudStackTemplateOptions securityGroupId(long id) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.securityGroupId(id);
        }

        public static CloudStackTemplateOptions securityGroupIds(Iterable<Long> securityGroupIds) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.securityGroupIds(securityGroupIds);
        }

        public static CloudStackTemplateOptions networkId(long id) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.networkId(id);
        }

        public static CloudStackTemplateOptions networkIds(Iterable<Long> networkIds) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.networkIds(networkIds);
        }

        public static CloudStackTemplateOptions ipOnDefaultNetwork(String ipAddress) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.ipOnDefaultNetwork(ipAddress);
        }

        public static CloudStackTemplateOptions ipsToNetworks(Map<String, Long> ipToNetworkMap) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.ipsToNetworks(ipToNetworkMap);
        }

        public static CloudStackTemplateOptions setupStaticNat(boolean setupStaticNat) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.setupStaticNat(setupStaticNat);
        }

        public static CloudStackTemplateOptions keyPair(String keyPair) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return options.keyPair(keyPair);
        }

        public static CloudStackTemplateOptions inboundPorts(int ... ports) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static CloudStackTemplateOptions blockOnPort(int port, int seconds) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static CloudStackTemplateOptions runScript(Payload script) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(options.runScript(script));
        }

        public static CloudStackTemplateOptions userMetadata(Map<String, String> userMetadata) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static CloudStackTemplateOptions userMetadata(String key, String value) {
            CloudStackTemplateOptions options = new CloudStackTemplateOptions();
            return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(options.userMetadata(key, value));
        }
    }
}

