/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.gson.annotations.SerializedName;

public class Domain
implements Comparable<Domain> {
    private long id;
    @SerializedName(value="haschild")
    private boolean hasChild;
    private long level;
    private String name;
    @SerializedName(value="networkdomain")
    private String networkDomain;
    @SerializedName(value="parentdomainid")
    private long parentDomainId;
    @SerializedName(value="parentdomainname")
    private String parentDomainName;

    public static Builder builder() {
        return new Builder();
    }

    Domain() {
    }

    public Domain(long id, boolean hasChild, long level, String name, String networkDomain, long parentDomainId, String parentDomainName) {
        this.id = id;
        this.hasChild = hasChild;
        this.level = level;
        this.name = name;
        this.networkDomain = networkDomain;
        this.parentDomainId = parentDomainId;
        this.parentDomainName = parentDomainName;
    }

    public long getId() {
        return this.id;
    }

    public boolean hasChild() {
        return this.hasChild;
    }

    public long getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public String getNetworkDomain() {
        return this.networkDomain;
    }

    public long getParentDomainId() {
        return this.parentDomainId;
    }

    public String getParentDomainName() {
        return this.parentDomainName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Domain domain = (Domain)o;
        if (this.hasChild != domain.hasChild) {
            return false;
        }
        if (this.id != domain.id) {
            return false;
        }
        if (this.level != domain.level) {
            return false;
        }
        if (this.parentDomainId != domain.parentDomainId) {
            return false;
        }
        if (this.name != null ? !this.name.equals(domain.name) : domain.name != null) {
            return false;
        }
        if (this.networkDomain != null ? !this.networkDomain.equals(domain.networkDomain) : domain.networkDomain != null) {
            return false;
        }
        return !(this.parentDomainName != null ? !this.parentDomainName.equals(domain.parentDomainName) : domain.parentDomainName != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.hasChild ? 1 : 0);
        result = 31 * result + (int)(this.level ^ this.level >>> 32);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.networkDomain != null ? this.networkDomain.hashCode() : 0);
        result = 31 * result + (int)(this.parentDomainId ^ this.parentDomainId >>> 32);
        result = 31 * result + (this.parentDomainName != null ? this.parentDomainName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Domain{id=" + this.id + ", hasChild=" + this.hasChild + ", level=" + this.level + ", name='" + this.name + '\'' + ", networkDomain='" + this.networkDomain + '\'' + ", parentDomainId=" + this.parentDomainId + ", parentDomainName='" + this.parentDomainName + '\'' + '}';
    }

    @Override
    public int compareTo(Domain arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public static class Builder {
        private long id;
        private boolean hasChild;
        private long level;
        private String name;
        private String networkDomain;
        private long parentDomainId;
        private String parentDomainName;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder hasChild(boolean hasChild) {
            this.hasChild = hasChild;
            return this;
        }

        public Builder level(long level) {
            this.level = level;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder networkDomain(String networkDomain) {
            this.networkDomain = networkDomain;
            return this;
        }

        public Builder parentDomainId(long parentDomainId) {
            this.parentDomainId = parentDomainId;
            return this;
        }

        public Builder parentDomainName(String parentDomainName) {
            this.parentDomainName = parentDomainName;
            return this;
        }

        public Domain build() {
            return new Domain(this.id, this.hasChild, this.level, this.name, this.networkDomain, this.parentDomainId, this.parentDomainName);
        }
    }
}

