/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Set;

public class FirewallRule
implements Comparable<FirewallRule> {
    private long id;
    @SerializedName(value="cidrlist")
    private Set<String> CIDRs;
    @SerializedName(value="startport")
    private int startPort;
    @SerializedName(value="endport")
    private int endPort;
    @SerializedName(value="icmpcode")
    private String icmpCode;
    @SerializedName(value="icmptype")
    private String icmpType;
    @SerializedName(value="ipaddress")
    private String ipAddress;
    @SerializedName(value="ipaddressid")
    private long ipAddressId;
    private Protocol protocol;
    private State state;

    public static Builder builder() {
        return new Builder();
    }

    public FirewallRule(long id, Set<String> CIDRs, int startPort, int endPort, String icmpCode, String icmpType, String ipAddress, long ipAddressId, Protocol protocol, State state) {
        this.id = id;
        this.CIDRs = ImmutableSet.copyOf(CIDRs);
        this.startPort = startPort;
        this.endPort = endPort;
        this.icmpCode = icmpCode;
        this.icmpType = icmpType;
        this.ipAddress = ipAddress;
        this.ipAddressId = ipAddressId;
        this.protocol = protocol;
        this.state = state;
    }

    @Override
    public int compareTo(FirewallRule arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public long getId() {
        return this.id;
    }

    public Set<String> getCIDRs() {
        return this.CIDRs;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public String getIcmpCode() {
        return this.icmpCode;
    }

    public String getIcmpType() {
        return this.icmpType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public long getIpAddressId() {
        return this.ipAddressId;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public State getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FirewallRule that = (FirewallRule)o;
        if (this.endPort != that.endPort) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.startPort != that.startPort) {
            return false;
        }
        if (this.CIDRs != null ? !((Object)this.CIDRs).equals(that.CIDRs) : that.CIDRs != null) {
            return false;
        }
        if (this.icmpCode != null ? !this.icmpCode.equals(that.icmpCode) : that.icmpCode != null) {
            return false;
        }
        if (this.icmpType != null ? !this.icmpType.equals(that.icmpType) : that.icmpType != null) {
            return false;
        }
        if (this.ipAddress != null ? !this.ipAddress.equals(that.ipAddress) : that.ipAddress != null) {
            return false;
        }
        if (this.ipAddressId != that.ipAddressId) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals((Object)that.protocol) : that.protocol != null) {
            return false;
        }
        return !(this.state != null ? !this.state.equals((Object)that.state) : that.state != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.CIDRs != null ? ((Object)this.CIDRs).hashCode() : 0);
        result = 31 * result + this.startPort;
        result = 31 * result + this.endPort;
        result = 31 * result + (this.icmpCode != null ? this.icmpCode.hashCode() : 0);
        result = 31 * result + (this.icmpType != null ? this.icmpType.hashCode() : 0);
        result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
        result = 31 * result + (int)(this.ipAddressId ^ this.ipAddressId >>> 32);
        result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FirewallRule{id=" + this.id + ", CIDRs='" + this.CIDRs + '\'' + ", startPort=" + this.startPort + ", endPort=" + this.endPort + ", icmpCode='" + this.icmpCode + '\'' + ", icmpType='" + this.icmpType + '\'' + ", ipAddress='" + this.ipAddress + '\'' + ", ipAddressId='" + this.ipAddressId + '\'' + ", protocol='" + (Object)((Object)this.protocol) + '\'' + ", state='" + (Object)((Object)this.state) + '\'' + '}';
    }

    public static class Builder {
        private long id;
        private Set<String> CIDRs;
        private int startPort;
        private int endPort;
        private String icmpCode;
        private String icmpType;
        private String ipAddress;
        private long ipAddressId;
        private Protocol protocol;
        private State state;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder CIDRs(Set<String> CIDRs) {
            this.CIDRs = ImmutableSet.copyOf(CIDRs);
            return this;
        }

        public Builder startPort(int startPort) {
            this.startPort = startPort;
            return this;
        }

        public Builder endPort(int endPort) {
            this.endPort = endPort;
            return this;
        }

        public Builder icmpCode(String icmpCode) {
            this.icmpCode = icmpCode;
            return this;
        }

        public Builder icmpType(String icmpType) {
            this.icmpType = icmpType;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder ipAddressId(long ipAddressId) {
            this.ipAddressId = ipAddressId;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public FirewallRule build() {
            return new FirewallRule(this.id, this.CIDRs, this.startPort, this.endPort, this.icmpCode, this.icmpType, this.ipAddress, this.ipAddressId, this.protocol, this.state);
        }
    }

    public static enum State {
        STAGED,
        ADD,
        ACTIVE,
        DELETEING,
        UNKNOWN;


        public static State fromValue(String value) {
            try {
                return State.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    public static enum Protocol {
        TCP,
        UDP,
        ICMP,
        UNKNOWN;


        public static Protocol fromValue(String value) {
            try {
                return Protocol.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return this.name().toUpperCase();
        }
    }
}

