/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.AsyncJob;

public class Host
implements Comparable<Host> {
    private long id;
    @SerializedName(value="allocationstate")
    private AllocationState allocationState;
    @SerializedName(value="averageload")
    private int averageLoad;
    @SerializedName(value="capabilities")
    private String capabilities;
    @SerializedName(value="clusterid")
    private long clusterId;
    @SerializedName(value="clustername")
    private String clusterName;
    @SerializedName(value="clustertype")
    private ClusterType clusterType;
    @SerializedName(value="cpuallocated")
    private String cpuAllocated;
    @SerializedName(value="cpunumber")
    private int cpuNumber;
    @SerializedName(value="cpuspeed")
    private int cpuSpeed;
    @SerializedName(value="cpuused")
    private String cpuUsed;
    @SerializedName(value="cpuwithoverprovisioning")
    private float cpuWithOverProvisioning;
    private Date created;
    private Date disconnected;
    @SerializedName(value="disksizeallocated")
    private long diskSizeAllocated;
    @SerializedName(value="disksizetotal")
    private long diskSizeTotal;
    private String events;
    @SerializedName(value="hasenoughcapacity")
    private boolean hasEnoughCapacity;
    @SerializedName(value="hosttags")
    private String hostTags;
    private String hypervisor;
    @SerializedName(value="ipaddress")
    private String ipAddress;
    @SerializedName(value="islocalstorageactive")
    private boolean localStorageActive;
    @SerializedName(value="jobid")
    private long jobId;
    @SerializedName(value="jobstatus")
    private AsyncJob.Status jobStatus;
    @SerializedName(value="lastpinged")
    private Date lastPinged;
    @SerializedName(value="managementserverid")
    private long managementServerId;
    @SerializedName(value="memoryallocated")
    private long memoryAllocated;
    @SerializedName(value="memorytotal")
    private long memoryTotal;
    @SerializedName(value="memoryused")
    private long memoryUsed;
    private String name;
    @SerializedName(value="networkkbsread")
    private long networkKbsRead;
    @SerializedName(value="networkkbswrite")
    private long networkKbsWrite;
    @SerializedName(value="oscategoryid")
    private long osCategoryId;
    @SerializedName(value="oscategoryname")
    private long osCategoryName;
    @SerializedName(value="podid")
    private long podId;
    @SerializedName(value="podname")
    private String podName;
    private Date removed;
    private State state;
    private Type type;
    private String version;
    @SerializedName(value="zoneid")
    private long zoneId;
    @SerializedName(value="zonename")
    private String zoneName;

    public static Builder builder() {
        return new Builder();
    }

    Host() {
    }

    public Host(long id, AllocationState allocationState, int averageLoad, String capabilities, long clusterId, String clusterName, ClusterType clusterType, String cpuAllocated, int cpuNumber, int cpuSpeed, String cpuUsed, float cpuWithOverProvisioning, Date created, Date disconnected, long diskSizeAllocated, long diskSizeTotal, String events, boolean hasEnoughCapacity, String hostTags, String hypervisor, String ipAddress, boolean localStorageActive, long jobId, AsyncJob.Status jobStatus, Date lastPinged, long managementServerId, long memoryAllocated, long memoryTotal, long memoryUsed, String name, long networkKbsRead, long networkKbsWrite, long osCategoryId, long osCategoryName, long podId, String podName, Date removed, State state, Type type, String version, long zoneId, String zoneName) {
        this.id = id;
        this.allocationState = allocationState;
        this.averageLoad = averageLoad;
        this.capabilities = capabilities;
        this.clusterId = clusterId;
        this.clusterName = clusterName;
        this.clusterType = clusterType;
        this.cpuAllocated = cpuAllocated;
        this.cpuNumber = cpuNumber;
        this.cpuSpeed = cpuSpeed;
        this.cpuUsed = cpuUsed;
        this.cpuWithOverProvisioning = cpuWithOverProvisioning;
        this.created = created;
        this.disconnected = disconnected;
        this.diskSizeAllocated = diskSizeAllocated;
        this.diskSizeTotal = diskSizeTotal;
        this.events = events;
        this.hasEnoughCapacity = hasEnoughCapacity;
        this.hostTags = hostTags;
        this.hypervisor = hypervisor;
        this.ipAddress = ipAddress;
        this.localStorageActive = localStorageActive;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.lastPinged = lastPinged;
        this.managementServerId = managementServerId;
        this.memoryAllocated = memoryAllocated;
        this.memoryTotal = memoryTotal;
        this.memoryUsed = memoryUsed;
        this.name = name;
        this.networkKbsRead = networkKbsRead;
        this.networkKbsWrite = networkKbsWrite;
        this.osCategoryId = osCategoryId;
        this.osCategoryName = osCategoryName;
        this.podId = podId;
        this.podName = podName;
        this.removed = removed;
        this.state = state;
        this.type = type;
        this.version = version;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    public long getId() {
        return this.id;
    }

    public AllocationState getAllocationState() {
        return this.allocationState;
    }

    public int getAverageLoad() {
        return this.averageLoad;
    }

    public String getCapabilities() {
        return this.capabilities;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public ClusterType getClusterType() {
        return this.clusterType;
    }

    public String getCpuAllocated() {
        return this.cpuAllocated;
    }

    public int getCpuNumber() {
        return this.cpuNumber;
    }

    public int getCpuSpeed() {
        return this.cpuSpeed;
    }

    public String getCpuUsed() {
        return this.cpuUsed;
    }

    public float getCpuWithOverProvisioning() {
        return this.cpuWithOverProvisioning;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getDisconnected() {
        return this.disconnected;
    }

    public long getDiskSizeAllocated() {
        return this.diskSizeAllocated;
    }

    public long getDiskSizeTotal() {
        return this.diskSizeTotal;
    }

    public String getEvents() {
        return this.events;
    }

    public boolean isHasEnoughCapacity() {
        return this.hasEnoughCapacity;
    }

    public String getHostTags() {
        return this.hostTags;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean isLocalStorageActive() {
        return this.localStorageActive;
    }

    public long getJobId() {
        return this.jobId;
    }

    public AsyncJob.Status getJobStatus() {
        return this.jobStatus;
    }

    public Date getLastPinged() {
        return this.lastPinged;
    }

    public long getManagementServerId() {
        return this.managementServerId;
    }

    public long getMemoryAllocated() {
        return this.memoryAllocated;
    }

    public long getMemoryTotal() {
        return this.memoryTotal;
    }

    public long getMemoryUsed() {
        return this.memoryUsed;
    }

    public String getName() {
        return this.name;
    }

    public long getNetworkKbsRead() {
        return this.networkKbsRead;
    }

    public long getNetworkKbsWrite() {
        return this.networkKbsWrite;
    }

    public long getOsCategoryId() {
        return this.osCategoryId;
    }

    public long getOsCategoryName() {
        return this.osCategoryName;
    }

    public long getPodId() {
        return this.podId;
    }

    public String getPodName() {
        return this.podName;
    }

    public Date getRemoved() {
        return this.removed;
    }

    public State getState() {
        return this.state;
    }

    public Type getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Host host = (Host)o;
        if (this.averageLoad != host.averageLoad) {
            return false;
        }
        if (this.clusterId != host.clusterId) {
            return false;
        }
        if (this.cpuNumber != host.cpuNumber) {
            return false;
        }
        if (this.cpuSpeed != host.cpuSpeed) {
            return false;
        }
        if (Float.compare(host.cpuWithOverProvisioning, this.cpuWithOverProvisioning) != 0) {
            return false;
        }
        if (this.diskSizeAllocated != host.diskSizeAllocated) {
            return false;
        }
        if (this.diskSizeTotal != host.diskSizeTotal) {
            return false;
        }
        if (this.hasEnoughCapacity != host.hasEnoughCapacity) {
            return false;
        }
        if (this.id != host.id) {
            return false;
        }
        if (this.jobId != host.jobId) {
            return false;
        }
        if (this.localStorageActive != host.localStorageActive) {
            return false;
        }
        if (this.managementServerId != host.managementServerId) {
            return false;
        }
        if (this.memoryAllocated != host.memoryAllocated) {
            return false;
        }
        if (this.memoryTotal != host.memoryTotal) {
            return false;
        }
        if (this.memoryUsed != host.memoryUsed) {
            return false;
        }
        if (this.networkKbsRead != host.networkKbsRead) {
            return false;
        }
        if (this.networkKbsWrite != host.networkKbsWrite) {
            return false;
        }
        if (this.osCategoryId != host.osCategoryId) {
            return false;
        }
        if (this.osCategoryName != host.osCategoryName) {
            return false;
        }
        if (this.podId != host.podId) {
            return false;
        }
        if (this.zoneId != host.zoneId) {
            return false;
        }
        if (this.allocationState != host.allocationState) {
            return false;
        }
        if (this.capabilities != null ? !this.capabilities.equals(host.capabilities) : host.capabilities != null) {
            return false;
        }
        if (this.clusterName != null ? !this.clusterName.equals(host.clusterName) : host.clusterName != null) {
            return false;
        }
        if (this.clusterType != host.clusterType) {
            return false;
        }
        if (this.cpuAllocated != null ? !this.cpuAllocated.equals(host.cpuAllocated) : host.cpuAllocated != null) {
            return false;
        }
        if (this.cpuUsed != null ? !this.cpuUsed.equals(host.cpuUsed) : host.cpuUsed != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(host.created) : host.created != null) {
            return false;
        }
        if (this.disconnected != null ? !this.disconnected.equals(host.disconnected) : host.disconnected != null) {
            return false;
        }
        if (this.events != null ? !this.events.equals(host.events) : host.events != null) {
            return false;
        }
        if (this.hostTags != null ? !this.hostTags.equals(host.hostTags) : host.hostTags != null) {
            return false;
        }
        if (this.hypervisor != null ? !this.hypervisor.equals(host.hypervisor) : host.hypervisor != null) {
            return false;
        }
        if (this.ipAddress != null ? !this.ipAddress.equals(host.ipAddress) : host.ipAddress != null) {
            return false;
        }
        if (this.jobStatus != host.jobStatus) {
            return false;
        }
        if (this.lastPinged != null ? !this.lastPinged.equals(host.lastPinged) : host.lastPinged != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(host.name) : host.name != null) {
            return false;
        }
        if (this.podName != null ? !this.podName.equals(host.podName) : host.podName != null) {
            return false;
        }
        if (this.removed != null ? !this.removed.equals(host.removed) : host.removed != null) {
            return false;
        }
        if (this.state != host.state) {
            return false;
        }
        if (this.type != host.type) {
            return false;
        }
        if (this.version != null ? !this.version.equals(host.version) : host.version != null) {
            return false;
        }
        return !(this.zoneName != null ? !this.zoneName.equals(host.zoneName) : host.zoneName != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.allocationState != null ? this.allocationState.hashCode() : 0);
        result = 31 * result + this.averageLoad;
        result = 31 * result + (this.capabilities != null ? this.capabilities.hashCode() : 0);
        result = 31 * result + (int)(this.clusterId ^ this.clusterId >>> 32);
        result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
        result = 31 * result + (this.clusterType != null ? this.clusterType.hashCode() : 0);
        result = 31 * result + (this.cpuAllocated != null ? this.cpuAllocated.hashCode() : 0);
        result = 31 * result + this.cpuNumber;
        result = 31 * result + this.cpuSpeed;
        result = 31 * result + (this.cpuUsed != null ? this.cpuUsed.hashCode() : 0);
        result = 31 * result + (this.cpuWithOverProvisioning != 0.0f ? Float.floatToIntBits(this.cpuWithOverProvisioning) : 0);
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.disconnected != null ? this.disconnected.hashCode() : 0);
        result = 31 * result + (int)(this.diskSizeAllocated ^ this.diskSizeAllocated >>> 32);
        result = 31 * result + (int)(this.diskSizeTotal ^ this.diskSizeTotal >>> 32);
        result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
        result = 31 * result + (this.hasEnoughCapacity ? 1 : 0);
        result = 31 * result + (this.hostTags != null ? this.hostTags.hashCode() : 0);
        result = 31 * result + (this.hypervisor != null ? this.hypervisor.hashCode() : 0);
        result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
        result = 31 * result + (this.localStorageActive ? 1 : 0);
        result = 31 * result + (int)(this.jobId ^ this.jobId >>> 32);
        result = 31 * result + (this.jobStatus != null ? this.jobStatus.hashCode() : 0);
        result = 31 * result + (this.lastPinged != null ? this.lastPinged.hashCode() : 0);
        result = 31 * result + (int)(this.managementServerId ^ this.managementServerId >>> 32);
        result = 31 * result + (int)(this.memoryAllocated ^ this.memoryAllocated >>> 32);
        result = 31 * result + (int)(this.memoryTotal ^ this.memoryTotal >>> 32);
        result = 31 * result + (int)(this.memoryUsed ^ this.memoryUsed >>> 32);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (int)(this.networkKbsRead ^ this.networkKbsRead >>> 32);
        result = 31 * result + (int)(this.networkKbsWrite ^ this.networkKbsWrite >>> 32);
        result = 31 * result + (int)(this.osCategoryId ^ this.osCategoryId >>> 32);
        result = 31 * result + (int)(this.osCategoryName ^ this.osCategoryName >>> 32);
        result = 31 * result + (int)(this.podId ^ this.podId >>> 32);
        result = 31 * result + (this.podName != null ? this.podName.hashCode() : 0);
        result = 31 * result + (this.removed != null ? this.removed.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        result = 31 * result + (this.zoneName != null ? this.zoneName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Host{id=" + this.id + ", allocationState=" + (Object)((Object)this.allocationState) + ", averageLoad=" + this.averageLoad + ", capabilities='" + this.capabilities + '\'' + ", clusterId=" + this.clusterId + ", clusterName='" + this.clusterName + '\'' + ", clusterType=" + (Object)((Object)this.clusterType) + ", cpuAllocated='" + this.cpuAllocated + '\'' + ", cpuNumber=" + this.cpuNumber + ", cpuSpeed=" + this.cpuSpeed + ", cpuUsed='" + this.cpuUsed + '\'' + ", cpuWithOverProvisioning=" + this.cpuWithOverProvisioning + ", created=" + this.created + ", disconnected=" + this.disconnected + ", diskSizeAllocated=" + this.diskSizeAllocated + ", diskSizeTotal=" + this.diskSizeTotal + ", events='" + this.events + '\'' + ", hasEnoughCapacity=" + this.hasEnoughCapacity + ", hostTags='" + this.hostTags + '\'' + ", hypervisor='" + this.hypervisor + '\'' + ", ipAddress='" + this.ipAddress + '\'' + ", localStorageActive=" + this.localStorageActive + ", jobId=" + this.jobId + ", jobStatus=" + (Object)((Object)this.jobStatus) + ", lastPinged=" + this.lastPinged + ", managementServerId=" + this.managementServerId + ", memoryAllocated=" + this.memoryAllocated + ", memoryTotal=" + this.memoryTotal + ", memoryUsed=" + this.memoryUsed + ", name='" + this.name + '\'' + ", networkKbsRead=" + this.networkKbsRead + ", networkKbsWrite=" + this.networkKbsWrite + ", osCategoryId=" + this.osCategoryId + ", osCategoryName=" + this.osCategoryName + ", podId=" + this.podId + ", podName='" + this.podName + '\'' + ", removed=" + this.removed + ", state=" + (Object)((Object)this.state) + ", type=" + (Object)((Object)this.type) + ", version='" + this.version + '\'' + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + '}';
    }

    @Override
    public int compareTo(Host other) {
        return Long.valueOf(this.getId()).compareTo(other.getId());
    }

    public static class Builder {
        private long id;
        private AllocationState allocationState;
        private int averageLoad;
        private String capabilities;
        private long clusterId;
        private String clusterName;
        private ClusterType clusterType;
        private String cpuAllocated;
        private int cpuNumber;
        private int cpuSpeed;
        private String cpuUsed;
        private float cpuWithOverProvisioning;
        private Date created;
        private Date disconnected;
        private long diskSizeAllocated;
        private long diskSizeTotal;
        private String events;
        private boolean hasEnoughCapacity;
        private String hostTags;
        private String hypervisor;
        private String ipAddress;
        private boolean localStorageActive;
        private long jobId;
        private AsyncJob.Status jobStatus;
        private Date lastPinged;
        private long managementServerId;
        private long memoryAllocated;
        private long memoryTotal;
        private long memoryUsed;
        private String name;
        private long networkKbsRead;
        private long networkKbsWrite;
        private long osCategoryId;
        private long osCategoryName;
        private long podId;
        private String podName;
        private Date removed;
        private State state;
        private Type type;
        private String version;
        private long zoneId;
        private String zoneName;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder allocationState(AllocationState allocationState) {
            this.allocationState = allocationState;
            return this;
        }

        public Builder averageLoad(int averageLoad) {
            this.averageLoad = averageLoad;
            return this;
        }

        public Builder capabilities(String capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder clusterId(long clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder clusterType(ClusterType clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public Builder cpuAllocated(String cpuAllocated) {
            this.cpuAllocated = cpuAllocated;
            return this;
        }

        public Builder cpuNumber(int cpuNumber) {
            this.cpuNumber = cpuNumber;
            return this;
        }

        public Builder cpuSpeed(int cpuSpeed) {
            this.cpuSpeed = cpuSpeed;
            return this;
        }

        public Builder cpuUsed(String cpuUsed) {
            this.cpuUsed = cpuUsed;
            return this;
        }

        public Builder cpuWithOverProvisioning(float cpuWithOverProvisioning) {
            this.cpuWithOverProvisioning = cpuWithOverProvisioning;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder disconnected(Date disconnected) {
            this.disconnected = disconnected;
            return this;
        }

        public Builder diskSizeAllocated(long diskSizeAllocated) {
            this.diskSizeAllocated = diskSizeAllocated;
            return this;
        }

        public Builder diskSizeTotal(long diskSizeTotal) {
            this.diskSizeTotal = diskSizeTotal;
            return this;
        }

        public Builder events(String events) {
            this.events = events;
            return this;
        }

        public Builder hasEnoughCapacity(boolean hasEnoughCapacity) {
            this.hasEnoughCapacity = hasEnoughCapacity;
            return this;
        }

        public Builder hostTags(String hostTags) {
            this.hostTags = hostTags;
            return this;
        }

        public Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder localStorageActive(boolean localStorageActive) {
            this.localStorageActive = localStorageActive;
            return this;
        }

        public Builder jobId(long jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(AsyncJob.Status jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder lastPinged(Date lastPinged) {
            this.lastPinged = lastPinged;
            return this;
        }

        public Builder managementServerId(long managementServerId) {
            this.managementServerId = managementServerId;
            return this;
        }

        public Builder memoryAllocated(long memoryAllocated) {
            this.memoryAllocated = memoryAllocated;
            return this;
        }

        public Builder memoryTotal(long memoryTotal) {
            this.memoryTotal = memoryTotal;
            return this;
        }

        public Builder memoryUsed(long memoryUsed) {
            this.memoryUsed = memoryUsed;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder networkKbsRead(long networkKbsRead) {
            this.networkKbsRead = networkKbsRead;
            return this;
        }

        public Builder networkKbsWrite(long networkKbsWrite) {
            this.networkKbsWrite = networkKbsWrite;
            return this;
        }

        public Builder osCategoryId(long osCategoryId) {
            this.osCategoryId = osCategoryId;
            return this;
        }

        public Builder osCategoryName(long osCategoryName) {
            this.osCategoryName = osCategoryName;
            return this;
        }

        public Builder podId(long podId) {
            this.podId = podId;
            return this;
        }

        public Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public Builder removed(Date removed) {
            this.removed = removed;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Host build() {
            return new Host(this.id, this.allocationState, this.averageLoad, this.capabilities, this.clusterId, this.clusterName, this.clusterType, this.cpuAllocated, this.cpuNumber, this.cpuSpeed, this.cpuUsed, this.cpuWithOverProvisioning, this.created, this.disconnected, this.diskSizeAllocated, this.diskSizeTotal, this.events, this.hasEnoughCapacity, this.hostTags, this.hypervisor, this.ipAddress, this.localStorageActive, this.jobId, this.jobStatus, this.lastPinged, this.managementServerId, this.memoryAllocated, this.memoryTotal, this.memoryUsed, this.name, this.networkKbsRead, this.networkKbsWrite, this.osCategoryId, this.osCategoryName, this.podId, this.podName, this.removed, this.state, this.type, this.version, this.zoneId, this.zoneName);
        }
    }

    public static enum Type {
        STORAGE,
        ROUTING,
        SECONDARY_STORAGE,
        SECONDARY_STORAGE_CMD_EXECUTOR,
        CONSOLE_PROXY,
        EXTERNAL_FIREWALL,
        EXTERNAL_LOAD_BALANCER,
        PXE_SERVER,
        TRAFFIC_MONITOR,
        EXTERNAL_DHCP,
        SECONDARY_STORAGE_VM,
        LOCAL_SECONDARY_STORAGE,
        UNKNOWN;


        public static Type fromValue(String value) {
            try {
                if (value.equals("SecondaryStorageVM")) {
                    return SECONDARY_STORAGE_VM;
                }
                return Type.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value));
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            if (this == SECONDARY_STORAGE_VM) {
                return "SecondaryStorageVM";
            }
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    public static enum State {
        CONNECTING,
        UP,
        DOWN,
        DISCONNECTED,
        UPDATING,
        PREPARE_FOR_MAINTENANCE,
        ERROR_IN_MAINTENANCE,
        MAINTENANCE,
        ALERT,
        REMOVED,
        REBALANCING,
        UNKNOWN;


        public static State fromValue(String value) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value));
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    public static enum ClusterType {
        CLOUD_MANAGED,
        EXTERNAL_MANAGED,
        UNKNOWN;


        public static ClusterType fromValue(String value) {
            try {
                return ClusterType.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value));
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }
}

