/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import javax.annotation.Nullable;

public class Template
implements Comparable<Template> {
    private long id;
    @SerializedName(value="displaytext")
    private String displayText;
    private String domain;
    @SerializedName(value="domainid")
    private long domainId;
    private String account;
    @SerializedName(value="accountid")
    private long accountId;
    @SerializedName(value="zonename")
    private String zone;
    @SerializedName(value="zoneid")
    private long zoneId;
    @SerializedName(value="ostypename")
    private String OSType;
    @SerializedName(value="ostypeid")
    private long OSTypeId;
    private String name;
    @SerializedName(value="templatetype")
    private Type type;
    private String status;
    private Format format;
    private String hypervisor;
    private Long size;
    private Date created;
    private Date removed;
    @SerializedName(value="crossZones")
    private boolean crossZones;
    @SerializedName(value="bootable")
    private boolean bootable;
    @SerializedName(value="isextractable")
    private boolean extractable;
    @SerializedName(value="isfeatured")
    private boolean featured;
    @SerializedName(value="ispublic")
    private boolean ispublic;
    @SerializedName(value="isready")
    private boolean ready;
    @SerializedName(value="passwordenabled")
    private boolean passwordEnabled;
    @Nullable
    @SerializedName(value="jobid")
    private Long jobId;
    @SerializedName(value="jobstatus")
    private String jobStatus;
    private String checksum;
    @SerializedName(value="hostId")
    private Long hostId;
    @SerializedName(value="hostname")
    private String hostName;
    @SerializedName(value="sourcetemplateid")
    @Nullable
    private Long sourceTemplateId;
    @SerializedName(value="templatetag")
    private String templateTag;

    public static Builder builder() {
        return new Builder();
    }

    public Template(long id, String displayText, String domain, long domainId, String account, long accountId, String zone, long zoneId, String oSType, long oSTypeId, String name, Type type, String status, Format format, String hypervisor, Long size, Date created, Date removed, boolean crossZones, boolean bootable, boolean extractable, boolean featured, boolean ispublic, boolean ready, boolean passwordEnabled, Long jobId, String jobStatus, String checksum, Long hostId, String hostName, Long sourceTemplateId, String templateTag) {
        this.id = id;
        this.displayText = displayText;
        this.domain = domain;
        this.domainId = domainId;
        this.account = account;
        this.accountId = accountId;
        this.zone = zone;
        this.zoneId = zoneId;
        this.OSType = oSType;
        this.OSTypeId = oSTypeId;
        this.name = name;
        this.type = type;
        this.status = status;
        this.format = format;
        this.hypervisor = hypervisor;
        this.size = size;
        this.created = created;
        this.removed = removed;
        this.crossZones = crossZones;
        this.bootable = bootable;
        this.extractable = extractable;
        this.featured = featured;
        this.ispublic = ispublic;
        this.ready = ready;
        this.passwordEnabled = passwordEnabled;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.checksum = checksum;
        this.hostId = hostId;
        this.hostName = hostName;
        this.sourceTemplateId = sourceTemplateId;
        this.templateTag = templateTag;
    }

    Template() {
    }

    public long getId() {
        return this.id;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getDomainId() {
        return this.domainId;
    }

    public String getAccount() {
        return this.account;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public String getZone() {
        return this.zone;
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public String getOSType() {
        return this.OSType;
    }

    public long getOSTypeId() {
        return this.OSTypeId;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public Format getFormat() {
        return this.format;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public Long getSize() {
        return this.size;
    }

    public Type getType() {
        return this.type;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getRemoved() {
        return this.removed;
    }

    public boolean isCrossZones() {
        return this.crossZones;
    }

    public boolean isBootable() {
        return this.bootable;
    }

    public boolean isExtractable() {
        return this.extractable;
    }

    public boolean isFeatured() {
        return this.featured;
    }

    public boolean isPublic() {
        return this.ispublic;
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isPasswordEnabled() {
        return this.passwordEnabled;
    }

    @Nullable
    public Long getJobId() {
        return this.jobId;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public Long getHostId() {
        return this.hostId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Long getSourceTemplateId() {
        return this.sourceTemplateId;
    }

    public String getTemplateTag() {
        return this.templateTag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.OSType == null ? 0 : this.OSType.hashCode());
        result = 31 * result + (int)(this.OSTypeId ^ this.OSTypeId >>> 32);
        result = 31 * result + (this.account == null ? 0 : this.account.hashCode());
        result = 31 * result + (int)(this.accountId ^ this.accountId >>> 32);
        result = 31 * result + (this.bootable ? 1231 : 1237);
        result = 31 * result + (this.created == null ? 0 : this.created.hashCode());
        result = 31 * result + (this.crossZones ? 1231 : 1237);
        result = 31 * result + (this.displayText == null ? 0 : this.displayText.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (int)(this.domainId ^ this.domainId >>> 32);
        result = 31 * result + (this.extractable ? 1231 : 1237);
        result = 31 * result + (this.featured ? 1231 : 1237);
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.hypervisor == null ? 0 : this.hypervisor.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.ispublic ? 1231 : 1237);
        result = 31 * result + (this.jobId == null ? 0 : this.jobId.hashCode());
        result = 31 * result + (this.jobStatus == null ? 0 : this.jobStatus.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.passwordEnabled ? 1231 : 1237);
        result = 31 * result + (this.ready ? 1231 : 1237);
        result = 31 * result + (this.removed == null ? 0 : this.removed.hashCode());
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.zone == null ? 0 : this.zone.hashCode());
        result = 31 * result + (int)(this.zoneId ^ this.zoneId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Template other = (Template)obj;
        if (this.OSType == null ? other.OSType != null : !this.OSType.equals(other.OSType)) {
            return false;
        }
        if (this.OSTypeId != other.OSTypeId) {
            return false;
        }
        if (this.account == null ? other.account != null : !this.account.equals(other.account)) {
            return false;
        }
        if (this.accountId != other.accountId) {
            return false;
        }
        if (this.bootable != other.bootable) {
            return false;
        }
        if (this.created == null ? other.created != null : !this.created.equals(other.created)) {
            return false;
        }
        if (this.crossZones != other.crossZones) {
            return false;
        }
        if (this.displayText == null ? other.displayText != null : !this.displayText.equals(other.displayText)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.domainId != other.domainId) {
            return false;
        }
        if (this.extractable != other.extractable) {
            return false;
        }
        if (this.featured != other.featured) {
            return false;
        }
        if (this.format != other.format) {
            return false;
        }
        if (this.hypervisor == null ? other.hypervisor != null : !this.hypervisor.equals(other.hypervisor)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.ispublic != other.ispublic) {
            return false;
        }
        if (this.jobId == null ? other.jobId != null : !this.jobId.equals(other.jobId)) {
            return false;
        }
        if (this.jobStatus == null ? other.jobStatus != null : !this.jobStatus.equals(other.jobStatus)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.passwordEnabled != other.passwordEnabled) {
            return false;
        }
        if (this.ready != other.ready) {
            return false;
        }
        if (this.removed == null ? other.removed != null : !this.removed.equals(other.removed)) {
            return false;
        }
        if (this.size == null ? other.size != null : !this.size.equals(other.size)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.zone == null ? other.zone != null : !this.zone.equals(other.zone)) {
            return false;
        }
        return this.zoneId == other.zoneId;
    }

    public String toString() {
        return "Template{id=" + this.id + ", displayText='" + this.displayText + '\'' + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", account='" + this.account + '\'' + ", accountId=" + this.accountId + ", zone='" + this.zone + '\'' + ", zoneId=" + this.zoneId + ", OSType='" + this.OSType + '\'' + ", OSTypeId=" + this.OSTypeId + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", status='" + this.status + '\'' + ", format=" + (Object)((Object)this.format) + ", hypervisor='" + this.hypervisor + '\'' + ", size=" + this.size + ", created=" + this.created + ", removed=" + this.removed + ", crossZones=" + this.crossZones + ", bootable=" + this.bootable + ", extractable=" + this.extractable + ", featured=" + this.featured + ", ispublic=" + this.ispublic + ", ready=" + this.ready + ", passwordEnabled=" + this.passwordEnabled + ", jobId=" + this.jobId + ", jobStatus='" + this.jobStatus + '\'' + ", checksum='" + this.checksum + '\'' + ", hostId=" + this.hostId + ", hostName='" + this.hostName + '\'' + ", sourceTemplateId=" + this.sourceTemplateId + ", templateTag='" + this.templateTag + '\'' + '}';
    }

    @Override
    public int compareTo(Template arg0) {
        return new Long(this.id).compareTo(arg0.getId());
    }

    public static enum Format {
        VHD,
        QCOW2,
        OVA,
        UNRECOGNIZED;


        public static Format fromValue(String format) {
            try {
                return Format.valueOf((String)Preconditions.checkNotNull((Object)format, (Object)"format"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static enum Type {
        USER,
        BUILTIN,
        UNRECOGNIZED;


        public static Type fromValue(String type) {
            try {
                return Type.valueOf((String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private long id;
        private String displayText;
        private String domain;
        private long domainId;
        private String account;
        private long accountId;
        private String zone;
        private long zoneId;
        private String OSType;
        private long OSTypeId;
        private String name;
        private Type type;
        private String status;
        private Format format;
        private String hypervisor;
        private Long size;
        private Date created;
        private Date removed;
        private boolean crossZones;
        private boolean bootable;
        private boolean extractable;
        private boolean featured;
        private boolean isPublic;
        private boolean ready;
        private boolean passwordEnabled;
        private Long jobId;
        private String jobStatus;
        private String checksum;
        private Long hostId;
        private String hostName;
        private Long sourceTemplateId;
        private String templateTag;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(long domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder accountId(long accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder zone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder zoneId(long zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder OSType(String OSType2) {
            this.OSType = OSType2;
            return this;
        }

        public Builder OSTypeId(long OSTypeId) {
            this.OSTypeId = OSTypeId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder format(Format format) {
            this.format = format;
            return this;
        }

        public Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder removed(Date removed) {
            this.removed = removed;
            return this;
        }

        public Builder crossZones(boolean crossZones) {
            this.crossZones = crossZones;
            return this;
        }

        public Builder bootable(boolean bootable) {
            this.bootable = bootable;
            return this;
        }

        public Builder extractable(boolean extractable) {
            this.extractable = extractable;
            return this;
        }

        public Builder featured(boolean featured) {
            this.featured = featured;
            return this;
        }

        public Builder isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public Builder ready(boolean ready) {
            this.ready = ready;
            return this;
        }

        public Builder passwordEnabled(boolean passwordEnabled) {
            this.passwordEnabled = passwordEnabled;
            return this;
        }

        public Builder jobId(Long jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder hostid(Long hostid) {
            this.hostId = hostid;
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder sourceTemplateId(Long sourceTemplateId) {
            this.sourceTemplateId = sourceTemplateId;
            return this;
        }

        public Builder templateTag(String templateTag) {
            this.templateTag = templateTag;
            return this;
        }

        public Template build() {
            return new Template(this.id, this.displayText, this.domain, this.domainId, this.account, this.accountId, this.zone, this.zoneId, this.OSType, this.OSTypeId, this.name, this.type, this.status, this.format, this.hypervisor, this.size, this.created, this.removed, this.crossZones, this.bootable, this.extractable, this.featured, this.isPublic, this.ready, this.passwordEnabled, this.jobId, this.jobStatus, this.checksum, this.hostId, this.hostName, this.sourceTemplateId, this.templateTag);
        }
    }
}

