/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.Network;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateNetworkOptions;
import org.jclouds.cloudstack.options.ListNetworksOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface NetworkAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"listNetworks"})
    @SelectJson(value="network")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<Network>> listNetworks(ListNetworksOptions ... var1);

    @GET
    @QueryParams(keys={"command"}, values={"listNetworks"})
    @SelectJson(value="network")
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Network> getNetwork(@QueryParam(value="id") long var1);

    @GET
    @QueryParams(keys={"command"}, values={"createNetwork"})
    @SelectJson(value="network")
    @Consumes(value={"application/json"})
    public ListenableFuture<Network> createNetworkInZone(@QueryParam(value="zoneid") long var1, @QueryParam(value="networkofferingid") long var3, @QueryParam(value="name") String var5, @QueryParam(value="displaytext") String var6, CreateNetworkOptions ... var7);

    @GET
    @QueryParams(keys={"command"}, values={"deleteNetwork"})
    @SelectJson(value="jobid")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Long> deleteNetwork(@QueryParam(value="id") long var1);
}

