/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.jclouds.cloudstack.domain.SshKeyPair;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.filters.ReEncodeQueryWithDefaultURLEncoder;
import org.jclouds.cloudstack.options.ListSSHKeyPairsOptions;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface SSHKeyPairAsyncClient {
    @GET
    @QueryParams(keys={"command"}, values={"listSSHKeyPairs"})
    @SelectJson(value="sshkeypair")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<SshKeyPair>> listSSHKeyPairs(ListSSHKeyPairsOptions ... var1);

    @GET
    @QueryParams(keys={"command"}, values={"registerSSHKeyPair"})
    @SelectJson(value="keypair")
    @Consumes(value={"application/json"})
    @RequestFilters(value={ReEncodeQueryWithDefaultURLEncoder.class})
    public ListenableFuture<SshKeyPair> registerSSHKeyPair(@QueryParam(value="name") String var1, @QueryParam(value="publickey") String var2);

    @GET
    @QueryParams(keys={"command"}, values={"createSSHKeyPair"})
    @SelectJson(value="keypair")
    @Consumes(value={"application/json"})
    public ListenableFuture<SshKeyPair> createSSHKeyPair(@QueryParam(value="name") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"listSSHKeyPairs"})
    @SelectJson(value="sshkeypair")
    @OnlyElement
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<SshKeyPair> getSSHKeyPair(@QueryParam(value="name") String var1);

    @GET
    @QueryParams(keys={"command"}, values={"deleteSSHKeyPair"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteSSHKeyPair(@QueryParam(value="name") String var1);
}

