/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.domain.PublicIPAddress;
import org.jclouds.cloudstack.options.CreateIPForwardingRuleOptions;
import org.jclouds.cloudstack.strategy.BlockUntilJobCompletesAndReturnResult;
import org.jclouds.logging.Logger;

@Singleton
public class CreatePortForwardingRulesForIP {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final CloudStackClient client;
    private final BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult;
    private final LoadingCache<Long, Set<IPForwardingRule>> getIPForwardingRulesByVirtualMachine;

    @Inject
    public CreatePortForwardingRulesForIP(CloudStackClient client, BlockUntilJobCompletesAndReturnResult blockUntilJobCompletesAndReturnResult, LoadingCache<Long, Set<IPForwardingRule>> getIPForwardingRulesByVirtualMachine) {
        this.client = (CloudStackClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.blockUntilJobCompletesAndReturnResult = (BlockUntilJobCompletesAndReturnResult)Preconditions.checkNotNull((Object)blockUntilJobCompletesAndReturnResult, (Object)"blockUntilJobCompletesAndReturnResult");
        this.getIPForwardingRulesByVirtualMachine = (LoadingCache)Preconditions.checkNotNull(getIPForwardingRulesByVirtualMachine, (Object)"getIPForwardingRulesByVirtualMachine");
    }

    public Set<IPForwardingRule> apply(PublicIPAddress ip, Iterable<Integer> ports) {
        return this.apply(ip, "tcp", ports);
    }

    public Set<IPForwardingRule> apply(PublicIPAddress ip, String protocol, Iterable<Integer> ports) {
        Preconditions.checkState((ip.getVirtualMachineId() != -1L ? 1 : 0) != 0, (String)"ip %s should be static NATed to a virtual machine before applying rules", (Object[])new Object[]{ip});
        if (Iterables.size(ports) == 0) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder responses = ImmutableSet.builder();
        for (int port : ports) {
            AsyncCreateResponse response = this.client.getNATClient().createIPForwardingRule(ip.getId(), protocol, port, new CreateIPForwardingRuleOptions[0]);
            this.logger.debug(">> creating IP forwarding rule IPAddress(%s) for protocol(%s), port(%s); response(%s)", new Object[]{ip.getId(), protocol, port, response});
            responses.add((Object)response);
        }
        ImmutableSet.Builder rules = ImmutableSet.builder();
        for (AsyncCreateResponse response : responses.build()) {
            IPForwardingRule rule = (IPForwardingRule)this.blockUntilJobCompletesAndReturnResult.apply(response);
            rules.add((Object)rule);
            this.getIPForwardingRulesByVirtualMachine.asMap().put(ip.getVirtualMachineId(), ImmutableSet.of((Object)rule));
        }
        return rules.build();
    }
}

