/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.User;

public class Account
extends ForwardingSet<User>
implements Comparable<Account> {
    private String id;
    @SerializedName(value="accounttype")
    private Type type;
    @SerializedName(value="networkdomain")
    private String networkDomain;
    private String domain;
    @SerializedName(value="domainId")
    private String domainId;
    @SerializedName(value="ipsavailable")
    private Long IPsAvailable;
    @SerializedName(value="iplimit")
    private Long IPLimit;
    @SerializedName(value="iptotal")
    private long IPs;
    @SerializedName(value="iscleanuprequired")
    private boolean cleanupRequired;
    private String name;
    @SerializedName(value="receivedbytes")
    private long receivedBytes;
    @SerializedName(value="sentbytes")
    private long sentBytes;
    @SerializedName(value="snapshotavailable")
    private Long snapshotsAvailable;
    @SerializedName(value="snapshotLimit")
    private Long snapshotLimit;
    @SerializedName(value="snapshottotal")
    private long snapshots;
    private State state;
    @SerializedName(value="templateavailable")
    private Long templatesAvailable;
    @SerializedName(value="templatelimit")
    private Long templateLimit;
    @SerializedName(value="templatetotal")
    private long templates;
    @SerializedName(value="vmavailable")
    private Long VMsAvailable;
    @SerializedName(value="vmlimit")
    private Long VMLimit;
    @SerializedName(value="vmrunning")
    private long VMsRunning;
    @SerializedName(value="vmstopped")
    private long VMsStopped;
    @SerializedName(value="vmtotal")
    private long VMs;
    @SerializedName(value="volumeavailable")
    private Long volumesAvailable;
    @SerializedName(value="volumelimit")
    private Long volumeLimit;
    @SerializedName(value="volumetotal")
    private long volumes;
    private Set<User> users;

    public static Builder builder() {
        return new Builder();
    }

    public Account(String id, Type type, String networkDomain, String domain, String domainId, Long IPsAvailable, Long IPLimit, long iPs, boolean cleanupRequired, String name, long receivedBytes, long sentBytes, Long snapshotsAvailable, Long snapshotLimit, long snapshots, State state, Long templatesAvailable, Long templateLimit, long templates, Long VMsAvailable, Long VMLimit, long vMsRunning, long vMsStopped, long vMs, Long volumesAvailable, Long volumeLimit, long volumes, Set<User> users) {
        this.id = id;
        this.type = type;
        this.networkDomain = networkDomain;
        this.domain = domain;
        this.domainId = domainId;
        this.IPsAvailable = IPsAvailable;
        this.IPLimit = IPLimit;
        this.IPs = iPs;
        this.cleanupRequired = cleanupRequired;
        this.name = name;
        this.receivedBytes = receivedBytes;
        this.sentBytes = sentBytes;
        this.snapshotsAvailable = snapshotsAvailable;
        this.snapshotLimit = snapshotLimit;
        this.snapshots = snapshots;
        this.state = state;
        this.templatesAvailable = templatesAvailable;
        this.templateLimit = templateLimit;
        this.templates = templates;
        this.VMsAvailable = VMsAvailable;
        this.VMLimit = VMLimit;
        this.VMsRunning = vMsRunning;
        this.VMsStopped = vMsStopped;
        this.VMs = vMs;
        this.volumesAvailable = volumesAvailable;
        this.volumeLimit = volumeLimit;
        this.volumes = volumes;
        this.users = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(users, (Object)"users")));
    }

    Account() {
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getNetworkDomain() {
        return this.networkDomain;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public boolean isCleanupRequired() {
        return this.cleanupRequired;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    @Nullable
    public Long getIPsAvailable() {
        return this.IPsAvailable;
    }

    @Nullable
    public Long getIPLimit() {
        return this.IPLimit;
    }

    public long getIPs() {
        return this.IPs;
    }

    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    public long getSentBytes() {
        return this.sentBytes;
    }

    @Nullable
    public Long getSnapshotsAvailable() {
        return this.snapshotsAvailable;
    }

    @Nullable
    public Long getSnapshotLimit() {
        return this.snapshotLimit;
    }

    public long getSnapshots() {
        return this.snapshots;
    }

    public State getState() {
        return this.state;
    }

    @Nullable
    public Long getTemplatesAvailable() {
        return this.templatesAvailable;
    }

    @Nullable
    public Long getTemplateLimit() {
        return this.templateLimit;
    }

    public long getTemplates() {
        return this.templates;
    }

    @Nullable
    public Long getVMsAvailable() {
        return this.VMsAvailable;
    }

    @Nullable
    public Long getVMLimit() {
        return this.VMLimit;
    }

    public long getVMsRunning() {
        return this.VMsRunning;
    }

    public long getVMsStopped() {
        return this.VMsStopped;
    }

    public long getVMs() {
        return this.VMs;
    }

    @Nullable
    public Long getVolumesAvailable() {
        return this.volumesAvailable;
    }

    @Nullable
    public Long getVolumeLimit() {
        return this.volumeLimit;
    }

    public long getVolumes() {
        return this.volumes;
    }

    @Override
    public int compareTo(Account arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public String toString() {
        return "Account{id=" + this.id + ", type=" + (Object)((Object)this.type) + ", networkDomain='" + this.networkDomain + '\'' + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", IPsAvailable=" + this.IPsAvailable + ", IPLimit=" + this.IPLimit + ", IPs=" + this.IPs + ", cleanupRequired=" + this.cleanupRequired + ", name='" + this.name + '\'' + ", receivedBytes=" + this.receivedBytes + ", sentBytes=" + this.sentBytes + ", snapshotsAvailable=" + this.snapshotsAvailable + ", snapshotLimit=" + this.snapshotLimit + ", snapshots=" + this.snapshots + ", state=" + (Object)((Object)this.state) + ", templatesAvailable=" + this.templatesAvailable + ", templateLimit=" + this.templateLimit + ", templates=" + this.templates + ", VMsAvailable=" + this.VMsAvailable + ", VMLimit=" + this.VMLimit + ", VMsRunning=" + this.VMsRunning + ", VMsStopped=" + this.VMsStopped + ", VMs=" + this.VMs + ", volumesAvailable=" + this.volumesAvailable + ", volumeLimit=" + this.volumeLimit + ", volumes=" + this.volumes + ", users=" + this.users + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.domainId, this.id, this.name});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Account that = (Account)obj;
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        return Objects.equal((Object)this.name, (Object)that.name);
    }

    protected Set<User> delegate() {
        return this.users;
    }

    public static enum Type {
        USER(0),
        ADMIN(1),
        DOMAIN_ADMIN(2),
        UNRECOGNIZED(Integer.MAX_VALUE);

        private int code;
        private static final Map<Integer, Type> INDEX;

        private Type(int code) {
            this.code = code;
        }

        public String toString() {
            return "" + this.code;
        }

        public static Type fromValue(String type) {
            Integer code = new Integer((String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            return INDEX.containsKey(code) ? INDEX.get(code) : UNRECOGNIZED;
        }

        static {
            INDEX = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])Type.values()), (Function)new Function<Type, Integer>(){

                public Integer apply(Type input) {
                    return input.code;
                }
            });
        }
    }

    public static enum State {
        ENABLED,
        DISABLED,
        LOCKED,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private String id;
        private Type type;
        private String networkDomain;
        private String domain;
        private String domainId;
        private Long IPsAvailable;
        private Long IPLimit;
        private long IPs;
        private boolean cleanupRequired;
        private String name;
        private long receivedBytes;
        private long sentBytes;
        private Long snapshotsAvailable;
        private Long snapshotLimit;
        private long snapshots;
        private State state;
        private Long templatesAvailable;
        private Long templateLimit;
        private long templates;
        private Long VMsAvailable;
        private Long VMLimit;
        private long VMsRunning;
        private long VMsStopped;
        private long VMs;
        private Long volumesAvailable;
        private Long volumeLimit;
        private long volumes;
        private Set<User> users = ImmutableSet.of();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder networkDomain(String networkDomain) {
            this.networkDomain = networkDomain;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder IPsAvailable(Long IPsAvailable) {
            this.IPsAvailable = IPsAvailable;
            return this;
        }

        public Builder IPLimit(Long IPLimit) {
            this.IPLimit = IPLimit;
            return this;
        }

        public Builder IPs(long IPs) {
            this.IPs = IPs;
            return this;
        }

        public Builder cleanupRequired(boolean cleanupRequired) {
            this.cleanupRequired = cleanupRequired;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder receivedBytes(long receivedBytes) {
            this.receivedBytes = receivedBytes;
            return this;
        }

        public Builder sentBytes(long sentBytes) {
            this.sentBytes = sentBytes;
            return this;
        }

        public Builder snapshotsAvailable(Long snapshotsAvailable) {
            this.snapshotsAvailable = snapshotsAvailable;
            return this;
        }

        public Builder snapshotLimit(Long snapshotLimit) {
            this.snapshotLimit = snapshotLimit;
            return this;
        }

        public Builder snapshots(long snapshots) {
            this.snapshots = snapshots;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder templatesAvailable(Long templatesAvailable) {
            this.templatesAvailable = templatesAvailable;
            return this;
        }

        public Builder templateLimit(Long templateLimit) {
            this.templateLimit = templateLimit;
            return this;
        }

        public Builder templates(long templates) {
            this.templates = templates;
            return this;
        }

        public Builder VMsAvailable(Long VMsAvailable) {
            this.VMsAvailable = VMsAvailable;
            return this;
        }

        public Builder VMLimit(Long VMLimit) {
            this.VMLimit = VMLimit;
            return this;
        }

        public Builder VMsRunning(long VMsRunning) {
            this.VMsRunning = VMsRunning;
            return this;
        }

        public Builder VMsStopped(long VMsStopped) {
            this.VMsStopped = VMsStopped;
            return this;
        }

        public Builder VMs(long VMs) {
            this.VMs = VMs;
            return this;
        }

        public Builder volumesAvailable(Long volumesAvailable) {
            this.volumesAvailable = volumesAvailable;
            return this;
        }

        public Builder volumeLimit(Long volumeLimit) {
            this.volumeLimit = volumeLimit;
            return this;
        }

        public Builder volumes(long volumes) {
            this.volumes = volumes;
            return this;
        }

        public Builder users(Set<User> users) {
            this.users = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(users, (Object)"users")));
            return this;
        }

        public Account build() {
            return new Account(this.id, this.type, this.networkDomain, this.domain, this.domainId, this.IPsAvailable, this.IPLimit, this.IPs, this.cleanupRequired, this.name, this.receivedBytes, this.sentBytes, this.snapshotsAvailable, this.snapshotLimit, this.snapshots, this.state, this.templatesAvailable, this.templateLimit, this.templates, this.VMsAvailable, this.VMLimit, this.VMsRunning, this.VMsStopped, this.VMs, this.volumesAvailable, this.volumeLimit, this.volumes, this.users);
        }
    }
}

