/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;

public class ApiKeyPair
implements Comparable<ApiKeyPair> {
    @SerializedName(value="apikey")
    private String apiKey;
    @SerializedName(value="secretkey")
    private String secretKey;

    public static Builder builder() {
        return new Builder();
    }

    ApiKeyPair() {
    }

    public ApiKeyPair(String apiKey, String secretKey) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiKeyPair that = (ApiKeyPair)o;
        if (!Objects.equal((Object)this.apiKey, (Object)that.apiKey)) {
            return false;
        }
        return Objects.equal((Object)this.secretKey, (Object)that.secretKey);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.apiKey, this.secretKey});
    }

    public String toString() {
        return "ApiKeyPair{apiKey='" + this.apiKey + '\'' + ", secretKey='" + this.secretKey + '\'' + '}';
    }

    @Override
    public int compareTo(ApiKeyPair arg0) {
        return this.apiKey.compareTo(arg0.getApiKey());
    }

    public static class Builder {
        private String apiKey;
        private String secretKey;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public ApiKeyPair build() {
            return new ApiKeyPair(this.apiKey, this.secretKey);
        }
    }
}

