/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jclouds.cloudstack.domain.AsyncJobError;

public class AsyncJob<T> {
    @SerializedName(value="accountid")
    private String accountId;
    private String cmd;
    private Date created;
    @SerializedName(value="jobid")
    private String id;
    @SerializedName(value="jobinstanceid")
    private String instanceId;
    @SerializedName(value="jobinstancetype")
    private String instanceType;
    @SerializedName(value="jobprocstatus")
    private int progress;
    @SerializedName(value="jobresult")
    private T result;
    @SerializedName(value="jobresultcode")
    private ResultCode resultCode = ResultCode.UNKNOWN;
    @SerializedName(value="jobresulttype")
    private String resultType;
    @SerializedName(value="jobstatus")
    private Status status = Status.UNKNOWN;
    @SerializedName(value="userid")
    private String userId;
    private AsyncJobError error;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public AsyncJob(String accountId, String cmd, Date created, String id, String instanceId, String instanceType, int progress, T result, ResultCode resultCode, String resultType, Status status, String userId, AsyncJobError error) {
        this.accountId = accountId;
        this.cmd = cmd;
        this.created = created;
        this.id = id;
        this.instanceId = instanceId;
        this.instanceType = instanceType;
        this.progress = progress;
        this.result = result;
        this.resultCode = resultCode;
        this.resultType = resultType;
        this.status = status;
        this.userId = userId;
        this.error = error;
    }

    AsyncJob() {
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getCmd() {
        return this.cmd;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getId() {
        return this.id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public int getProgress() {
        return this.progress;
    }

    public T getResult() {
        return this.result;
    }

    public ResultCode getResultCode() {
        return this.resultCode;
    }

    public String getResultType() {
        return this.resultType;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getUserId() {
        return this.userId;
    }

    public AsyncJobError getError() {
        return this.error;
    }

    public boolean hasFailed() {
        return this.getError() != null || this.getResultCode() == ResultCode.FAIL || this.getStatus() == Status.FAILED;
    }

    public boolean hasSucceed() {
        return this.getError() == null && this.getResultCode() == ResultCode.SUCCESS && this.getStatus() == Status.SUCCEEDED;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.accountId, this.cmd, this.created, this.id, this.instanceId, this.instanceType, this.error, this.progress, this.result, this.resultCode, this.resultType, this.status, this.userId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsyncJob that = (AsyncJob)obj;
        if (!Objects.equal((Object)this.accountId, (Object)that.accountId)) {
            return false;
        }
        if (!Objects.equal((Object)this.cmd, (Object)that.cmd)) {
            return false;
        }
        if (!Objects.equal((Object)this.created, (Object)that.created)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.instanceId, (Object)that.instanceId)) {
            return false;
        }
        if (!Objects.equal((Object)this.instanceType, (Object)that.instanceType)) {
            return false;
        }
        if (!Objects.equal((Object)this.error, (Object)that.error)) {
            return false;
        }
        if (!Objects.equal((Object)this.progress, (Object)that.progress)) {
            return false;
        }
        if (!Objects.equal(this.result, that.result)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.resultCode), (Object)((Object)that.resultCode))) {
            return false;
        }
        if (!Objects.equal((Object)this.resultType, (Object)that.resultType)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.status), (Object)((Object)that.status))) {
            return false;
        }
        return Objects.equal((Object)this.userId, (Object)that.userId);
    }

    public String toString() {
        return "AsyncJob{accountId=" + this.accountId + ", cmd='" + this.cmd + '\'' + ", created=" + this.created + ", id=" + this.id + ", instanceId=" + this.instanceId + ", instanceType='" + this.instanceType + '\'' + ", progress=" + this.progress + ", result=" + this.result + ", resultCode=" + (Object)((Object)this.resultCode) + ", resultType='" + this.resultType + '\'' + ", status=" + (Object)((Object)this.status) + ", userId=" + this.userId + ", error=" + this.error + '}';
    }

    public static class Builder<T> {
        private String accountId;
        private String cmd;
        private Date created;
        private String id;
        private String instanceId;
        private String instanceType;
        private int progress;
        private T result;
        private ResultCode resultCode = ResultCode.UNKNOWN;
        private String resultType;
        private AsyncJobError error;
        private Status status = Status.UNKNOWN;
        private String userId;

        public Builder<T> accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder<T> cmd(String cmd) {
            this.cmd = cmd;
            return this;
        }

        public Builder<T> created(Date created) {
            this.created = created;
            return this;
        }

        public Builder<T> id(String id) {
            this.id = id;
            return this;
        }

        public Builder<T> instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder<T> error(AsyncJobError error) {
            this.error = error;
            return this;
        }

        public Builder<T> instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder<T> progress(int progress) {
            this.progress = progress;
            return this;
        }

        public Builder<T> result(T result) {
            this.result = result;
            return this;
        }

        public Builder<T> resultCode(ResultCode resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        public Builder<T> resultType(String resultType) {
            this.resultType = resultType;
            return this;
        }

        public Builder<T> status(Status status) {
            this.status = status;
            return this;
        }

        public Builder<T> userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AsyncJob<T> build() {
            return new AsyncJob<T>(this.accountId, this.cmd, this.created, this.id, this.instanceId, this.instanceType, this.progress, this.result, this.resultCode, this.resultType, this.status, this.userId, this.error);
        }

        public static <T> Builder<T> fromAsyncJobUntyped(AsyncJob<T> in) {
            return new Builder<T>().accountId(((AsyncJob)in).accountId).cmd(((AsyncJob)in).cmd).created(((AsyncJob)in).created).id(((AsyncJob)in).id).instanceId(((AsyncJob)in).instanceId).instanceType(((AsyncJob)in).instanceType).progress(((AsyncJob)in).progress).result(((AsyncJob)in).result).resultCode(((AsyncJob)in).resultCode).resultType(((AsyncJob)in).resultType).status(((AsyncJob)in).status).userId(((AsyncJob)in).userId).error(((AsyncJob)in).error);
        }
    }

    public static enum Status {
        IN_PROGRESS(0),
        SUCCEEDED(1),
        FAILED(2),
        UNKNOWN(-1);

        private final int code;

        private Status(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static Status fromValue(String value) {
            try {
                int statusCode = Integer.parseInt(value);
                switch (statusCode) {
                    case 0: {
                        return IN_PROGRESS;
                    }
                    case 1: {
                        return SUCCEEDED;
                    }
                    case 2: {
                        return FAILED;
                    }
                }
                return UNKNOWN;
            }
            catch (NumberFormatException e) {
                return UNKNOWN;
            }
        }
    }

    public static enum ResultCode {
        SUCCESS(0),
        FAIL(530),
        UNKNOWN(-1);

        private final int code;

        private ResultCode(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static ResultCode fromValue(String value) {
            try {
                int resultCode = Integer.parseInt(value);
                switch (resultCode) {
                    case 0: {
                        return SUCCESS;
                    }
                    case 530: {
                        return FAIL;
                    }
                }
                return UNKNOWN;
            }
            catch (NumberFormatException e) {
                return UNKNOWN;
            }
        }
    }
}

