/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;

public class Capabilities {
    @SerializedName(value="cloudstackversion")
    private String cloudStackVersion;
    @SerializedName(value="securitygroupsenabled")
    private boolean securityGroupsEnabled;
    @SerializedName(value="userpublictemplateenabled")
    private boolean canShareTemplates;
    private boolean firewallRuleUiEnabled;
    private boolean supportELB;

    public static Builder builder() {
        return new Builder();
    }

    Capabilities() {
    }

    public Capabilities(String cloudStackVersion, boolean securityGroupsEnabled, boolean canShareTemplates, boolean firewallRuleUiEnabled, boolean supportELB) {
        this.cloudStackVersion = cloudStackVersion;
        this.securityGroupsEnabled = securityGroupsEnabled;
        this.canShareTemplates = canShareTemplates;
        this.firewallRuleUiEnabled = firewallRuleUiEnabled;
        this.supportELB = supportELB;
    }

    public String getCloudStackVersion() {
        return this.cloudStackVersion;
    }

    public boolean isSecurityGroupsEnabled() {
        return this.securityGroupsEnabled;
    }

    public boolean isSharedTemplatesEnabled() {
        return this.canShareTemplates;
    }

    public boolean isFirewallRuleUiEnabled() {
        return this.firewallRuleUiEnabled;
    }

    public boolean isSupportELB() {
        return this.supportELB;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.canShareTemplates, this.cloudStackVersion, this.securityGroupsEnabled, this.firewallRuleUiEnabled, this.supportELB});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Capabilities that = (Capabilities)obj;
        if (!Objects.equal((Object)this.canShareTemplates, (Object)that.canShareTemplates)) {
            return false;
        }
        if (!Objects.equal((Object)this.cloudStackVersion, (Object)that.cloudStackVersion)) {
            return false;
        }
        if (!Objects.equal((Object)this.securityGroupsEnabled, (Object)that.securityGroupsEnabled)) {
            return false;
        }
        if (!Objects.equal((Object)this.firewallRuleUiEnabled, (Object)that.firewallRuleUiEnabled)) {
            return false;
        }
        return Objects.equal((Object)this.supportELB, (Object)that.supportELB);
    }

    public String toString() {
        return "Capabilities{cloudStackVersion='" + this.cloudStackVersion + '\'' + ", securityGroupsEnabled=" + this.securityGroupsEnabled + ", canShareTemplates=" + this.canShareTemplates + ", firewallRuleUiEnabled=" + this.firewallRuleUiEnabled + ", supportELB=" + this.supportELB + '}';
    }

    public static class Builder {
        private String cloudStackVersion;
        private boolean securityGroupsEnabled;
        private boolean canShareTemplates;
        private boolean firewallRuleUiEnabled;
        private boolean supportELB;

        public Builder cloudStackVersion(String cloudStackVersion) {
            this.cloudStackVersion = cloudStackVersion;
            return this;
        }

        public Builder securityGroupsEnabled(boolean securityGroupsEnabled) {
            this.securityGroupsEnabled = securityGroupsEnabled;
            return this;
        }

        public Builder sharedTemplatesEnabled(boolean canShareTemplates) {
            this.canShareTemplates = canShareTemplates;
            return this;
        }

        public Builder firewallRuleUiEnabled(boolean firewallRuleUiEnabled) {
            this.firewallRuleUiEnabled = firewallRuleUiEnabled;
            return this;
        }

        public Builder supportELB(boolean supportELB) {
            this.supportELB = supportELB;
            return this;
        }

        public Capabilities build() {
            return new Capabilities(this.cloudStackVersion, this.securityGroupsEnabled, this.canShareTemplates, this.firewallRuleUiEnabled, this.supportELB);
        }
    }
}

