/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.Host;

public class Cluster
implements Comparable<Cluster> {
    private String id;
    @SerializedName(value="allocationstate")
    private AllocationState allocationState;
    @SerializedName(value="clustertype")
    private Host.ClusterType clusterType;
    @SerializedName(value="hypervisortype")
    private String hypervisor;
    @SerializedName(value="managedstate")
    private ManagedState managedState;
    private String name;
    @SerializedName(value="podid")
    private String podId;
    @SerializedName(value="podname")
    private String podName;
    @SerializedName(value="zoneid")
    private String zoneId;
    @SerializedName(value="zonename")
    private String zoneName;

    public static Builder builder() {
        return new Builder();
    }

    Cluster() {
    }

    public Cluster(String id, AllocationState allocationState, Host.ClusterType clusterType, String hypervisor, ManagedState managedState, String name, String podId, String podName, String zoneId, String zoneName) {
        this.id = id;
        this.allocationState = allocationState;
        this.clusterType = clusterType;
        this.hypervisor = hypervisor;
        this.managedState = managedState;
        this.name = name;
        this.podId = podId;
        this.podName = podName;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    public String getId() {
        return this.id;
    }

    public AllocationState getAllocationState() {
        return this.allocationState;
    }

    public Host.ClusterType getClusterType() {
        return this.clusterType;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public ManagedState getManagedState() {
        return this.managedState;
    }

    public String getName() {
        return this.name;
    }

    public String getPodId() {
        return this.podId;
    }

    public String getPodName() {
        return this.podName;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cluster that = (Cluster)o;
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.podId, (Object)that.podId)) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneId, (Object)that.zoneId)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.allocationState), (Object)((Object)that.allocationState))) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.clusterType), (Object)((Object)that.clusterType))) {
            return false;
        }
        if (!Objects.equal((Object)this.hypervisor, (Object)that.hypervisor)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.managedState), (Object)((Object)that.managedState))) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)this.podName, (Object)that.podName)) {
            return false;
        }
        return Objects.equal((Object)this.zoneName, (Object)that.zoneName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.allocationState, this.clusterType, this.hypervisor, this.managedState, this.name, this.podId, this.podName, this.zoneId, this.zoneName});
    }

    public String toString() {
        return "Cluster{id=" + this.id + ", allocationState=" + (Object)((Object)this.allocationState) + ", clusterType=" + (Object)((Object)this.clusterType) + ", hypervisor='" + this.hypervisor + '\'' + ", managedState=" + (Object)((Object)this.managedState) + ", name='" + this.name + '\'' + ", podId=" + this.podId + ", podName='" + this.podName + '\'' + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + '}';
    }

    @Override
    public int compareTo(Cluster other) {
        return this.id.compareTo(other.id);
    }

    public static class Builder {
        private String id;
        private AllocationState allocationState;
        private Host.ClusterType clusterType;
        private String hypervisor;
        private ManagedState managedState;
        private String name;
        private String podId;
        private String podName;
        private String zoneId;
        private String zoneName;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder allocationState(AllocationState allocationState) {
            this.allocationState = allocationState;
            return this;
        }

        public Builder clusterType(Host.ClusterType clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public Builder managedState(ManagedState managedState) {
            this.managedState = managedState;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder podId(String podId) {
            this.podId = podId;
            return this;
        }

        public Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Cluster build() {
            return new Cluster(this.id, this.allocationState, this.clusterType, this.hypervisor, this.managedState, this.name, this.podId, this.podName, this.zoneId, this.zoneName);
        }
    }

    public static enum ManagedState {
        MANAGED,
        PREPARE_UNMANAGED,
        UNMANAGED,
        PREPARE_UNMANAGED_ERROR,
        UNRECOGNIZED;


        public static ManagedState fromValue(String value) {
            try {
                return ManagedState.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }
}

