/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

public class DiskOffering
implements Comparable<DiskOffering> {
    private String id;
    private String name;
    @SerializedName(value="displaytext")
    private String displayText;
    private Date created;
    private String domain;
    @SerializedName(value="domainid")
    private String domainId;
    @SerializedName(value="disksize")
    private int diskSize;
    @SerializedName(value="iscustomized")
    private boolean customized;
    private String tags;

    public static Builder builder() {
        return new Builder();
    }

    public DiskOffering(String id, String name, String displayText, Date created, String domain, String domainId, int diskSize, boolean customized, Set<String> tags) {
        this.id = id;
        this.name = name;
        this.displayText = displayText;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.diskSize = diskSize;
        this.customized = customized;
        this.tags = tags.size() == 0 ? null : Joiner.on((char)',').join(tags);
    }

    DiskOffering() {
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public int getDiskSize() {
        return this.diskSize;
    }

    public boolean isCustomized() {
        return this.customized;
    }

    public Set<String> getTags() {
        return this.tags != null ? ImmutableSet.copyOf((Iterable)Splitter.on((char)',').split((CharSequence)this.tags)) : ImmutableSet.of();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.created, this.customized, this.diskSize, this.displayText, this.domain, this.domainId, this.id, this.name, this.tags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiskOffering that = (DiskOffering)obj;
        if (!Objects.equal((Object)this.created, (Object)that.created)) {
            return false;
        }
        if (!Objects.equal((Object)this.customized, (Object)that.customized)) {
            return false;
        }
        if (!Objects.equal((Object)this.diskSize, (Object)that.diskSize)) {
            return false;
        }
        if (!Objects.equal((Object)this.displayText, (Object)that.displayText)) {
            return false;
        }
        if (!Objects.equal((Object)this.domain, (Object)that.domain)) {
            return false;
        }
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        return Objects.equal((Object)this.tags, (Object)that.tags);
    }

    public String toString() {
        return "DiskOffering{id=" + this.id + ", name='" + this.name + '\'' + ", displayText='" + this.displayText + '\'' + ", created=" + this.created + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", diskSize=" + this.diskSize + ", customized=" + this.customized + ", tags='" + this.tags + '\'' + '}';
    }

    @Override
    public int compareTo(DiskOffering arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public static class Builder {
        private String id;
        private String name;
        private String displayText;
        private Date created;
        private String domain;
        private String domainId;
        private int diskSize;
        private boolean customized;
        private Set<String> tags = ImmutableSet.of();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder diskSize(int diskSize) {
            this.diskSize = diskSize;
            return this;
        }

        public Builder customized(boolean customized) {
            this.customized = customized;
            return this;
        }

        public Builder tags(Set<String> tags) {
            this.tags = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(tags, (Object)"tags")));
            return this;
        }

        public DiskOffering build() {
            return new DiskOffering(this.id, this.name, this.displayText, this.created, this.domain, this.domainId, this.diskSize, this.customized, this.tags);
        }
    }
}

