/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.cloudstack.domain.AsyncJob;

public class Host
implements Comparable<Host> {
    private String id;
    @SerializedName(value="allocationstate")
    private AllocationState allocationState;
    @SerializedName(value="averageload")
    private int averageLoad;
    @SerializedName(value="capabilities")
    private String capabilities;
    @SerializedName(value="clusterid")
    private String clusterId;
    @SerializedName(value="clustername")
    private String clusterName;
    @SerializedName(value="clustertype")
    private ClusterType clusterType;
    @SerializedName(value="cpuallocated")
    private String cpuAllocated;
    @SerializedName(value="cpunumber")
    private int cpuNumber;
    @SerializedName(value="cpuspeed")
    private int cpuSpeed;
    @SerializedName(value="cpuused")
    private String cpuUsed;
    @SerializedName(value="cpuwithoverprovisioning")
    private float cpuWithOverProvisioning;
    private Date created;
    private Date disconnected;
    @SerializedName(value="disksizeallocated")
    private long diskSizeAllocated;
    @SerializedName(value="disksizetotal")
    private long diskSizeTotal;
    private String events;
    @SerializedName(value="hasenoughcapacity")
    private boolean hasEnoughCapacity;
    @SerializedName(value="hosttags")
    private String hostTags;
    private String hypervisor;
    @SerializedName(value="ipaddress")
    private String ipAddress;
    @SerializedName(value="islocalstorageactive")
    private boolean localStorageActive;
    @SerializedName(value="jobid")
    private String jobId;
    @SerializedName(value="jobstatus")
    private AsyncJob.Status jobStatus;
    @SerializedName(value="lastpinged")
    private Date lastPinged;
    @SerializedName(value="managementserverid")
    private String managementServerId;
    @SerializedName(value="memoryallocated")
    private long memoryAllocated;
    @SerializedName(value="memorytotal")
    private long memoryTotal;
    @SerializedName(value="memoryused")
    private long memoryUsed;
    private String name;
    @SerializedName(value="networkkbsread")
    private long networkKbsRead;
    @SerializedName(value="networkkbswrite")
    private long networkKbsWrite;
    @SerializedName(value="oscategoryid")
    private String osCategoryId;
    @SerializedName(value="oscategoryname")
    private String osCategoryName;
    @SerializedName(value="podid")
    private String podId;
    @SerializedName(value="podname")
    private String podName;
    private Date removed;
    private State state;
    private Type type;
    private String version;
    @SerializedName(value="zoneid")
    private String zoneId;
    @SerializedName(value="zonename")
    private String zoneName;

    public static Builder builder() {
        return new Builder();
    }

    Host() {
    }

    public Host(String id, AllocationState allocationState, int averageLoad, String capabilities, String clusterId, String clusterName, ClusterType clusterType, String cpuAllocated, int cpuNumber, int cpuSpeed, String cpuUsed, float cpuWithOverProvisioning, Date created, Date disconnected, long diskSizeAllocated, long diskSizeTotal, String events, boolean hasEnoughCapacity, String hostTags, String hypervisor, String ipAddress, boolean localStorageActive, String jobId, AsyncJob.Status jobStatus, Date lastPinged, String managementServerId, long memoryAllocated, long memoryTotal, long memoryUsed, String name, long networkKbsRead, long networkKbsWrite, String osCategoryId, String osCategoryName, String podId, String podName, Date removed, State state, Type type, String version, String zoneId, String zoneName) {
        this.id = id;
        this.allocationState = allocationState;
        this.averageLoad = averageLoad;
        this.capabilities = capabilities;
        this.clusterId = clusterId;
        this.clusterName = clusterName;
        this.clusterType = clusterType;
        this.cpuAllocated = cpuAllocated;
        this.cpuNumber = cpuNumber;
        this.cpuSpeed = cpuSpeed;
        this.cpuUsed = cpuUsed;
        this.cpuWithOverProvisioning = cpuWithOverProvisioning;
        this.created = created;
        this.disconnected = disconnected;
        this.diskSizeAllocated = diskSizeAllocated;
        this.diskSizeTotal = diskSizeTotal;
        this.events = events;
        this.hasEnoughCapacity = hasEnoughCapacity;
        this.hostTags = hostTags;
        this.hypervisor = hypervisor;
        this.ipAddress = ipAddress;
        this.localStorageActive = localStorageActive;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.lastPinged = lastPinged;
        this.managementServerId = managementServerId;
        this.memoryAllocated = memoryAllocated;
        this.memoryTotal = memoryTotal;
        this.memoryUsed = memoryUsed;
        this.name = name;
        this.networkKbsRead = networkKbsRead;
        this.networkKbsWrite = networkKbsWrite;
        this.osCategoryId = osCategoryId;
        this.osCategoryName = osCategoryName;
        this.podId = podId;
        this.podName = podName;
        this.removed = removed;
        this.state = state;
        this.type = type;
        this.version = version;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    public String getId() {
        return this.id;
    }

    public AllocationState getAllocationState() {
        return this.allocationState;
    }

    public int getAverageLoad() {
        return this.averageLoad;
    }

    public String getCapabilities() {
        return this.capabilities;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public ClusterType getClusterType() {
        return this.clusterType;
    }

    public String getCpuAllocated() {
        return this.cpuAllocated;
    }

    public int getCpuNumber() {
        return this.cpuNumber;
    }

    public int getCpuSpeed() {
        return this.cpuSpeed;
    }

    public String getCpuUsed() {
        return this.cpuUsed;
    }

    public float getCpuWithOverProvisioning() {
        return this.cpuWithOverProvisioning;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getDisconnected() {
        return this.disconnected;
    }

    public long getDiskSizeAllocated() {
        return this.diskSizeAllocated;
    }

    public long getDiskSizeTotal() {
        return this.diskSizeTotal;
    }

    public String getEvents() {
        return this.events;
    }

    public boolean isHasEnoughCapacity() {
        return this.hasEnoughCapacity;
    }

    public String getHostTags() {
        return this.hostTags;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean isLocalStorageActive() {
        return this.localStorageActive;
    }

    public String getJobId() {
        return this.jobId;
    }

    public AsyncJob.Status getJobStatus() {
        return this.jobStatus;
    }

    public Date getLastPinged() {
        return this.lastPinged;
    }

    public String getManagementServerId() {
        return this.managementServerId;
    }

    public long getMemoryAllocated() {
        return this.memoryAllocated;
    }

    public long getMemoryTotal() {
        return this.memoryTotal;
    }

    public long getMemoryUsed() {
        return this.memoryUsed;
    }

    public String getName() {
        return this.name;
    }

    public long getNetworkKbsRead() {
        return this.networkKbsRead;
    }

    public long getNetworkKbsWrite() {
        return this.networkKbsWrite;
    }

    public String getOsCategoryId() {
        return this.osCategoryId;
    }

    public String getOsCategoryName() {
        return this.osCategoryName;
    }

    public String getPodId() {
        return this.podId;
    }

    public String getPodName() {
        return this.podName;
    }

    public Date getRemoved() {
        return this.removed;
    }

    public State getState() {
        return this.state;
    }

    public Type getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Host that = (Host)o;
        if (!Objects.equal((Object)this.averageLoad, (Object)that.averageLoad)) {
            return false;
        }
        if (!Objects.equal((Object)this.clusterId, (Object)that.clusterId)) {
            return false;
        }
        if (!Objects.equal((Object)this.cpuNumber, (Object)that.cpuNumber)) {
            return false;
        }
        if (!Objects.equal((Object)this.cpuSpeed, (Object)that.cpuSpeed)) {
            return false;
        }
        if (!Objects.equal((Object)Float.valueOf(this.cpuWithOverProvisioning), (Object)Float.valueOf(that.cpuWithOverProvisioning))) {
            return false;
        }
        if (!Objects.equal((Object)this.diskSizeAllocated, (Object)that.diskSizeAllocated)) {
            return false;
        }
        if (!Objects.equal((Object)this.diskSizeTotal, (Object)that.diskSizeTotal)) {
            return false;
        }
        if (!Objects.equal((Object)this.hasEnoughCapacity, (Object)that.hasEnoughCapacity)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.jobId, (Object)that.jobId)) {
            return false;
        }
        if (!Objects.equal((Object)this.localStorageActive, (Object)that.localStorageActive)) {
            return false;
        }
        if (!Objects.equal((Object)this.managementServerId, (Object)that.managementServerId)) {
            return false;
        }
        if (!Objects.equal((Object)this.memoryAllocated, (Object)that.memoryAllocated)) {
            return false;
        }
        if (!Objects.equal((Object)this.memoryTotal, (Object)that.memoryTotal)) {
            return false;
        }
        if (!Objects.equal((Object)this.memoryUsed, (Object)that.memoryUsed)) {
            return false;
        }
        if (!Objects.equal((Object)this.networkKbsRead, (Object)that.networkKbsRead)) {
            return false;
        }
        if (!Objects.equal((Object)this.networkKbsWrite, (Object)that.networkKbsWrite)) {
            return false;
        }
        if (!Objects.equal((Object)this.osCategoryId, (Object)that.osCategoryId)) {
            return false;
        }
        if (!Objects.equal((Object)this.osCategoryName, (Object)that.osCategoryName)) {
            return false;
        }
        if (!Objects.equal((Object)this.podId, (Object)that.podId)) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneId, (Object)that.zoneId)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.allocationState), (Object)((Object)that.allocationState))) {
            return false;
        }
        if (!Objects.equal((Object)this.capabilities, (Object)that.capabilities)) {
            return false;
        }
        if (!Objects.equal((Object)this.clusterName, (Object)that.clusterName)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.clusterType), (Object)((Object)that.clusterType))) {
            return false;
        }
        if (!Objects.equal((Object)this.cpuAllocated, (Object)that.cpuAllocated)) {
            return false;
        }
        if (!Objects.equal((Object)this.cpuUsed, (Object)that.cpuUsed)) {
            return false;
        }
        if (!Objects.equal((Object)this.created, (Object)that.created)) {
            return false;
        }
        if (!Objects.equal((Object)this.disconnected, (Object)that.disconnected)) {
            return false;
        }
        if (!Objects.equal((Object)this.events, (Object)that.events)) {
            return false;
        }
        if (!Objects.equal((Object)this.hostTags, (Object)that.hostTags)) {
            return false;
        }
        if (!Objects.equal((Object)this.hypervisor, (Object)that.hypervisor)) {
            return false;
        }
        if (!Objects.equal((Object)this.ipAddress, (Object)that.ipAddress)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.jobStatus), (Object)((Object)that.jobStatus))) {
            return false;
        }
        if (!Objects.equal((Object)this.lastPinged, (Object)that.lastPinged)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)this.podName, (Object)that.podName)) {
            return false;
        }
        if (!Objects.equal((Object)this.removed, (Object)that.removed)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.state), (Object)((Object)that.state))) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.type), (Object)((Object)that.type))) {
            return false;
        }
        if (!Objects.equal((Object)this.version, (Object)that.version)) {
            return false;
        }
        return Objects.equal((Object)this.zoneName, (Object)that.zoneName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.averageLoad, this.clusterId, this.cpuNumber, this.cpuSpeed, Float.valueOf(this.cpuWithOverProvisioning), this.diskSizeAllocated, this.diskSizeTotal, this.hasEnoughCapacity, this.id, this.jobId, this.localStorageActive, this.managementServerId, this.memoryAllocated, this.memoryTotal, this.memoryUsed, this.networkKbsRead, this.networkKbsWrite, this.osCategoryId, this.osCategoryName, this.podId, this.zoneId, this.allocationState, this.capabilities, this.clusterName, this.clusterType, this.cpuAllocated, this.cpuUsed, this.created, this.disconnected, this.events, this.hostTags, this.hypervisor, this.ipAddress, this.jobStatus, this.lastPinged, this.name, this.podName, this.removed, this.state, this.type, this.version, this.zoneName});
    }

    public String toString() {
        return "Host{id=" + this.id + ", allocationState=" + (Object)((Object)this.allocationState) + ", averageLoad=" + this.averageLoad + ", capabilities='" + this.capabilities + '\'' + ", clusterId=" + this.clusterId + ", clusterName='" + this.clusterName + '\'' + ", clusterType=" + (Object)((Object)this.clusterType) + ", cpuAllocated='" + this.cpuAllocated + '\'' + ", cpuNumber=" + this.cpuNumber + ", cpuSpeed=" + this.cpuSpeed + ", cpuUsed='" + this.cpuUsed + '\'' + ", cpuWithOverProvisioning=" + this.cpuWithOverProvisioning + ", created=" + this.created + ", disconnected=" + this.disconnected + ", diskSizeAllocated=" + this.diskSizeAllocated + ", diskSizeTotal=" + this.diskSizeTotal + ", events='" + this.events + '\'' + ", hasEnoughCapacity=" + this.hasEnoughCapacity + ", hostTags='" + this.hostTags + '\'' + ", hypervisor='" + this.hypervisor + '\'' + ", ipAddress='" + this.ipAddress + '\'' + ", localStorageActive=" + this.localStorageActive + ", jobId=" + this.jobId + ", jobStatus=" + (Object)((Object)this.jobStatus) + ", lastPinged=" + this.lastPinged + ", managementServerId=" + this.managementServerId + ", memoryAllocated=" + this.memoryAllocated + ", memoryTotal=" + this.memoryTotal + ", memoryUsed=" + this.memoryUsed + ", name='" + this.name + '\'' + ", networkKbsRead=" + this.networkKbsRead + ", networkKbsWrite=" + this.networkKbsWrite + ", osCategoryId=" + this.osCategoryId + ", osCategoryName=" + this.osCategoryName + ", podId=" + this.podId + ", podName='" + this.podName + '\'' + ", removed=" + this.removed + ", state=" + (Object)((Object)this.state) + ", type=" + (Object)((Object)this.type) + ", version='" + this.version + '\'' + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + '}';
    }

    @Override
    public int compareTo(Host other) {
        return this.getId().compareTo(other.getId());
    }

    public static class Builder {
        private String id;
        private AllocationState allocationState;
        private int averageLoad;
        private String capabilities;
        private String clusterId;
        private String clusterName;
        private ClusterType clusterType;
        private String cpuAllocated;
        private int cpuNumber;
        private int cpuSpeed;
        private String cpuUsed;
        private float cpuWithOverProvisioning;
        private Date created;
        private Date disconnected;
        private long diskSizeAllocated;
        private long diskSizeTotal;
        private String events;
        private boolean hasEnoughCapacity;
        private String hostTags;
        private String hypervisor;
        private String ipAddress;
        private boolean localStorageActive;
        private String jobId;
        private AsyncJob.Status jobStatus;
        private Date lastPinged;
        private String managementServerId;
        private long memoryAllocated;
        private long memoryTotal;
        private long memoryUsed;
        private String name;
        private long networkKbsRead;
        private long networkKbsWrite;
        private String osCategoryId;
        private String osCategoryName;
        private String podId;
        private String podName;
        private Date removed;
        private State state;
        private Type type;
        private String version;
        private String zoneId;
        private String zoneName;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder allocationState(AllocationState allocationState) {
            this.allocationState = allocationState;
            return this;
        }

        public Builder averageLoad(int averageLoad) {
            this.averageLoad = averageLoad;
            return this;
        }

        public Builder capabilities(String capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder clusterType(ClusterType clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public Builder cpuAllocated(String cpuAllocated) {
            this.cpuAllocated = cpuAllocated;
            return this;
        }

        public Builder cpuNumber(int cpuNumber) {
            this.cpuNumber = cpuNumber;
            return this;
        }

        public Builder cpuSpeed(int cpuSpeed) {
            this.cpuSpeed = cpuSpeed;
            return this;
        }

        public Builder cpuUsed(String cpuUsed) {
            this.cpuUsed = cpuUsed;
            return this;
        }

        public Builder cpuWithOverProvisioning(float cpuWithOverProvisioning) {
            this.cpuWithOverProvisioning = cpuWithOverProvisioning;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder disconnected(Date disconnected) {
            this.disconnected = disconnected;
            return this;
        }

        public Builder diskSizeAllocated(long diskSizeAllocated) {
            this.diskSizeAllocated = diskSizeAllocated;
            return this;
        }

        public Builder diskSizeTotal(long diskSizeTotal) {
            this.diskSizeTotal = diskSizeTotal;
            return this;
        }

        public Builder events(String events) {
            this.events = events;
            return this;
        }

        public Builder hasEnoughCapacity(boolean hasEnoughCapacity) {
            this.hasEnoughCapacity = hasEnoughCapacity;
            return this;
        }

        public Builder hostTags(String hostTags) {
            this.hostTags = hostTags;
            return this;
        }

        public Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder localStorageActive(boolean localStorageActive) {
            this.localStorageActive = localStorageActive;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(AsyncJob.Status jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder lastPinged(Date lastPinged) {
            this.lastPinged = lastPinged;
            return this;
        }

        public Builder managementServerId(String managementServerId) {
            this.managementServerId = managementServerId;
            return this;
        }

        public Builder memoryAllocated(long memoryAllocated) {
            this.memoryAllocated = memoryAllocated;
            return this;
        }

        public Builder memoryTotal(long memoryTotal) {
            this.memoryTotal = memoryTotal;
            return this;
        }

        public Builder memoryUsed(long memoryUsed) {
            this.memoryUsed = memoryUsed;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder networkKbsRead(long networkKbsRead) {
            this.networkKbsRead = networkKbsRead;
            return this;
        }

        public Builder networkKbsWrite(long networkKbsWrite) {
            this.networkKbsWrite = networkKbsWrite;
            return this;
        }

        public Builder osCategoryId(String osCategoryId) {
            this.osCategoryId = osCategoryId;
            return this;
        }

        public Builder osCategoryName(String osCategoryName) {
            this.osCategoryName = osCategoryName;
            return this;
        }

        public Builder podId(String podId) {
            this.podId = podId;
            return this;
        }

        public Builder podName(String podName) {
            this.podName = podName;
            return this;
        }

        public Builder removed(Date removed) {
            this.removed = removed;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Host build() {
            return new Host(this.id, this.allocationState, this.averageLoad, this.capabilities, this.clusterId, this.clusterName, this.clusterType, this.cpuAllocated, this.cpuNumber, this.cpuSpeed, this.cpuUsed, this.cpuWithOverProvisioning, this.created, this.disconnected, this.diskSizeAllocated, this.diskSizeTotal, this.events, this.hasEnoughCapacity, this.hostTags, this.hypervisor, this.ipAddress, this.localStorageActive, this.jobId, this.jobStatus, this.lastPinged, this.managementServerId, this.memoryAllocated, this.memoryTotal, this.memoryUsed, this.name, this.networkKbsRead, this.networkKbsWrite, this.osCategoryId, this.osCategoryName, this.podId, this.podName, this.removed, this.state, this.type, this.version, this.zoneId, this.zoneName);
        }
    }

    public static enum Type {
        STORAGE,
        ROUTING,
        SECONDARY_STORAGE,
        SECONDARY_STORAGE_CMD_EXECUTOR,
        CONSOLE_PROXY,
        EXTERNAL_FIREWALL,
        EXTERNAL_LOAD_BALANCER,
        PXE_SERVER,
        TRAFFIC_MONITOR,
        EXTERNAL_DHCP,
        SECONDARY_STORAGE_VM,
        LOCAL_SECONDARY_STORAGE,
        UNKNOWN;


        public static Type fromValue(String value) {
            try {
                if (value.equals("SecondaryStorageVM")) {
                    return SECONDARY_STORAGE_VM;
                }
                return Type.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value));
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            if (this == SECONDARY_STORAGE_VM) {
                return "SecondaryStorageVM";
            }
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    public static enum State {
        CONNECTING,
        UP,
        DOWN,
        DISCONNECTED,
        UPDATING,
        PREPARE_FOR_MAINTENANCE,
        ERROR_IN_MAINTENANCE,
        MAINTENANCE,
        ALERT,
        REMOVED,
        REBALANCING,
        UNKNOWN;


        public static State fromValue(String value) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value));
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    public static enum ClusterType {
        CLOUD_MANAGED,
        EXTERNAL_MANAGED,
        UNKNOWN;


        public static ClusterType fromValue(String value) {
            try {
                return ClusterType.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, value));
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }
}

