/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.Set;

public class IPForwardingRule
implements Comparable<IPForwardingRule> {
    private String id;
    @SerializedName(value="ipaddress")
    private String IPAddress;
    @SerializedName(value="ipaddressid")
    private String IPAddressId;
    @SerializedName(value="startport")
    private int startPort;
    private String protocol;
    @SerializedName(value="endport")
    public int endPort;
    private String state;
    @SerializedName(value="virtualmachinedisplayname")
    private String virtualMachineDisplayName;
    @SerializedName(value="virtualmachineid")
    public String virtualMachineId;
    @SerializedName(value="virtualmachinename")
    private String virtualMachineName;
    @SerializedName(value="publicport")
    public int publicPort;
    @SerializedName(value="cidrlist")
    private Set<String> CIDRs;
    @SerializedName(value="privateendport")
    private int privateEndPort;
    @SerializedName(value="publicendport")
    private int publicEndPort;

    public static Builder builder() {
        return new Builder();
    }

    IPForwardingRule() {
    }

    public IPForwardingRule(String id, String iPAddress, String iPAddressId, int startPort, String protocol, int endPort, String state, String virtualMachineDisplayName, String virtualMachineId, String virtualMachineName, int publicEndPort, int publicPort, Set<String> CIDRs, int privateEndPort) {
        this.id = id;
        this.IPAddress = iPAddress;
        this.IPAddressId = iPAddressId;
        this.startPort = startPort;
        this.protocol = protocol;
        this.endPort = endPort;
        this.state = state;
        this.virtualMachineDisplayName = virtualMachineDisplayName;
        this.virtualMachineId = virtualMachineId;
        this.virtualMachineName = virtualMachineName;
        this.CIDRs = Sets.newHashSet(CIDRs);
        this.privateEndPort = privateEndPort;
        this.publicEndPort = publicEndPort;
        this.publicPort = publicPort;
    }

    @Override
    public int compareTo(IPForwardingRule arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public String getId() {
        return this.id;
    }

    public String getIPAddress() {
        return this.IPAddress;
    }

    public String getIPAddressId() {
        return this.IPAddressId;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public String getState() {
        return this.state;
    }

    public String getVirtualMachineDisplayName() {
        return this.virtualMachineDisplayName;
    }

    public String getVirtualMachineId() {
        return this.virtualMachineId;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    public Set<String> getCIDRs() {
        return Collections.unmodifiableSet(this.CIDRs);
    }

    public int getPrivateEndPort() {
        return this.privateEndPort;
    }

    public int getPublicEndPort() {
        return this.publicEndPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPForwardingRule that = (IPForwardingRule)o;
        if (!Objects.equal((Object)this.IPAddress, (Object)that.IPAddress)) {
            return false;
        }
        if (!Objects.equal((Object)this.IPAddressId, (Object)that.IPAddressId)) {
            return false;
        }
        if (!Objects.equal((Object)this.endPort, (Object)that.endPort)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.protocol, (Object)that.protocol)) {
            return false;
        }
        if (!Objects.equal((Object)this.startPort, (Object)that.startPort)) {
            return false;
        }
        if (!Objects.equal((Object)this.publicEndPort, (Object)that.publicEndPort)) {
            return false;
        }
        if (!Objects.equal((Object)this.privateEndPort, (Object)that.privateEndPort)) {
            return false;
        }
        if (!Objects.equal((Object)this.publicPort, (Object)that.publicPort)) {
            return false;
        }
        if (!Objects.equal((Object)this.state, (Object)that.state)) {
            return false;
        }
        if (!Objects.equal((Object)this.virtualMachineDisplayName, (Object)that.virtualMachineDisplayName)) {
            return false;
        }
        if (!Objects.equal((Object)this.virtualMachineId, (Object)that.virtualMachineId)) {
            return false;
        }
        return Objects.equal((Object)this.virtualMachineName, (Object)that.virtualMachineName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.IPAddress, this.IPAddressId, this.endPort, this.id, this.protocol, this.startPort, this.publicEndPort, this.privateEndPort, this.publicPort, this.state, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName});
    }

    public String toString() {
        return "[IPAddress=" + this.IPAddress + ", IPAddressId=" + this.IPAddressId + ", id=" + this.id + ", startPort=" + this.startPort + ", protocol=" + this.protocol + ", endPort=" + this.endPort + ", state=" + this.state + ", virtualMachineDisplayName=" + this.virtualMachineDisplayName + ", virtualMachineId=" + this.virtualMachineId + ", virtualMachineName=" + this.virtualMachineName + "]";
    }

    public static class Builder {
        private String id;
        private String IPAddress;
        private String IPAddressId;
        private int startPort;
        private String protocol;
        public int endPort;
        private String state;
        private String virtualMachineDisplayName;
        public String virtualMachineId;
        private String virtualMachineName;
        private Set<String> CIDRs = ImmutableSet.of();
        private int privateEndPort;
        private int publicEndPort;
        public int publicPort;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder IPAddress(String IPAddress) {
            this.IPAddress = IPAddress;
            return this;
        }

        public Builder IPAddressId(String IPAddressId) {
            this.IPAddressId = IPAddressId;
            return this;
        }

        public Builder startPort(int startPort) {
            this.startPort = startPort;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder endPort(int endPort) {
            this.endPort = endPort;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder virtualMachineDisplayName(String virtualMachineDisplayName) {
            this.virtualMachineDisplayName = virtualMachineDisplayName;
            return this;
        }

        public Builder virtualMachineId(String virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this;
        }

        public Builder virtualMachineName(String virtualMachineName) {
            this.virtualMachineName = virtualMachineName;
            return this;
        }

        public Builder publicPort(int publicPort) {
            this.publicPort = publicPort;
            return this;
        }

        public Builder CIDRs(Set<String> CIDRs) {
            this.CIDRs = CIDRs;
            return this;
        }

        public Builder privateEndPort(int privateEndPort) {
            this.privateEndPort = privateEndPort;
            return this;
        }

        public Builder publicEndPort(int publicEndPort) {
            this.publicEndPort = publicEndPort;
            return this;
        }

        public IPForwardingRule build() {
            return new IPForwardingRule(this.id, this.IPAddress, this.IPAddressId, this.startPort, this.protocol, this.endPort, this.state, this.virtualMachineDisplayName, this.virtualMachineId, this.virtualMachineName, this.publicEndPort, this.publicPort, this.CIDRs, this.privateEndPort);
        }
    }
}

