/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;

public class IngressRule
implements Comparable<IngressRule> {
    private String account;
    @SerializedName(value="cidr")
    private String CIDR;
    @SerializedName(value="endport")
    private int endPort = -1;
    @SerializedName(value="icmpcode")
    private int ICMPCode = -1;
    @SerializedName(value="icmptype")
    private int ICMPType = -1;
    private String protocol;
    @SerializedName(value="ruleid")
    private String id;
    @SerializedName(value="securitygroupname")
    private String securityGroupName;
    @SerializedName(value="startport")
    private int startPort = -1;

    public static Builder builder() {
        return new Builder();
    }

    IngressRule() {
    }

    public IngressRule(String account, String CIDR, int endPort, int iCMPCode, int iCMPType, String protocol, String id, String securityGroupName, int startPort) {
        if (account == null) {
            Preconditions.checkArgument((securityGroupName == null && CIDR != null ? 1 : 0) != 0, (Object)"if you do not specify an account and security group, you must specify a CIDR range");
        }
        if (CIDR == null) {
            Preconditions.checkArgument((account != null && securityGroupName != null ? 1 : 0) != 0, (Object)"if you do not specify an account and security group, you must specify a CIDR range");
        }
        this.account = account;
        this.CIDR = CIDR;
        this.endPort = endPort;
        this.ICMPCode = iCMPCode;
        this.ICMPType = iCMPType;
        this.protocol = protocol;
        this.id = id;
        this.securityGroupName = securityGroupName;
        this.startPort = startPort;
    }

    public String getAccount() {
        return this.account;
    }

    public String getCIDR() {
        return this.CIDR;
    }

    public int getEndPort() {
        return this.endPort;
    }

    public int getICMPCode() {
        return this.ICMPCode;
    }

    public int getICMPType() {
        return this.ICMPType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getId() {
        return this.id;
    }

    public String getSecurityGroupName() {
        return this.securityGroupName;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressRule that = (IngressRule)o;
        if (!Objects.equal((Object)this.CIDR, (Object)that.CIDR)) {
            return false;
        }
        if (!Objects.equal((Object)this.ICMPCode, (Object)that.ICMPCode)) {
            return false;
        }
        if (!Objects.equal((Object)this.ICMPType, (Object)that.ICMPType)) {
            return false;
        }
        if (!Objects.equal((Object)this.account, (Object)that.account)) {
            return false;
        }
        if (!Objects.equal((Object)this.endPort, (Object)that.endPort)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.protocol, (Object)that.protocol)) {
            return false;
        }
        if (!Objects.equal((Object)this.securityGroupName, (Object)that.securityGroupName)) {
            return false;
        }
        return Objects.equal((Object)this.startPort, (Object)that.startPort);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.CIDR, this.ICMPCode, this.ICMPType, this.account, this.endPort, this.id, this.protocol, this.securityGroupName, this.startPort});
    }

    public String toString() {
        return "IngressRule{account='" + this.account + '\'' + ", CIDR='" + this.CIDR + '\'' + ", endPort=" + this.endPort + ", ICMPCode=" + this.ICMPCode + ", ICMPType=" + this.ICMPType + ", protocol='" + this.protocol + '\'' + ", id=" + this.id + ", securityGroupName='" + this.securityGroupName + '\'' + ", startPort=" + this.startPort + '}';
    }

    @Override
    public int compareTo(IngressRule arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public static class Builder {
        private String account;
        private String CIDR;
        private int endPort = -1;
        private int ICMPCode = -1;
        private int ICMPType = -1;
        private String protocol;
        private String id;
        private String securityGroupName;
        private int startPort = -1;

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder CIDR(String CIDR) {
            this.CIDR = CIDR;
            return this;
        }

        public Builder endPort(int endPort) {
            this.endPort = endPort;
            return this;
        }

        public Builder ICMPCode(int ICMPCode) {
            this.ICMPCode = ICMPCode;
            return this;
        }

        public Builder ICMPType(int ICMPType) {
            this.ICMPType = ICMPType;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder securityGroupName(String securityGroupName) {
            this.securityGroupName = securityGroupName;
            return this;
        }

        public Builder startPort(int startPort) {
            this.startPort = startPort;
            return this;
        }

        public IngressRule build() {
            return new IngressRule(this.account, this.CIDR, this.endPort, this.ICMPCode, this.ICMPType, this.protocol, this.id, this.securityGroupName, this.startPort);
        }
    }
}

