/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import org.jclouds.cloudstack.domain.AllocationState;

public class Pod
implements Comparable<Pod> {
    private String id;
    private String name;
    @SerializedName(value="zoneid")
    private String zoneId;
    @SerializedName(value="zonename")
    private String zoneName;
    private String gateway;
    private String netmask;
    @SerializedName(value="startip")
    private String startIp;
    @SerializedName(value="endip")
    private String endIp;
    @SerializedName(value="allocationstate")
    private AllocationState allocationState;

    public static Builder builder() {
        return new Builder();
    }

    Pod() {
    }

    public Pod(String id, String name, String zoneId, String zoneName, String gateway, String netmask, String startIp, String endIp, AllocationState allocationState) {
        this.id = id;
        this.name = name;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
        this.gateway = gateway;
        this.netmask = netmask;
        this.startIp = startIp;
        this.endIp = endIp;
        this.allocationState = allocationState;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getStartIp() {
        return this.startIp;
    }

    public String getEndIp() {
        return this.endIp;
    }

    public AllocationState getAllocationState() {
        return this.allocationState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pod that = (Pod)o;
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneId, (Object)that.zoneId)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.allocationState), (Object)((Object)that.allocationState))) {
            return false;
        }
        if (!Objects.equal((Object)this.endIp, (Object)that.endIp)) {
            return false;
        }
        if (!Objects.equal((Object)this.gateway, (Object)that.gateway)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)this.netmask, (Object)that.netmask)) {
            return false;
        }
        if (!Objects.equal((Object)this.startIp, (Object)that.startIp)) {
            return false;
        }
        return Objects.equal((Object)this.zoneName, (Object)that.zoneName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.zoneId, this.allocationState, this.endIp, this.gateway, this.name, this.netmask, this.startIp, this.zoneName});
    }

    public String toString() {
        return "Pod{id=" + this.id + ", name='" + this.name + '\'' + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + ", gateway='" + this.gateway + '\'' + ", netmask='" + this.netmask + '\'' + ", startIp='" + this.startIp + '\'' + ", endIp='" + this.endIp + '\'' + ", allocationState=" + (Object)((Object)this.allocationState) + '}';
    }

    @Override
    public int compareTo(Pod other) {
        return this.id.compareTo(other.id);
    }

    public static class Builder {
        private String id;
        private String name;
        private String zoneId;
        private String zoneName;
        private String gateway;
        private String netmask;
        private String startIp;
        private String endIp;
        private AllocationState allocationState;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        public Builder startIp(String startIp) {
            this.startIp = startIp;
            return this;
        }

        public Builder endIp(String endIp) {
            this.endIp = endIp;
            return this;
        }

        public Builder allocationState(AllocationState allocationState) {
            this.allocationState = allocationState;
            return this;
        }

        public Pod build() {
            return new Pod(this.id, this.name, this.zoneId, this.zoneName, this.gateway, this.netmask, this.startIp, this.endIp, this.allocationState);
        }
    }
}

