/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.IngressRule;

public class SecurityGroup
implements Comparable<SecurityGroup> {
    private String id;
    private String account;
    private String name;
    private String description;
    private String domain;
    @SerializedName(value="domainid")
    private String domainId;
    @SerializedName(value="jobid")
    @Nullable
    private String jobId;
    @SerializedName(value="jobstatus")
    @Nullable
    private Integer jobStatus;
    @SerializedName(value="ingressrule")
    private SortedSet<IngressRule> ingressRules = ImmutableSortedSet.of();

    public static Builder builder() {
        return new Builder();
    }

    public SecurityGroup(String id, String account, String name, String description, String domain, String domainId, String jobId, Integer jobStatus, Set<IngressRule> ingressRules) {
        this.id = id;
        this.account = account;
        this.name = name;
        this.description = description;
        this.domain = domain;
        this.domainId = domainId;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.ingressRules = ImmutableSortedSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(ingressRules, (Object)"ingressRules")));
    }

    SecurityGroup() {
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    @Nullable
    public Integer getJobStatus() {
        return this.jobStatus;
    }

    public String getAccount() {
        return this.account;
    }

    public Set<IngressRule> getIngressRules() {
        return this.ingressRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityGroup that = (SecurityGroup)o;
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        return Objects.equal((Object)this.jobStatus, (Object)that.jobStatus);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.domainId, this.id, this.jobStatus});
    }

    public String toString() {
        return "SecurityGroup{id=" + this.id + ", account='" + this.account + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", jobId=" + this.jobId + ", jobStatus=" + this.jobStatus + ", ingressRules=" + this.ingressRules + '}';
    }

    @Override
    public int compareTo(SecurityGroup arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public static class Builder {
        private String id;
        private String account;
        private String name;
        private String description;
        private String domain;
        private String domainId;
        private String jobId;
        private Integer jobStatus;
        private Set<IngressRule> ingressRules = ImmutableSet.of();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(int jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder ingressRules(Set<IngressRule> ingressRules) {
            this.ingressRules = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(ingressRules, (Object)"ingressRules")));
            return this;
        }

        public SecurityGroup build() {
            return new SecurityGroup(this.id, this.account, this.name, this.description, this.domain, this.domainId, this.jobId, this.jobStatus, this.ingressRules);
        }
    }
}

