/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import org.jclouds.cloudstack.domain.Snapshot;

public class SnapshotPolicy
implements Comparable<SnapshotPolicy> {
    private String id;
    @SerializedName(value="intervaltype")
    private Snapshot.Interval interval;
    @SerializedName(value="maxsnaps")
    private long numberToRetain;
    private String schedule;
    private String timezone;
    @SerializedName(value="volumeid")
    private String volumeId;

    public static Builder builder() {
        return new Builder();
    }

    public SnapshotPolicy(String id, Snapshot.Interval interval, long numberToRetain, String schedule, String timezone, String volumeId) {
        this.id = id;
        this.interval = interval;
        this.numberToRetain = numberToRetain;
        this.schedule = schedule;
        this.timezone = timezone;
        this.volumeId = volumeId;
    }

    SnapshotPolicy() {
    }

    public String getId() {
        return this.id;
    }

    public Snapshot.Interval getInterval() {
        return this.interval;
    }

    public long getNumberToRetain() {
        return this.numberToRetain;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotPolicy that = (SnapshotPolicy)o;
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.numberToRetain, (Object)that.numberToRetain)) {
            return false;
        }
        if (!Objects.equal((Object)this.volumeId, (Object)that.volumeId)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.interval), (Object)((Object)that.interval))) {
            return false;
        }
        if (!Objects.equal((Object)this.schedule, (Object)that.schedule)) {
            return false;
        }
        return Objects.equal((Object)this.timezone, (Object)that.timezone);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.numberToRetain, this.volumeId, this.interval, this.schedule, this.timezone});
    }

    public String toString() {
        return "SnapshotPolicy{id=" + this.id + ", interval=" + (Object)((Object)this.interval) + ", numberToRetain=" + this.numberToRetain + ", schedule='" + this.schedule + '\'' + ", timezone='" + this.timezone + '\'' + ", volumeId=" + this.volumeId + '}';
    }

    @Override
    public int compareTo(SnapshotPolicy other) {
        return this.id.compareTo(other.getId());
    }

    public static class Builder {
        private String id;
        private Snapshot.Interval interval;
        private long numberToRetain;
        private String schedule;
        private String timezone;
        private String volumeId;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder interval(Snapshot.Interval interval) {
            this.interval = interval;
            return this;
        }

        public Builder numberToRetain(long numberToRetain) {
            this.numberToRetain = numberToRetain;
            return this;
        }

        public Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public SnapshotPolicy build() {
            return new SnapshotPolicy(this.id, this.interval, this.numberToRetain, this.schedule, this.timezone, this.volumeId);
        }
    }
}

