/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.Map;

public class UsageRecord
implements Comparable<UsageRecord> {
    @SerializedName(value="usageid")
    private String id;
    private String description;
    @SerializedName(value="accountid")
    private String accountId;
    @SerializedName(value="account")
    private String accountName;
    @SerializedName(value="domainid")
    private String domainId;
    @SerializedName(value="startdate")
    private Date startDate;
    @SerializedName(value="enddate")
    private Date endDate;
    @SerializedName(value="assigndate")
    private Date assignDate;
    @SerializedName(value="releasedate")
    private String releaseDate;
    @SerializedName(value="zoneid")
    private String zoneId;
    @SerializedName(value="virtualmachineid")
    private String virtualMachineId;
    @SerializedName(value="name")
    private String virtualMachineName;
    @SerializedName(value="offeringid")
    private String serviceOfferingId;
    @SerializedName(value="templateid")
    private String templateId;
    @SerializedName(value="ipaddress")
    private String ipAddress;
    @SerializedName(value="issourcenat")
    private boolean isSourceNAT;
    @SerializedName(value="rawusage")
    private double rawUsageHours;
    @SerializedName(value="usage")
    private String usage;
    private String type;
    @SerializedName(value="usagetype")
    private UsageType usageType;

    public static Builder builder() {
        return new Builder();
    }

    UsageRecord() {
    }

    public UsageRecord(String id, String description, String accountId, String accountName, String domainId, Date startDate, Date endDate, Date assignDate, String releaseDate, String zoneId, String virtualMachineId, String virtualMachineName, String serviceOfferingId, String templateId, String ipAddress, boolean sourceNAT, double rawUsageHours, String usage, String type, UsageType usageType) {
        this.id = id;
        this.description = description;
        this.accountId = accountId;
        this.accountName = accountName;
        this.domainId = domainId;
        this.startDate = startDate;
        this.endDate = endDate;
        this.assignDate = assignDate;
        this.releaseDate = releaseDate;
        this.zoneId = zoneId;
        this.virtualMachineId = virtualMachineId;
        this.virtualMachineName = virtualMachineName;
        this.serviceOfferingId = serviceOfferingId;
        this.templateId = templateId;
        this.ipAddress = ipAddress;
        this.isSourceNAT = sourceNAT;
        this.rawUsageHours = rawUsageHours;
        this.usage = usage;
        this.type = type;
        this.usageType = usageType;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getAssignDate() {
        return this.assignDate;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getVirtualMachineId() {
        return this.virtualMachineId;
    }

    public String getVirtualMachineName() {
        return this.virtualMachineName;
    }

    public String getServiceOfferingId() {
        return this.serviceOfferingId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean isSourceNAT() {
        return this.isSourceNAT;
    }

    public double getRawUsageHours() {
        return this.rawUsageHours;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getType() {
        return this.type;
    }

    public UsageType getUsageType() {
        return this.usageType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageRecord that = (UsageRecord)o;
        if (!Objects.equal((Object)this.accountId, (Object)that.accountId)) {
            return false;
        }
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.isSourceNAT, (Object)that.isSourceNAT)) {
            return false;
        }
        if (!Objects.equal((Object)this.rawUsageHours, (Object)that.rawUsageHours)) {
            return false;
        }
        if (!Objects.equal((Object)this.releaseDate, (Object)that.releaseDate)) {
            return false;
        }
        if (!Objects.equal((Object)this.serviceOfferingId, (Object)that.serviceOfferingId)) {
            return false;
        }
        if (!Objects.equal((Object)this.templateId, (Object)that.templateId)) {
            return false;
        }
        if (!Objects.equal((Object)this.virtualMachineId, (Object)that.virtualMachineId)) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneId, (Object)that.zoneId)) {
            return false;
        }
        if (!Objects.equal((Object)this.accountName, (Object)that.accountName)) {
            return false;
        }
        if (!Objects.equal((Object)this.assignDate, (Object)that.assignDate)) {
            return false;
        }
        if (!Objects.equal((Object)this.description, (Object)that.description)) {
            return false;
        }
        if (!Objects.equal((Object)this.endDate, (Object)that.endDate)) {
            return false;
        }
        if (!Objects.equal((Object)this.ipAddress, (Object)that.ipAddress)) {
            return false;
        }
        if (!Objects.equal((Object)this.startDate, (Object)that.startDate)) {
            return false;
        }
        if (!Objects.equal((Object)this.type, (Object)that.type)) {
            return false;
        }
        if (!Objects.equal((Object)this.usage, (Object)that.usage)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.usageType), (Object)((Object)that.usageType))) {
            return false;
        }
        return Objects.equal((Object)this.virtualMachineName, (Object)that.virtualMachineName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.accountId, this.domainId, this.id, this.isSourceNAT, this.rawUsageHours, this.releaseDate, this.serviceOfferingId, this.templateId, this.virtualMachineId, this.zoneId, this.accountName, this.assignDate, this.description, this.endDate, this.ipAddress, this.startDate, this.type, this.usage, this.usageType, this.virtualMachineName});
    }

    public String toString() {
        return "UsageRecord{id=" + this.id + ", description='" + this.description + '\'' + ", accountId=" + this.accountId + ", accountName='" + this.accountName + '\'' + ", domainId=" + this.domainId + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", assignDate=" + this.assignDate + ", releaseDate=" + this.releaseDate + ", zoneId=" + this.zoneId + ", virtualMachineId=" + this.virtualMachineId + ", virtualMachineName='" + this.virtualMachineName + '\'' + ", serviceOfferingId=" + this.serviceOfferingId + ", templateId=" + this.templateId + ", ipAddress='" + this.ipAddress + '\'' + ", isSourceNAT=" + this.isSourceNAT + ", rawUsageHours=" + this.rawUsageHours + ", usage='" + this.usage + '\'' + ", type='" + this.type + '\'' + ", usageType=" + (Object)((Object)this.usageType) + '}';
    }

    @Override
    public int compareTo(UsageRecord other) {
        return this.id.compareTo(other.id);
    }

    public static class Builder {
        private String id;
        private String description;
        private String accountId;
        private String accountName;
        private String domainId;
        private Date startDate;
        private Date endDate;
        private Date assignDate;
        private String releaseDate;
        private String zoneId;
        private String virtualMachineId;
        private String virtualMachineName;
        private String serviceOfferingId;
        private String templateId;
        private String ipAddress;
        private boolean isSourceNAT;
        private double rawUsageHours;
        private String usage;
        private String type;
        private UsageType usageType;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder startDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(Date endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder assignDate(Date assignDate) {
            this.assignDate = assignDate;
            return this;
        }

        public Builder releaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder virtualMachineId(String virtualMachineId) {
            this.virtualMachineId = virtualMachineId;
            return this;
        }

        public Builder virtualMachineName(String virtualMachineName) {
            this.virtualMachineName = virtualMachineName;
            return this;
        }

        public Builder serviceOfferingId(String serviceOfferingId) {
            this.serviceOfferingId = serviceOfferingId;
            return this;
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder surceNAT(boolean sourceNAT) {
            this.isSourceNAT = sourceNAT;
            return this;
        }

        public Builder rawUsageHours(double rawUsageHours) {
            this.rawUsageHours = rawUsageHours;
            return this;
        }

        public Builder usage(String usage) {
            this.usage = usage;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder usageType(UsageType usageType) {
            this.usageType = usageType;
            return this;
        }

        public UsageRecord build() {
            return new UsageRecord(this.id, this.description, this.accountId, this.accountName, this.domainId, this.startDate, this.endDate, this.assignDate, this.releaseDate, this.zoneId, this.virtualMachineId, this.virtualMachineName, this.serviceOfferingId, this.templateId, this.ipAddress, this.isSourceNAT, this.rawUsageHours, this.usage, this.type, this.usageType);
        }
    }

    public static enum UsageType {
        RUNNING_VM(1),
        ALLOCATED_VM(2),
        IP_ADDRESS(3),
        NETWORK_BYTES_SENT(4),
        NETWORK_BYTES_RECEIVED(5),
        VOLUME(6),
        TEMPLATE(7),
        ISO(8),
        SNAPSHOT(9),
        SECURITY_GROUP(10),
        LOAD_BALANCER_POLICY(11),
        PORT_FORWARDING_RULE(12),
        NETWORK_OFFERING(13),
        VPN_USERS(14),
        UNRECOGNIZED(0);

        private int code;
        private static final Map<Integer, UsageType> INDEX;

        private UsageType(int code) {
            this.code = code;
        }

        public String toString() {
            return "" + this.code;
        }

        public static UsageType fromValue(String usageType) {
            Integer code = new Integer((String)Preconditions.checkNotNull((Object)usageType, (Object)"usageType"));
            return INDEX.containsKey(code) ? INDEX.get(code) : UNRECOGNIZED;
        }

        static {
            INDEX = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])UsageType.values()), (Function)new Function<UsageType, Integer>(){

                public Integer apply(UsageType input) {
                    return input.code;
                }
            });
        }
    }
}

