/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.annotation.Nullable;
import org.jclouds.cloudstack.domain.NIC;
import org.jclouds.cloudstack.domain.SecurityGroup;

public class VirtualMachine
implements Comparable<VirtualMachine> {
    private String id;
    private String account;
    @SerializedName(value="cpunumber")
    private long cpuCount;
    @SerializedName(value="cpuspeed")
    private long cpuSpeed;
    @SerializedName(value="cpuused")
    private String cpuUsed;
    @SerializedName(value="displayname")
    private String displayName;
    private Date created;
    private String domain;
    @SerializedName(value="domainid")
    private String domainId;
    @SerializedName(value="forvirtualnetwork")
    private boolean usesVirtualNetwork;
    private String group;
    @SerializedName(value="groupid")
    private String groupId;
    @SerializedName(value="guestosid")
    private String guestOSId;
    @SerializedName(value="haenable")
    private boolean HAEnabled;
    @SerializedName(value="hostid")
    private String hostId;
    private String hostname;
    @SerializedName(value="ipaddress")
    private String IPAddress;
    @SerializedName(value="isodisplaytext")
    private String ISODisplayText;
    @SerializedName(value="isoid")
    private String ISOId;
    @SerializedName(value="isoname")
    private String ISOName;
    @SerializedName(value="jobid")
    @Nullable
    private String jobId;
    @SerializedName(value="jobstatus")
    @Nullable
    private Integer jobStatus;
    private long memory;
    private String name;
    @SerializedName(value="networkkbsread")
    private Long networkKbsRead;
    @SerializedName(value="networkkbswrite")
    private Long networkKbsWrite;
    @Nullable
    private String password;
    @SerializedName(value="passwordenabled")
    private boolean passwordEnabled;
    @SerializedName(value="publicip")
    private String publicIP;
    @SerializedName(value="publicipid")
    private String publicIPId;
    @SerializedName(value="rootdeviceid")
    private String rootDeviceId;
    @SerializedName(value="rootdevicetype")
    private String rootDeviceType;
    @SerializedName(value="serviceofferingid")
    private String serviceOfferingId;
    @SerializedName(value="serviceofferingname")
    private String serviceOfferingName;
    private State state;
    @SerializedName(value="templatedisplaytext")
    private String templateDisplayText;
    @SerializedName(value="templateid")
    private String templateId;
    @SerializedName(value="templatename")
    private String templateName;
    @SerializedName(value="zoneid")
    private String zoneId;
    @SerializedName(value="zonename")
    private String zoneName;
    @SerializedName(value="nic")
    private Set<NIC> nics = ImmutableSet.of();
    private String hypervisor;
    @SerializedName(value="securitygroup")
    private Set<SecurityGroup> securityGroups = ImmutableSet.of();

    public static Builder builder() {
        return new Builder();
    }

    public VirtualMachine(String id, String account, long cpuCount, long cpuSpeed, String cpuUsed, String displayName, Date created, String domain, String domainId, boolean usesVirtualNetwork, String group, String groupId, String guestOSId, boolean hAEnabled, String hostId, String hostname, String iPAddress, String iSODisplayText, String iSOId, String iSOName, String jobId, Integer jobStatus, long memory, String name, Long networkKbsRead, Long networkKbsWrite, String password, boolean passwordEnabled, String publicIP, String publicIPId, String rootDeviceId, String rootDeviceType, Set<SecurityGroup> securityGroups, String serviceOfferingId, String serviceOfferingName, State state, String templateDisplayText, String templateId, String templateName, String zoneId, String zoneName, Set<NIC> nics, String hypervisor) {
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)cpuUsed) || cpuUsed.matches("^[0-9\\.]+%$") ? 1 : 0) != 0, (Object)"cpuUsed value should be a decimal number followed by %");
        this.id = id;
        this.account = account;
        this.cpuCount = cpuCount;
        this.cpuSpeed = cpuSpeed;
        this.cpuUsed = cpuUsed != null ? cpuUsed + "" : null;
        this.displayName = displayName;
        this.created = created;
        this.domain = domain;
        this.domainId = domainId;
        this.usesVirtualNetwork = usesVirtualNetwork;
        this.group = group;
        this.groupId = groupId;
        this.guestOSId = guestOSId;
        this.HAEnabled = hAEnabled;
        this.hostId = hostId;
        this.hostname = hostname;
        this.IPAddress = iPAddress;
        this.ISODisplayText = iSODisplayText;
        this.ISOId = iSOId;
        this.ISOName = iSOName;
        this.jobId = jobId;
        this.jobStatus = jobStatus;
        this.memory = memory;
        this.name = name;
        this.networkKbsRead = networkKbsRead;
        this.networkKbsWrite = networkKbsWrite;
        this.password = password;
        this.passwordEnabled = passwordEnabled;
        this.publicIP = publicIP;
        this.publicIPId = publicIPId;
        this.rootDeviceId = rootDeviceId;
        this.rootDeviceType = rootDeviceType;
        this.securityGroups = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(securityGroups, (Object)"securityGroups")));
        this.serviceOfferingId = serviceOfferingId;
        this.serviceOfferingName = serviceOfferingName;
        this.state = state;
        this.templateDisplayText = templateDisplayText;
        this.templateId = templateId;
        this.templateName = templateName;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
        this.nics = nics;
        this.hypervisor = hypervisor;
    }

    VirtualMachine() {
    }

    public String getId() {
        return this.id;
    }

    public String getAccount() {
        return this.account;
    }

    public long getCpuCount() {
        return this.cpuCount;
    }

    public long getCpuSpeed() {
        return this.cpuSpeed;
    }

    public float getCpuUsed() {
        return this.cpuUsed != null ? Float.parseFloat(this.cpuUsed.substring(0, this.cpuUsed.length() - 1)) : 0.0f;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public boolean usesVirtualNetwork() {
        return this.usesVirtualNetwork;
    }

    public String getGroup() {
        return this.group;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getGuestOSId() {
        return this.guestOSId;
    }

    public boolean isHAEnabled() {
        return this.HAEnabled;
    }

    public String getHostId() {
        return this.hostId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getIPAddress() {
        if (this.IPAddress != null) {
            return this.IPAddress;
        }
        if (this.getNICs().size() > 0) {
            return ((NIC)Iterables.get(this.getNICs(), (int)0)).getIPAddress();
        }
        return null;
    }

    public String getISODisplayText() {
        return this.ISODisplayText;
    }

    public String getISOId() {
        return this.ISOId;
    }

    public String getISOName() {
        return this.ISOName;
    }

    @Nullable
    public String getJobId() {
        return this.jobId;
    }

    @Nullable
    public Integer getJobStatus() {
        return this.jobStatus;
    }

    public long getMemory() {
        return this.memory;
    }

    public String getName() {
        return this.name;
    }

    public Long getNetworkKbsRead() {
        return this.networkKbsRead;
    }

    public Long getNetworkKbsWrite() {
        return this.networkKbsWrite;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public boolean isPasswordEnabled() {
        return this.passwordEnabled;
    }

    public String getPublicIP() {
        return this.publicIP;
    }

    public String getPublicIPId() {
        return this.publicIPId;
    }

    public String getRootDeviceId() {
        return this.rootDeviceId;
    }

    public String getRootDeviceType() {
        return this.rootDeviceType;
    }

    public Set<SecurityGroup> getSecurityGroups() {
        return this.securityGroups;
    }

    public String getServiceOfferingId() {
        return this.serviceOfferingId;
    }

    public String getServiceOfferingName() {
        return this.serviceOfferingName;
    }

    public State getState() {
        return this.state;
    }

    public String getTemplateDisplayText() {
        return this.templateDisplayText;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public Set<NIC> getNICs() {
        return this.nics;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualMachine that = (VirtualMachine)o;
        if (!Objects.equal((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!Objects.equal((Object)this.account, (Object)that.account)) {
            return false;
        }
        if (!Objects.equal((Object)this.cpuCount, (Object)that.cpuCount)) {
            return false;
        }
        if (!Objects.equal((Object)this.cpuSpeed, (Object)that.cpuSpeed)) {
            return false;
        }
        if (!Objects.equal((Object)this.cpuUsed, (Object)that.cpuUsed)) {
            return false;
        }
        if (!Objects.equal((Object)this.displayName, (Object)that.displayName)) {
            return false;
        }
        if (!Objects.equal((Object)this.created, (Object)that.created)) {
            return false;
        }
        if (!Objects.equal((Object)this.domain, (Object)that.domain)) {
            return false;
        }
        if (!Objects.equal((Object)this.domainId, (Object)that.domainId)) {
            return false;
        }
        if (!Objects.equal((Object)this.usesVirtualNetwork, (Object)that.usesVirtualNetwork)) {
            return false;
        }
        if (!Objects.equal((Object)this.group, (Object)that.group)) {
            return false;
        }
        if (!Objects.equal((Object)this.groupId, (Object)that.groupId)) {
            return false;
        }
        if (!Objects.equal((Object)this.guestOSId, (Object)that.guestOSId)) {
            return false;
        }
        if (!Objects.equal((Object)this.HAEnabled, (Object)that.HAEnabled)) {
            return false;
        }
        if (!Objects.equal((Object)this.hostId, (Object)that.hostId)) {
            return false;
        }
        if (!Objects.equal((Object)this.hostname, (Object)that.hostname)) {
            return false;
        }
        if (!Objects.equal((Object)this.IPAddress, (Object)that.IPAddress)) {
            return false;
        }
        if (!Objects.equal((Object)this.ISODisplayText, (Object)that.ISODisplayText)) {
            return false;
        }
        if (!Objects.equal((Object)this.ISOId, (Object)that.ISOId)) {
            return false;
        }
        if (!Objects.equal((Object)this.ISOName, (Object)that.ISOName)) {
            return false;
        }
        if (!Objects.equal((Object)this.jobId, (Object)that.jobId)) {
            return false;
        }
        if (!Objects.equal((Object)this.jobStatus, (Object)that.jobStatus)) {
            return false;
        }
        if (!Objects.equal((Object)this.memory, (Object)that.memory)) {
            return false;
        }
        if (!Objects.equal((Object)this.name, (Object)that.name)) {
            return false;
        }
        if (!Objects.equal((Object)this.networkKbsRead, (Object)that.networkKbsRead)) {
            return false;
        }
        if (!Objects.equal((Object)this.networkKbsWrite, (Object)that.networkKbsWrite)) {
            return false;
        }
        if (!Objects.equal((Object)this.password, (Object)that.password)) {
            return false;
        }
        if (!Objects.equal((Object)this.passwordEnabled, (Object)that.passwordEnabled)) {
            return false;
        }
        if (!Objects.equal((Object)this.publicIP, (Object)that.publicIP)) {
            return false;
        }
        if (!Objects.equal((Object)this.publicIPId, (Object)that.publicIPId)) {
            return false;
        }
        if (!Objects.equal((Object)this.rootDeviceId, (Object)that.rootDeviceId)) {
            return false;
        }
        if (!Objects.equal((Object)this.rootDeviceType, (Object)that.rootDeviceType)) {
            return false;
        }
        if (!Objects.equal(this.securityGroups, that.securityGroups)) {
            return false;
        }
        if (!Objects.equal((Object)this.serviceOfferingId, (Object)that.serviceOfferingId)) {
            return false;
        }
        if (!Objects.equal((Object)this.serviceOfferingName, (Object)that.serviceOfferingName)) {
            return false;
        }
        if (!Objects.equal((Object)((Object)this.state), (Object)((Object)that.state))) {
            return false;
        }
        if (!Objects.equal((Object)this.templateDisplayText, (Object)that.templateDisplayText)) {
            return false;
        }
        if (!Objects.equal((Object)this.templateId, (Object)that.templateId)) {
            return false;
        }
        if (!Objects.equal((Object)this.templateName, (Object)that.templateName)) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneId, (Object)that.zoneId)) {
            return false;
        }
        if (!Objects.equal((Object)this.zoneName, (Object)that.zoneName)) {
            return false;
        }
        if (!Objects.equal(this.nics, that.nics)) {
            return false;
        }
        return Objects.equal((Object)this.hypervisor, (Object)that.hypervisor);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.account, this.cpuCount, this.cpuSpeed, this.cpuUsed, this.displayName, this.created, this.domain, this.domainId, this.usesVirtualNetwork, this.group, this.groupId, this.guestOSId, this.HAEnabled, this.hostId, this.hostname, this.IPAddress, this.ISODisplayText, this.ISOId, this.ISOName, this.jobId, this.jobStatus, this.memory, this.name, this.networkKbsRead, this.networkKbsWrite, this.password, this.passwordEnabled, this.publicIP, this.publicIPId, this.rootDeviceId, this.rootDeviceType, this.securityGroups, this.serviceOfferingId, this.serviceOfferingName, this.state, this.templateDisplayText, this.templateId, this.templateName, this.zoneId, this.zoneName, this.nics, this.hypervisor});
    }

    public String toString() {
        return "VirtualMachine{id=" + this.id + ", account='" + this.account + '\'' + ", cpuCount=" + this.cpuCount + ", cpuSpeed=" + this.cpuSpeed + ", cpuUsed='" + this.cpuUsed + '\'' + ", displayName='" + this.displayName + '\'' + ", created=" + this.created + ", domain='" + this.domain + '\'' + ", domainId=" + this.domainId + ", usesVirtualNetwork=" + this.usesVirtualNetwork + ", group='" + this.group + '\'' + ", groupId=" + this.groupId + ", guestOSId=" + this.guestOSId + ", HAEnabled=" + this.HAEnabled + ", hostId=" + this.hostId + ", hostname='" + this.hostname + '\'' + ", IPAddress='" + this.IPAddress + '\'' + ", ISODisplayText='" + this.ISODisplayText + '\'' + ", ISOId=" + this.ISOId + ", ISOName='" + this.ISOName + '\'' + ", jobId=" + this.jobId + ", jobStatus=" + this.jobStatus + ", memory=" + this.memory + ", name='" + this.name + '\'' + ", networkKbsRead=" + this.networkKbsRead + ", networkKbsWrite=" + this.networkKbsWrite + ", password='" + this.password + '\'' + ", passwordEnabled=" + this.passwordEnabled + ", publicIP='" + this.publicIP + '\'' + ", publicIPId='" + this.publicIPId + '\'' + ", rootDeviceId=" + this.rootDeviceId + ", rootDeviceType='" + this.rootDeviceType + '\'' + ", serviceOfferingId=" + this.serviceOfferingId + ", serviceOfferingName='" + this.serviceOfferingName + '\'' + ", state=" + (Object)((Object)this.state) + ", templateDisplayText='" + this.templateDisplayText + '\'' + ", templateId=" + this.templateId + ", templateName='" + this.templateName + '\'' + ", zoneId=" + this.zoneId + ", zoneName='" + this.zoneName + '\'' + ", nics=" + this.nics + ", hypervisor='" + this.hypervisor + '\'' + ", securityGroups=" + this.securityGroups + '}';
    }

    @Override
    public int compareTo(VirtualMachine arg0) {
        return this.id.compareTo(arg0.getId());
    }

    public static enum State {
        STARTING,
        RUNNING,
        STOPPING,
        STOPPED,
        DESTROYED,
        EXPUNGING,
        MIGRATING,
        ERROR,
        UNKNOWN,
        SHUTDOWNED,
        UNRECOGNIZED;


        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public static State fromValue(String state) {
            try {
                return State.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)state, (Object)"state")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }

    public static class Builder {
        private String id;
        private String account;
        private long cpuCount;
        private long cpuSpeed;
        private String cpuUsed;
        private String displayName;
        private Date created;
        private String domain;
        private String domainId;
        private boolean usesVirtualNetwork;
        private String group;
        private String groupId;
        private String guestOSId;
        private boolean HAEnabled;
        private String hostId;
        private String hostname;
        private String IPAddress;
        private String ISODisplayText;
        private String ISOId;
        private String ISOName;
        private String jobId;
        private Integer jobStatus;
        private long memory;
        private String name;
        private Long networkKbsRead;
        private Long networkKbsWrite;
        private String password;
        private boolean passwordEnabled;
        private String publicIP;
        private String publicIPId;
        private String rootDeviceId;
        private String rootDeviceType;
        private String serviceOfferingId;
        private String serviceOfferingName;
        private State state;
        private String templateDisplayText;
        private String templateId;
        private String templateName;
        private String zoneId;
        private String zoneName;
        private Set<NIC> nics = ImmutableSet.of();
        private String hypervisor;
        private Set<SecurityGroup> securityGroups = ImmutableSet.of();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder cpuCount(long cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public Builder cpuSpeed(long cpuSpeed) {
            this.cpuSpeed = cpuSpeed;
            return this;
        }

        public Builder cpuUsed(String cpuUsed) {
            this.cpuUsed = cpuUsed;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder usesVirtualNetwork(boolean usesVirtualNetwork) {
            this.usesVirtualNetwork = usesVirtualNetwork;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder guestOSId(String guestOSId) {
            this.guestOSId = guestOSId;
            return this;
        }

        public Builder isHAEnabled(boolean HAEnabled) {
            this.HAEnabled = HAEnabled;
            return this;
        }

        public Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder IPAddress(String IPAddress) {
            this.IPAddress = IPAddress;
            return this;
        }

        public Builder ISODisplayText(String ISODisplayText) {
            this.ISODisplayText = ISODisplayText;
            return this;
        }

        public Builder ISOId(String ISOId) {
            this.ISOId = ISOId;
            return this;
        }

        public Builder ISOName(String ISOName) {
            this.ISOName = ISOName;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobStatus(int jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public Builder memory(long memory) {
            this.memory = memory;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder networkKbsRead(Long networkKbsRead) {
            this.networkKbsRead = networkKbsRead;
            return this;
        }

        public Builder networkKbsWrite(Long networkKbsWrite) {
            this.networkKbsWrite = networkKbsWrite;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder passwordEnabled(boolean passwordEnabled) {
            this.passwordEnabled = passwordEnabled;
            return this;
        }

        public Builder publicIP(String publicIP) {
            this.publicIP = publicIP;
            return this;
        }

        public Builder publicIPId(String publicIPId) {
            this.publicIPId = publicIPId;
            return this;
        }

        public Builder rootDeviceId(String rootDeviceId) {
            this.rootDeviceId = rootDeviceId;
            return this;
        }

        public Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        public Builder serviceOfferingId(String serviceOfferingId) {
            this.serviceOfferingId = serviceOfferingId;
            return this;
        }

        public Builder serviceOfferingName(String serviceOfferingName) {
            this.serviceOfferingName = serviceOfferingName;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder templateDisplayText(String templateDisplayText) {
            this.templateDisplayText = templateDisplayText;
            return this;
        }

        public Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder nics(Iterable<NIC> nics) {
            this.nics = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(nics, (Object)"nics")));
            return this;
        }

        public Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public Builder securityGroups(Set<SecurityGroup> securityGroups) {
            this.securityGroups = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(securityGroups, (Object)"securityGroups")));
            return this;
        }

        public VirtualMachine build() {
            return new VirtualMachine(this.id, this.account, this.cpuCount, this.cpuSpeed, this.cpuUsed, this.displayName, this.created, this.domain, this.domainId, this.usesVirtualNetwork, this.group, this.groupId, this.guestOSId, this.HAEnabled, this.hostId, this.hostname, this.IPAddress, this.ISODisplayText, this.ISOId, this.ISOName, this.jobId, this.jobStatus, this.memory, this.name, this.networkKbsRead, this.networkKbsWrite, this.password, this.passwordEnabled, this.publicIP, this.publicIPId, this.rootDeviceId, this.rootDeviceType, this.securityGroups, this.serviceOfferingId, this.serviceOfferingName, this.state, this.templateDisplayText, this.templateId, this.templateName, this.zoneId, this.zoneName, this.nics, this.hypervisor);
        }
    }
}

